/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.builtins.modules.zlib.JavaDecompress;
import com.oracle.graal.python.builtins.modules.zlib.NativeZlibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZLibCompObject;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.truffle.api.object.Shape;

public class ZlibDecompressorObject
extends PythonBuiltinObject {
    private final ZLibCompObject compObject;
    private long availInReal;
    private boolean needsInput;

    private ZlibDecompressorObject(Object cls, Shape instanceShape, Object zst, NFIZlibSupport zlibSupport) {
        super(cls, instanceShape);
        this.compObject = new NativeZlibCompObject(cls, instanceShape, zst, zlibSupport);
        this.availInReal = 0L;
        this.needsInput = true;
    }

    private ZlibDecompressorObject(Object cls, Shape instanceShape, int wbits, byte[] zdict) {
        super(cls, instanceShape);
        this.compObject = new JavaDecompress(cls, instanceShape, wbits, zdict);
        this.availInReal = 0L;
        this.needsInput = true;
    }

    public boolean isInitialized() {
        return this.compObject.isInitialized();
    }

    public boolean isEof() {
        return this.compObject.isEof();
    }

    public void setEof(boolean eof) {
        this.compObject.setEof(eof);
    }

    public Object getZst() {
        assert (this.isNative());
        return ((NativeZlibCompObject)this.compObject).getZst();
    }

    public JavaDecompress getStream() {
        assert (!this.isNative());
        return (JavaDecompress)this.compObject;
    }

    public long getAvailInReal() {
        return this.availInReal;
    }

    public void setAvailInReal(long avail_in_real) {
        this.availInReal = avail_in_real;
    }

    public boolean isNeedsInput() {
        return this.needsInput;
    }

    public void setNeedsInput(boolean needs_input) {
        this.needsInput = needs_input;
    }

    public PBytes getUnusedData() {
        return this.compObject.getUnusedData();
    }

    public void setUnusedData(PBytes unusedData) {
        this.compObject.setUnusedData(unusedData);
    }

    public PBytes getUnconsumedTail() {
        return this.compObject.getUnconsumedTail();
    }

    public void setUnconsumedTail(PBytes unconsumedTail) {
        this.compObject.setUnconsumedTail(unconsumedTail);
    }

    public boolean isNative() {
        return this.compObject instanceof NativeZlibCompObject;
    }

    public static ZlibDecompressorObject createNative(Object cls, Shape instanceShape, Object zst, NFIZlibSupport zlibSupport) {
        return new ZlibDecompressorObject(cls, instanceShape, zst, zlibSupport);
    }

    public static ZlibDecompressorObject createJava(Object cls, Shape instanceShape, int wbits, byte[] zdict) {
        return new ZlibDecompressorObject(cls, instanceShape, wbits, zdict);
    }
}

