/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.frontend.FrontendApplicationInfo;
import com.intellij.frontend.FrontendType;
import com.intellij.idea.AppMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PlatformUtils;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0007\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0001H\u0002\u00a8\u0006\u0007"}, d2={"shouldEnableServicesViewInCurrentEnvironment", "", "isFrontend", "isMonolith", "isBackend", "isNewFrontendServiceViewEnabled", "isOldMonolithServiceViewEnabled", "intellij.platform.execution.serviceView"})
@SourceDebugExtension(value={"SMAP\nserviceViewImplementationChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 serviceViewImplementationChooser.kt\ncom/intellij/platform/execution/serviceView/ServiceViewImplementationChooserKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,46:1\n58#2:47\n36#2,2:48\n*S KotlinDebug\n*F\n+ 1 serviceViewImplementationChooser.kt\ncom/intellij/platform/execution/serviceView/ServiceViewImplementationChooserKt\n*L\n22#1:47\n22#1:48,2\n*E\n"})
public final class ServiceViewImplementationChooserKt {
    @ApiStatus.Internal
    public static final boolean shouldEnableServicesViewInCurrentEnvironment() {
        boolean isServicesEnabled = ServiceViewImplementationChooserKt.isFrontend() && ServiceViewImplementationChooserKt.isNewFrontendServiceViewEnabled() ? true : (ServiceViewImplementationChooserKt.isBackend() && ServiceViewImplementationChooserKt.isOldMonolithServiceViewEnabled() ? true : ServiceViewImplementationChooserKt.isMonolith());
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Services implementation is " + (isServicesEnabled ? "enabled" : "disabled") + " in current environment. Is frontend: " + ServiceViewImplementationChooserKt.isFrontend() + ", is monolith: " + ServiceViewImplementationChooserKt.isMonolith() + ", is backend: " + ServiceViewImplementationChooserKt.isBackend() + ".");
        return isServicesEnabled;
    }

    private static final boolean isFrontend() {
        return PlatformUtils.isJetBrainsClient();
    }

    private static final boolean isMonolith() {
        return FrontendApplicationInfo.INSTANCE.getFrontendType() instanceof FrontendType.Monolith && !ServiceViewImplementationChooserKt.isBackend() && !ServiceViewImplementationChooserKt.isFrontend();
    }

    private static final boolean isBackend() {
        return AppMode.isRemoteDevHost();
    }

    private static final boolean isNewFrontendServiceViewEnabled() {
        return Registry.Companion.is("services.view.split.enabled");
    }

    private static final boolean isOldMonolithServiceViewEnabled() {
        return Registry.Companion.is("services.view.monolith.enabled");
    }
}

