/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.Map;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.draw.WeeklyHeaderStrategy;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.time.WeekNumberStrategy;
import net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;

public class TimeHeaderWeekly
extends TimeHeaderCalendar {
    private final WeekNumberStrategy weekNumberStrategy;
    private final WeeklyHeaderStrategy headerStrategy;
    private final int weekStartingNumber;
    private final Map<Day, String> nameDays;

    private double getH1(StringBounder stringBounder) {
        double h = this.thParam.getStyle(SName.timeline, SName.month).value(PName.FontSize).asDouble() + 4.0;
        return h;
    }

    private double getH2(StringBounder stringBounder) {
        double h = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble() + 1.0;
        return this.getH1(stringBounder) + h;
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        return this.getH2(stringBounder);
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h = this.thParam.getStyle(SName.timeline, SName.month).value(PName.FontSize).asDouble() + 4.0;
        return h;
    }

    private double getHeaderNameDayHeight() {
        if (this.nameDays.size() > 0) {
            double h = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble() + 6.0;
            return h;
        }
        return 0.0;
    }

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    public TimeHeaderWeekly(StringBounder stringBounder, TimeHeaderParameters thParam, WeekNumberStrategy weekNumberStrategy, WeeklyHeaderStrategy headerStrategy, Map<Day, String> nameDays, Day printStart, int weekStartingNumber) {
        super(thParam, new TimeScaleCompressed(thParam.getCellWidth(stringBounder), thParam.getStartingDay(), thParam.getScale(), printStart));
        this.weekNumberStrategy = weekNumberStrategy;
        this.headerStrategy = headerStrategy;
        this.nameDays = nameDays;
        this.weekStartingNumber = weekStartingNumber;
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawCalendar(ug, totalHeightWithoutFooter);
        this.printNamedDays(ug);
        this.drawHline(ug, 0.0);
        this.drawHline(ug, this.getH1(ug.getStringBounder()));
        this.drawHline(ug, this.getFullHeaderHeight(ug.getStringBounder()));
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        this.drawHline(ug, 0.0);
        this.printMonths(ug);
        this.drawHline(ug, this.getTimeFooterHeight(ug.getStringBounder()));
    }

    private void drawCalendar(UGraphic ug, double totalHeightWithoutFooter) {
        this.printDaysOfMonth(ug);
        this.printVerticalSeparators(ug, totalHeightWithoutFooter);
        this.printMonths(ug);
    }

    private void printMonths(UGraphic ug) {
        MonthYear last = null;
        double lastChangeMonth = -1.0;
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!wink.monthYear().equals(last)) {
                this.drawVline(ug.apply(this.getLineColor()), x1, 0.0, this.getH1(ug.getStringBounder()));
                if (last != null) {
                    this.printMonth(ug, last, lastChangeMonth, x1);
                }
                lastChangeMonth = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        this.drawVline(ug.apply(this.getLineColor()), this.getTimeScale().getEndingPosition(this.getMax()), 0.0, this.getH1(ug.getStringBounder()));
        double x1 = this.getTimeScale().getStartingPosition(this.getMax().increment());
        if (last != null && x1 > lastChangeMonth) {
            this.printMonth(ug, last, lastChangeMonth, x1);
        }
    }

    private void printNamedDays(UGraphic ug) {
        if (this.nameDays.size() > 0) {
            String last = null;
            Day wink = this.getMin();
            while (wink.compareTo(this.getMax().increment()) <= 0) {
                String name = this.nameDays.get(wink);
                if (name != null && !name.equals(last)) {
                    double x1 = this.getTimeScale().getStartingPosition(wink);
                    double x2 = this.getTimeScale().getEndingPosition(wink);
                    TextBlock label = this.getTextBlock(SName.month, name, false, this.openFontColor());
                    double h = label.calculateDimension(ug.getStringBounder()).getHeight();
                    double y1 = this.getTimeHeaderHeight(ug.getStringBounder());
                    double y2 = this.getFullHeaderHeight(ug.getStringBounder());
                    double position = this.getH2(ug.getStringBounder());
                    label.drawU(ug.apply(new UTranslate(x1, position)));
                }
                last = name;
                wink = wink.increment();
            }
        }
    }

    @Override
    protected void printVerticalSeparators(UGraphic ug, double totalHeightWithoutFooter) {
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) <= 0) {
            if (wink.getDayOfWeek() == this.weekNumberStrategy.getFirstDayOfWeek()) {
                this.drawVline(ug.apply(this.getLineColor()), this.getTimeScale().getStartingPosition(wink), this.getH1(ug.getStringBounder()), totalHeightWithoutFooter);
            }
            wink = wink.increment();
        }
        this.drawVline(ug.apply(this.getLineColor()), this.getTimeScale().getEndingPosition(this.getMax()), this.getH1(ug.getStringBounder()), totalHeightWithoutFooter);
        super.printVerticalSeparators(ug, totalHeightWithoutFooter);
    }

    private void printDaysOfMonth(UGraphic ug) {
        int counter = this.weekStartingNumber;
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) < 0) {
            if (wink.getDayOfWeek() == this.weekNumberStrategy.getFirstDayOfWeek()) {
                String num = this.headerStrategy == WeeklyHeaderStrategy.FROM_N ? "" + counter++ : (this.headerStrategy == WeeklyHeaderStrategy.DAY_OF_MONTH ? "" + wink.getDayOfMonth() : "" + wink.getWeekOfYear(this.weekNumberStrategy));
                TextBlock textBlock = this.getTextBlock(SName.day, num, false, this.openFontColor());
                this.printLeft(ug.apply(UTranslate.dy(this.getH1(ug.getStringBounder()))), textBlock, this.getTimeScale().getStartingPosition(wink) + 5.0);
            }
            wink = wink.increment();
        }
    }

    private void printMonth(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock(SName.month, monthYear.shortName(this.locale()), true, this.openFontColor());
        TextBlock big = this.getTextBlock(SName.month, monthYear.shortNameYYYY(this.locale()), true, this.openFontColor());
        this.printCentered(ug, false, start, end, small, big);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }
}

