/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.ArrayList;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.BigDelimiterAtom;
import org.scilab.forge.jlatexmath.OverlinedAtom;
import org.scilab.forge.jlatexmath.PhantomAtom;
import org.scilab.forge.jlatexmath.RaiseAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.RuleAtom;
import org.scilab.forge.jlatexmath.SmashedAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.UnderlinedAtom;
import org.scilab.forge.jlatexmath.VRowAtom;

public class LongdivAtom
extends VRowAtom {
    public LongdivAtom(long divisor, long dividend) {
        this.setHalign(1);
        this.setVtop(true);
        String[] res = this.makeResults(divisor, dividend);
        RuleAtom rule = new RuleAtom(1, 0.0f, 1, 2.6f, 1, 0.5f);
        for (int i = 0; i < res.length; ++i) {
            RowAtom ra;
            Atom num = new TeXFormula((String)res[i]).root;
            if (i % 2 == 0) {
                ra = new RowAtom(num);
                ra.add(rule);
                if (i == 0) {
                    this.append(ra);
                    continue;
                }
                this.append(new UnderlinedAtom(ra));
                continue;
            }
            if (i == 1) {
                String div = Long.toString(divisor);
                SymbolAtom rparen = SymbolAtom.get(TeXFormula.symbolMappings[41]);
                BigDelimiterAtom big = new BigDelimiterAtom(rparen, 1);
                PhantomAtom ph = new PhantomAtom(big, false, true, true);
                RowAtom ra2 = new RowAtom(ph);
                RaiseAtom raised = new RaiseAtom(big, 13, 3.5f, 13, 0.0f, 13, 0.0f);
                ra2.add(new SmashedAtom(raised));
                ra2.add(num);
                OverlinedAtom a = new OverlinedAtom(ra2);
                RowAtom ra1 = new RowAtom(new TeXFormula((String)div).root);
                ra1.add(new SpaceAtom(1));
                ra1.add(a);
                this.append(ra1);
                continue;
            }
            ra = new RowAtom(num);
            ra.add(rule);
            this.append(ra);
        }
    }

    private String[] makeResults(long divisor, long dividend) {
        long d;
        long q;
        ArrayList<String> vec = new ArrayList<String>();
        vec.add(Long.toString(q));
        vec.add(Long.toString(dividend));
        for (q = dividend / divisor; q != 0L; q -= d) {
            double p = Math.floor(Math.log10(q));
            double p10 = Math.pow(10.0, p);
            d = (long)(Math.floor((double)q / p10) * p10);
            long dd = d * divisor;
            vec.add(Long.toString(dd));
            vec.add(Long.toString(dividend -= dd));
        }
        String[] res = new String[vec.size()];
        return vec.toArray(res);
    }
}

