/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.datasource;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tribuo.ConfigurableDataSource;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.datasource.AggregateDataSource;
import org.tribuo.provenance.DataSourceProvenance;

public class AggregateConfigurableDataSource<T extends Output<T>>
implements ConfigurableDataSource<T> {
    @Config(mandatory=true, description="The iteration order.")
    private AggregateDataSource.IterationOrder order;
    @Config(mandatory=true, description="The sources to aggregate.")
    private List<ConfigurableDataSource<T>> sources;

    public AggregateConfigurableDataSource(List<ConfigurableDataSource<T>> sources) {
        this(sources, AggregateDataSource.IterationOrder.SEQUENTIAL);
    }

    public AggregateConfigurableDataSource(List<ConfigurableDataSource<T>> sources, AggregateDataSource.IterationOrder order) {
        this.sources = Collections.unmodifiableList(new ArrayList<ConfigurableDataSource<T>>(sources));
        this.order = order;
    }

    public String toString() {
        return "AggregateConfigurableDataSource(sources=" + this.sources.toString() + ",order=" + (Object)((Object)this.order) + ")";
    }

    @Override
    public OutputFactory<T> getOutputFactory() {
        return this.sources.get(0).getOutputFactory();
    }

    @Override
    public Iterator<Example<T>> iterator() {
        switch (this.order) {
            case ROUNDROBIN: {
                return new AggregateDataSource.ADSRRIterator<T>(this.sources);
            }
            case SEQUENTIAL: {
                return new AggregateDataSource.ADSSeqIterator<T>(this.sources);
            }
        }
        throw new IllegalStateException("Unknown enum value " + (Object)((Object)this.order));
    }

    public DataSourceProvenance getProvenance() {
        return new AggregateConfigurableDataSourceProvenance(this);
    }

    public static class AggregateConfigurableDataSourceProvenance
    extends SkeletalConfiguredObjectProvenance
    implements DataSourceProvenance {
        private static final long serialVersionUID = 1L;

        <T extends Output<T>> AggregateConfigurableDataSourceProvenance(AggregateConfigurableDataSource<T> host) {
            super(host, "DataSource");
        }

        public AggregateConfigurableDataSourceProvenance(Map<String, Provenance> map) {
            this(AggregateConfigurableDataSourceProvenance.extractProvenanceInfo(map));
        }

        private AggregateConfigurableDataSourceProvenance(SkeletalConfiguredObjectProvenance.ExtractedInfo info) {
            super(info);
        }

        protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
            HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
            String className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"class-name", StringProvenance.class, (String)AggregateConfigurableDataSourceProvenance.class.getSimpleName())).getValue();
            String hostTypeStringName = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(configuredParameters, (String)"host-short-name", StringProvenance.class, (String)AggregateConfigurableDataSourceProvenance.class.getSimpleName())).getValue();
            return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, Collections.emptyMap());
        }
    }
}

