/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedOperationId
implements Changed {
    private final String left;
    private final String right;
    private final DiffContext context;

    public ChangedOperationId(String left, String right, DiffContext context) {
        this.left = left;
        this.right = right;
        this.context = context;
    }

    @Override
    public DiffResult isChanged() {
        if (Objects.equals(this.left, this.right)) {
            return DiffResult.NO_CHANGES;
        }
        if (BackwardIncompatibleProp.OPERATION_ID_CHANGED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.METADATA;
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }
}

