/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.theme.ClassLoaderTheme;
import org.keycloak.theme.ClasspathThemeProvider;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;
import org.keycloak.theme.ThemeProviderFactory;
import org.keycloak.util.JsonSerialization;

public class ClasspathThemeProviderFactory
implements ThemeProviderFactory {
    public static final String KEYCLOAK_THEMES_JSON = "META-INF/keycloak-themes.json";
    protected static Map<Theme.Type, Map<String, ClassLoaderTheme>> themes = new HashMap<Theme.Type, Map<String, ClassLoaderTheme>>();
    private String id;

    public ClasspathThemeProviderFactory(String id) {
        this.id = id;
    }

    public ClasspathThemeProviderFactory(String id, ClassLoader classLoader) {
        this.id = id;
        this.loadThemes(classLoader, classLoader.getResourceAsStream(KEYCLOAK_THEMES_JSON));
    }

    public ThemeProvider create(KeycloakSession session) {
        return new ClasspathThemeProvider(themes);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return this.id;
    }

    protected void loadThemes(ClassLoader classLoader, InputStream themesInputStream) {
        try {
            this.loadThemes(classLoader, (ThemesRepresentation)JsonSerialization.readValue((InputStream)themesInputStream, ThemesRepresentation.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load themes", e);
        }
    }

    protected void loadThemes(ClassLoader classLoader, ThemesRepresentation themesRep) {
        try {
            for (ThemeRepresentation themeRep : themesRep.getThemes()) {
                for (String t : themeRep.getTypes()) {
                    Theme.Type type = Theme.Type.valueOf((String)t.toUpperCase());
                    if (!themes.containsKey(type)) {
                        themes.put(type, new HashMap());
                    }
                    themes.get(type).put(themeRep.getName(), new ClassLoaderTheme(themeRep.getName(), type, classLoader));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load themes", e);
        }
    }

    public static class ThemesRepresentation {
        private ThemeRepresentation[] themes;

        public ThemeRepresentation[] getThemes() {
            return this.themes;
        }

        public void setThemes(ThemeRepresentation[] themes) {
            this.themes = themes;
        }
    }

    public static class ThemeRepresentation {
        private String name;
        private String[] types;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[] getTypes() {
            return this.types;
        }

        public void setTypes(String[] types) {
            this.types = types;
        }
    }
}

