/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.beans.container.internal;

import jakarta.enterprise.inject.spi.BeanManager;
import org.hibernate.resource.beans.container.spi.AbstractCdiBeanContainer;
import org.hibernate.resource.beans.container.spi.BeanLifecycleStrategy;
import org.hibernate.resource.beans.container.spi.ContainedBeanImplementor;
import org.hibernate.resource.beans.internal.BeansMessageLogger;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;

public class CdiBeanContainerImmediateAccessImpl
extends AbstractCdiBeanContainer {
    private final BeanManager beanManager;

    CdiBeanContainerImmediateAccessImpl(BeanManager beanManager) {
        BeansMessageLogger.BEANS_MSG_LOGGER.standardAccessToBeanManager();
        this.beanManager = beanManager;
    }

    @Override
    public BeanManager getUsableBeanManager() {
        return this.beanManager;
    }

    @Override
    protected <B> ContainedBeanImplementor<B> createBean(Class<B> beanType, BeanLifecycleStrategy lifecycleStrategy, BeanInstanceProducer fallbackProducer) {
        ContainedBeanImplementor<B> bean = lifecycleStrategy.createBean(beanType, fallbackProducer, this);
        bean.initialize();
        return bean;
    }

    @Override
    protected <B> ContainedBeanImplementor<B> createBean(String name, Class<B> beanType, BeanLifecycleStrategy lifecycleStrategy, BeanInstanceProducer fallbackProducer) {
        ContainedBeanImplementor<B> bean = lifecycleStrategy.createBean(name, beanType, fallbackProducer, this);
        bean.initialize();
        return bean;
    }
}

