/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.JmolNMRInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.Model;
import org.jmol.quantum.NMRNoeMatrix;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class NMRCalculation
implements JmolNMRInterface {
    private static final int MAGNETOGYRIC_RATIO = 1;
    private static final int QUADRUPOLE_MOMENT = 2;
    private static final double e_charge = 1.60217646E-19;
    private static final double h_planck = 6.62606957E-34;
    private static final double h_bar_planck = 1.0545717253362894E-34;
    private static final double DIPOLAR_FACTOR = 1054.5717253362893;
    private static final double J_FACTOR = 0.0167840302932219;
    private static final double Q_FACTOR = 2.349647144641375E8;
    public static final int MODE_CALC_INVALID = 0;
    public static final int MODE_CALC_2JHH = 1;
    public static final int MODE_CALC_3JHH = 2;
    public static final int MODE_CALC_JHH = 3;
    public static final int MODE_CALC_3JCH = 4;
    public static final int MODE_CALC_J = 7;
    public static final int MODE_CALC_NOE = 8;
    public static final int MODE_CALC_ALL = 15;
    private Viewer vwr;
    private Map<String, double[]> isotopeData;
    private static final String resource = "nmr_data.txt";
    private Map<String, Float> shiftRefsPPM = new Hashtable<String, Float>();
    static Hashtable<String, Double> deltaElectro = new Hashtable();
    static double[][] pAltona;
    public static final String JCH3_NONE = "none";
    public static final String JCH3_WASYLISHEN_SCHAEFER = "was";
    public static final String JCH3_TVAROSKA_TARAVEL = "tva";
    public static final String JCH3_AYDIN_GUETHER = "ayd";

    @Override
    public JmolNMRInterface setViewer(Viewer vwr) {
        this.vwr = vwr;
        this.getData();
        return this;
    }

    @Override
    public float getQuadrupolarConstant(Tensor efg) {
        if (efg == null) {
            return 0.0f;
        }
        Atom a = this.vwr.ms.at[efg.atomIndex1];
        return (float)(this.getIsotopeData(a, 2) * (double)efg.eigenValues[2] * 2.349647144641375E8);
    }

    private Lst<Tensor> getInteractionTensorList(String type, BS bsA) {
        if (type != null) {
            type = type.toLowerCase();
        }
        BS bsModels = this.vwr.ms.getModelBS(bsA, false);
        BS bs1 = this.getAtomSiteBS(bsA);
        int iAtom = bs1.cardinality() == 1 ? bs1.nextSetBit(0) : -1;
        Lst<Tensor> list = new Lst<Tensor>();
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            Lst tensors = (Lst)this.vwr.ms.getInfo(i, "interactionTensors");
            if (tensors != null) {
                int n = tensors.size();
                for (int j = 0; j < n; ++j) {
                    Tensor t = (Tensor)tensors.get(j);
                    if (type != null && (!t.type.equals(type) || !t.isSelected(bs1, iAtom))) continue;
                    list.addLast(t);
                }
            }
            i = bsModels.nextSetBit(i + 1);
        }
        return list;
    }

    private BS getAtomSiteBS(BS bsA) {
        if (bsA == null) {
            return null;
        }
        BS bs = new BS();
        Atom[] atoms = this.vwr.ms.at;
        Model[] models = this.vwr.ms.am;
        int i = bsA.nextSetBit(0);
        while (i >= 0) {
            if (bsA.get(i)) {
                Atom a = atoms[i];
                bs.set(models[a.mi].firstAtomIndex - 1 + a.getAtomSite());
            }
            i = bsA.nextSetBit(i + 1);
        }
        return bs;
    }

    @Override
    public BS getUniqueTensorSet(BS bsAtoms) {
        BS bs = new BS();
        Atom[] atoms = this.vwr.ms.at;
        int mi = this.vwr.ms.mc;
        while (--mi >= 0) {
            BS bsModelAtoms = this.vwr.restrictToModel(bsAtoms, mi);
            if (this.vwr.ms.getUnitCell(mi) == null) continue;
            int i = bsModelAtoms.nextSetBit(0);
            while (i >= 0) {
                if (atoms[i].getAtomSite() != atoms[i].i + 1) {
                    bsModelAtoms.clear(i);
                }
                i = bsModelAtoms.nextSetBit(i + 1);
            }
            bs.or(bsModelAtoms);
            i = bsModelAtoms.nextSetBit(0);
            while (i >= 0) {
                Object[] ta = atoms[i].getTensors();
                if (ta != null) {
                    int jj = ta.length;
                    while (--jj >= 0) {
                        Tensor t = (Tensor)ta[jj];
                        if (t == null) continue;
                        int k = bsModelAtoms.nextSetBit(i + 1);
                        while (k >= 0) {
                            Object[] tb = atoms[k].getTensors();
                            if (tb != null) {
                                int kk = tb.length;
                                while (--kk >= 0) {
                                    if (!t.isEquiv((Tensor)tb[kk])) continue;
                                    bsModelAtoms.clear(k);
                                    bs.clear(k);
                                    break;
                                }
                            }
                            k = bsModelAtoms.nextSetBit(k + 1);
                        }
                    }
                }
                i = bsModelAtoms.nextSetBit(i + 1);
            }
        }
        return bs;
    }

    public float getJCouplingHz(Atom a1, Atom a2, String type, Tensor isc) {
        return this.getIsoOrAnisoHz(true, a1, a2, type, isc);
    }

    @Override
    public float getIsoOrAnisoHz(boolean isIso, Atom a1, Atom a2, String units, Tensor isc) {
        if (isc == null) {
            String type = this.getISCtype(a1, units);
            if (type == null || a1.mi != a2.mi) {
                if (!units.equals("hz")) {
                    return 0.0f;
                }
                double[] data = NMRCalculation.calc2or3JorNOE(this.vwr, new Atom[]{a1, null, null, a2}, null, 3);
                return data == null ? Float.NaN : (float)data[1];
            }
            BS bs = new BS();
            bs.set(a1.i);
            bs.set(a2.i);
            Lst<Tensor> list = this.getInteractionTensorList(type, bs);
            if (list.size() == 0) {
                return Float.NaN;
            }
            isc = (Tensor)list.get(0);
        } else {
            a1 = this.vwr.ms.at[isc.atomIndex1];
            a2 = this.vwr.ms.at[isc.atomIndex2];
        }
        return (float)(this.getIsotopeData(a1, 1) * this.getIsotopeData(a2, 1) * (double)(isIso ? isc.isotropy() : isc.anisotropy()) * 0.0167840302932219);
    }

    private String getISCtype(Atom a1, String type) {
        Lst tensors = (Lst)this.vwr.ms.getInfo(a1.mi, "interactionTensors");
        if (tensors == null) {
            return null;
        }
        type = type == null ? "" : type.toLowerCase();
        int pt = -1;
        pt = type.indexOf("_hz");
        if (pt >= 0 || (pt = type.indexOf("_khz")) >= 0 || (pt = type.indexOf("hz")) >= 0 || (pt = type.indexOf("khz")) >= 0) {
            type = type.substring(0, pt);
        }
        if (type.length() == 0) {
            type = "isc";
        }
        return type;
    }

    @Override
    public float getDipolarConstantHz(Atom a1, Atom a2) {
        float v;
        if (Logger.debugging) {
            Logger.debug(a1 + " g=" + this.getIsotopeData(a1, 1) + "; " + a2 + " g=" + this.getIsotopeData(a2, 1));
        }
        return (v = (float)(-this.getIsotopeData(a1, 1) * this.getIsotopeData(a2, 1) / Math.pow(a1.distance(a2), 3.0) * 1054.5717253362893)) == 0.0f || a1 == a2 ? Float.NaN : v;
    }

    @Override
    public float getDipolarCouplingHz(Atom a1, Atom a2, V3 vField) {
        V3 v12 = V3.newVsub(a2, a1);
        double r = v12.length();
        double costheta = (double)v12.dot(vField) / r / (double)vField.length();
        return (float)((double)this.getDipolarConstantHz(a1, a2) * (3.0 * costheta - 1.0) / 2.0);
    }

    private double getIsotopeData(Atom a, int iType) {
        int iso = a.getIsotopeNumber();
        String sym = a.getElementSymbolIso(false);
        double[] d = this.isotopeData.get(iso == 0 ? sym : "" + iso + sym);
        return d == null ? 0.0 : d[iType];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getData() {
        BufferedReader br = null;
        try {
            String line;
            boolean debugging = Logger.debugging;
            br = FileManager.getBufferedReaderForResource(this.vwr, NMRCalculation.class, "org/jmol/quantum/", resource);
            this.isotopeData = new Hashtable<String, double[]>();
            while ((line = br.readLine()) != null) {
                if (debugging) {
                    Logger.info(line);
                }
                if (line.indexOf("#") >= 0) continue;
                String[] tokens = PT.getTokens(line);
                String name = tokens[0];
                String defaultIso = tokens[2] + name;
                if (debugging) {
                    Logger.info(name + " default isotope " + defaultIso);
                }
                for (int i = 3; i < tokens.length; i += 3) {
                    int n = Integer.parseInt(tokens[i]);
                    String isoname = n + name;
                    double[] dataGQ = new double[]{n, Double.parseDouble(tokens[i + 1]), Double.parseDouble(tokens[i + 2])};
                    if (debugging) {
                        Logger.info(isoname + "  " + Escape.eAD(dataGQ));
                    }
                    this.isotopeData.put(isoname, dataGQ);
                }
                double[] defdata = this.isotopeData.get(defaultIso);
                if (defdata == null) {
                    Logger.error("Cannot find default NMR data in nmr_data.txt for " + defaultIso);
                    throw new NullPointerException();
                }
                defdata[0] = -defdata[0];
                this.isotopeData.put(name, defdata);
            }
        }
        catch (Exception e) {
            Logger.error("Exception " + e.toString() + " reading " + resource);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Object getInfo(String what) {
        if (what.equals("all")) {
            Hashtable<String, Map<String, Object>> map = new Hashtable<String, Map<String, Object>>();
            map.put("isotopes", this.isotopeData);
            map.put("shiftRefsPPM", this.shiftRefsPPM);
            return map;
        }
        if (PT.isDigit(what.charAt(0))) {
            return this.isotopeData.get(what);
        }
        Lst<double[]> info = new Lst<double[]>();
        for (Map.Entry<String, double[]> e : this.isotopeData.entrySet()) {
            String key = e.getKey();
            if (!PT.isDigit(key.charAt(0)) || !key.endsWith(what)) continue;
            info.addLast(e.getValue());
        }
        return info;
    }

    @Override
    public float getChemicalShift(Atom atom) {
        float v = this.getMagneticShielding(atom);
        if (Float.isNaN(v)) {
            return v;
        }
        Float ref = this.shiftRefsPPM.get(atom.getElementSymbol());
        return (ref == null ? 0.0f : ref.floatValue()) - v;
    }

    @Override
    public float getMagneticShielding(Atom atom) {
        Tensor t = this.vwr.ms.getAtomTensor(atom.i, "ms");
        return t == null ? Float.NaN : t.isotropy();
    }

    @Override
    public boolean getState(SB sb) {
        if (this.shiftRefsPPM.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Float> nuc : this.shiftRefsPPM.entrySet()) {
            sb.append("  set shift_").append(nuc.getKey()).append(" ").appendO(nuc.getValue()).append("\n");
        }
        return true;
    }

    @Override
    public boolean setChemicalShiftReference(String element, float value) {
        if (element == null) {
            this.shiftRefsPPM.clear();
            return false;
        }
        element = element.substring(0, 1).toUpperCase() + element.substring(1);
        this.shiftRefsPPM.put(element, Float.valueOf(value));
        return true;
    }

    @Override
    public Lst<Object> getTensorInfo(String tensorType, String infoType, BS bs) {
        if ("".equals(tensorType)) {
            tensorType = null;
        }
        infoType = infoType == null ? ";all." : ";" + infoType + ".";
        Lst<Object> data = new Lst<Object>();
        if (";dc.".equals(infoType)) {
            Atom[] atoms = this.vwr.ms.at;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                int j = bs.nextSetBit(i + 1);
                while (j >= 0) {
                    Lst<Number> list1 = new Lst<Number>();
                    list1.addLast(atoms[i].i);
                    list1.addLast(atoms[j].i);
                    list1.addLast(Float.valueOf(this.getDipolarConstantHz(atoms[i], atoms[j])));
                    data.addLast(list1);
                    j = bs.nextSetBit(j + 1);
                }
                i = bs.nextSetBit(i + 1);
            }
            return data;
        }
        if (tensorType == null || tensorType.startsWith("isc")) {
            boolean isJ = infoType.equals(";j.");
            boolean isEta = infoType.equals(";eta.");
            Lst<Tensor> list = this.getInteractionTensorList(tensorType, bs);
            int n = list == null ? 0 : list.size();
            for (int i = 0; i < n; ++i) {
                Tensor t = (Tensor)list.get(i);
                Lst<Object> list1 = new Lst<Object>();
                list1.addLast(Integer.valueOf(t.atomIndex1));
                list1.addLast(Integer.valueOf(t.atomIndex2));
                list1.addLast(isEta || isJ ? Float.valueOf(this.getIsoOrAnisoHz(isJ, null, null, null, t)) : t.getInfo(infoType));
                data.addLast(list1);
            }
            if (tensorType != null) {
                return data;
            }
        }
        boolean isChi = tensorType != null && tensorType.startsWith("efg") && infoType.equals(";chi.");
        boolean isFloat = isChi || Tensor.isFloatInfo(infoType);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if (tensorType == null) {
                Object[] a = this.vwr.ms.getAtomTensorList(i);
                if (a != null) {
                    for (int j = 0; j < a.length; ++j) {
                        data.addLast(((Tensor)a[j]).getInfo(infoType));
                    }
                }
            } else {
                Tensor t = this.vwr.ms.getAtomTensor(i, tensorType);
                data.addLast(t == null ? (isFloat ? Float.valueOf(0.0f) : "") : (isChi ? Float.valueOf(this.getQuadrupolarConstant(t)) : t.getInfo(infoType)));
            }
            i = bs.nextSetBit(i + 1);
        }
        return data;
    }

    @Override
    public Map<String, Integer> getMinDistances(MeasurementData md) {
        BS bsPoints1 = (BS)md.points.get(0);
        int n1 = bsPoints1.cardinality();
        if (n1 == 0 || !(md.points.get(1) instanceof BS)) {
            return null;
        }
        BS bsPoints2 = (BS)md.points.get(1);
        int n2 = bsPoints2.cardinality();
        if (n1 < 2 && n2 < 2) {
            return null;
        }
        Hashtable<String, Integer> htMin = new Hashtable<String, Integer>();
        Atom[] atoms = this.vwr.ms.at;
        int i = bsPoints1.nextSetBit(0);
        while (i >= 0) {
            Atom a1 = atoms[i];
            String name = a1.getAtomName();
            int j = bsPoints2.nextSetBit(0);
            while (j >= 0) {
                Atom a2 = atoms[j];
                int d = (int)(a2.distanceSquared(a1) * 100.0f);
                if (d != 0) {
                    String name1 = a2.getAtomName();
                    String key = name.compareTo(name1) < 0 ? name + name1 : name1 + name;
                    Integer min = (Integer)htMin.get(key);
                    if (min == null) {
                        min = d;
                        htMin.put(key, min);
                    } else if (d < min) {
                        htMin.put(key, d);
                    }
                }
                j = bsPoints2.nextSetBit(j + 1);
            }
            i = bsPoints1.nextSetBit(i + 1);
        }
        return htMin;
    }

    public static double calcJKarplus(double theta) {
        double j0 = 8.5;
        double j180 = 9.5;
        double jconst = 0.28;
        double cos = Math.cos(theta);
        double jab = 0.0;
        jab = theta >= -90.0 && theta < 90.0 ? j0 * cos * cos - jconst : j180 * cos * cos - jconst;
        return jab;
    }

    private static double getInitialJValue(int nNonH, double theta) {
        double[] p = pAltona[nNonH];
        double cos = Math.cos(theta);
        return p[1] * cos * cos + p[2] * cos + p[3];
    }

    private static double getIncrementalJValue(int nNonH, String element, V3 sA_cA, V3 v21, V3 v23, double theta, int f) {
        if (nNonH < 0 || nNonH > 5) {
            return 0.0;
        }
        Double de = deltaElectro.get(element);
        if (de == null) {
            return 0.0;
        }
        double e = de;
        int sign = NMRCalculation.getSubSign(sA_cA, v21, v23, f);
        double[] p = pAltona[nNonH];
        double cos = Math.cos((double)sign * theta + p[6] * Math.abs(e));
        return e * (p[4] + p[5] * cos * cos);
    }

    private static int getSubSign(V3 sA_cA, V3 v21, V3 v23, int f) {
        V3 cross = new V3();
        cross.cross(v23, v21);
        return cross.dot(sA_cA) > 0.0f ? f : -f;
    }

    private static double calc3JHHOnly(String[][] subElements, V3[][] subVectors, V3 v21, V3 v34, V3 v23, double theta, boolean is23Double) {
        int n;
        int n2;
        int nNonH = 0;
        int n3 = n2 = is23Double ? 2 : 3;
        for (int i = 0; i < n2; ++i) {
            if (!subElements[0][i].equals("H")) {
                ++nNonH;
            }
            if (subElements[1][i].equals("H")) continue;
            ++nNonH;
        }
        double jvalue = NMRCalculation.getInitialJValue(nNonH, theta);
        int n4 = n = is23Double ? 2 : 3;
        for (int i = 0; i < n; ++i) {
            String element = subElements[0][i];
            if (!element.equals("H")) {
                jvalue += NMRCalculation.getIncrementalJValue(nNonH, element, subVectors[0][i], v21, v23, theta, 1);
            }
            if ((element = subElements[1][i]).equals("H")) continue;
            jvalue += NMRCalculation.getIncrementalJValue(nNonH, element, subVectors[1][i], v34, v23, theta, -1);
        }
        if (is23Double) {
            jvalue = Math.abs(theta) < 1.5707963267948966 ? (jvalue *= 0.75) : (jvalue *= 1.33);
        }
        return jvalue;
    }

    public static double calc3JCH(String CHequation, double theta, boolean is23Double) {
        if (CHequation == null) {
            CHequation = JCH3_WASYLISHEN_SCHAEFER;
        }
        if (!PT.isOneOf(CHequation, ";was;tva;ayd;")) {
            throw new IllegalArgumentException("Equation must be one of was, tva, or ayd");
        }
        if (CHequation.equals(JCH3_WASYLISHEN_SCHAEFER)) {
            double A = 3.56;
            double C2 = 4.26;
            double j = 3.56 * Math.cos(2.0 * theta) - Math.cos(theta) + 4.26;
            return j;
        }
        if (CHequation.equals(JCH3_TVAROSKA_TARAVEL)) {
            double j = 4.5 - 0.87 * Math.cos(theta) + Math.cos(2.0 * theta);
            return j;
        }
        if (CHequation.equals(JCH3_AYDIN_GUETHER)) {
            double j = 5.8 * Math.pow(Math.cos(theta), 2.0) - 1.6 * Math.cos(theta) + 0.28 * Math.sin(2.0 * theta) - 0.02 * Math.sin(theta) + 0.52;
            return j;
        }
        return 0.0;
    }

    public static double[] calcNOE(Viewer viewer, Atom atom1, Atom atom2) {
        return NMRCalculation.calc2or3JorNOE(viewer, new Atom[]{atom1, null, null, atom2}, null, 7);
    }

    public static double[] calc2or3JorNOE(Viewer viewer, Atom[] atoms, String CHEquation, int mode) {
        Atom sub;
        if (CHEquation == null || CHEquation.equals(JCH3_NONE)) {
            mode &= 0xFFFFFFFB;
        }
        String[] elements = new String[4];
        mode = NMRCalculation.getCalcType(atoms, elements, mode);
        switch (mode) {
            default: {
                return null;
            }
            case 8: {
                return NMRCalculation.calcNOEImpl(viewer, atoms[0], atoms[3]);
            }
            case 1: {
                return NMRCalculation.calc2JHH(atoms[0], atoms[1], atoms[3]);
            }
            case 2: 
            case 4: 
        }
        String[][] subElements = new String[2][3];
        V3[][] subVectors = new V3[2][3];
        V3 v23 = V3.newVsub(atoms[2], atoms[1]);
        V3 v21 = V3.newVsub(atoms[0], atoms[1]);
        V3 v34 = V3.newVsub(atoms[3], atoms[2]);
        Lst subs = new Lst();
        Bond[] bonds = atoms[1].bonds;
        boolean is23Double = false;
        int pt = 0;
        int i = Math.min(bonds.length, 4);
        while (--i >= 0) {
            sub = bonds[i].getOtherAtom(atoms[1]);
            if (sub == atoms[2]) {
                is23Double = bonds[i].order == 2;
                continue;
            }
            subElements[0][pt] = sub.getElementSymbol();
            subVectors[0][pt] = V3.newVsub(sub, atoms[1]);
            ++pt;
        }
        subs.clear();
        bonds = atoms[2].bonds;
        pt = 0;
        i = Math.min(bonds.length, 4);
        while (--i >= 0) {
            sub = bonds[i].getOtherAtom(atoms[2]);
            if (sub == atoms[1]) continue;
            subElements[1][pt] = sub.getElementSymbol();
            subVectors[1][pt] = V3.newVsub(sub, atoms[2]);
            ++pt;
        }
        double theta = Measure.computeTorsion(atoms[0], atoms[1], atoms[2], atoms[3], false);
        double jvalue = Double.NaN;
        if (is23Double || subElements[0][2] != null && subElements[1][2] != null) {
            switch (mode) {
                case 2: {
                    jvalue = NMRCalculation.calc3JHHOnly(subElements, subVectors, v21, v34, v23, theta, is23Double);
                    break;
                }
                case 4: {
                    if (is23Double) {
                        return null;
                    }
                    jvalue = NMRCalculation.calc3JCH(CHEquation, theta, is23Double);
                }
            }
        } else {
            jvalue = NMRCalculation.calcJKarplus(theta);
        }
        return new double[]{theta, jvalue, atoms[1].i, atoms[2].i};
    }

    public static int getCalcType(Atom[] atoms, String[] elementsToFill, int mode) {
        boolean isHH;
        Atom atom1 = atoms[0];
        Atom atom4 = atoms[3];
        Bond[] bonds1 = atom1.bonds;
        Bond[] bonds4 = atom4.bonds;
        if (bonds1 == null || bonds4 == null || atom1.isCovalentlyBonded(atom4)) {
            return 0;
        }
        boolean allowNOE = (mode & 8) == 8;
        boolean allow3JHH = (mode & 2) == 2;
        boolean allow2JHH = (mode & 1) == 1;
        boolean allow3JCH = (mode & 4) == 4;
        boolean isGeminal = false;
        Atom atom2 = atoms[1];
        Atom atom3 = atoms[2];
        if (atom2 == null) {
            for (int i = 0; i < bonds1.length; ++i) {
                atom2 = bonds1[i].getOtherAtom(atom1);
                if (atom2.isCovalentlyBonded(atom4)) {
                    isGeminal = true;
                    break;
                }
                for (int j = 0; j < bonds4.length && !atom2.isCovalentlyBonded(atom3 = bonds4[j].getOtherAtom(atom4)); ++j) {
                    atom3 = null;
                }
            }
            atoms[1] = atom2;
            atoms[2] = atom3;
        } else if (atom2.isCovalentlyBonded(atom4)) {
            isGeminal = true;
        }
        String e1 = atom4.getElementSymbol();
        String e2 = atom2 == null ? null : atom2.getElementSymbol();
        String e3 = atom3 == null ? null : atom3.getElementSymbol();
        String e4 = atom1.getElementSymbol();
        boolean bl = isHH = e1.equals("H") && e4.equals("H");
        mode = isGeminal ? (allow2JHH && isHH && e2.equals("C") ? 1 : 0) : (atom3 == null ? (allowNOE && isHH ? 8 : 0) : (allow3JHH && isHH ? 2 : (allow3JCH && e2.equals("C") && e3.equals("C") && (e1.equals("H") && e4.equals("C") || e1.equals("C") && e4.equals("H")) ? 4 : 0)));
        if (mode != 0 && elementsToFill != null) {
            elementsToFill[0] = e1;
            elementsToFill[1] = e2;
            elementsToFill[2] = e3;
            elementsToFill[3] = e4;
        }
        return mode;
    }

    private static double[] calc2JHH(Atom h1, Atom c, Atom h2) {
        double val = Double.NaN;
        switch (c.getCovalentBondCount()) {
            case 3: {
                val = 1.5;
                break;
            }
            case 4: {
                val = 12.0;
                break;
            }
            default: {
                return null;
            }
        }
        float angle = Measure.computeAngle(h1, c, h2, new V3(), new V3(), false);
        return new double[]{angle, val, c.i};
    }

    private static double[] calcNOEImpl(Viewer viewer, Atom atom1, Atom atom2) {
        try {
            double[] dArray;
            NMRNoeMatrix noeMatrix = (NMRNoeMatrix)viewer.ms.getInfo(atom1.mi, "noeMatrix");
            double dist = 0.0;
            double noe = Double.NaN;
            if (noeMatrix == null) {
                noeMatrix = NMRNoeMatrix.createMatrix(viewer, viewer.getModelUndeletedAtomsBitSet(atom1.mi), (String[])viewer.ms.getInfo(atom1.mi, "noeLabels"), (NMRNoeMatrix.NOEParams)viewer.ms.getInfo(atom1.mi, "noeParams"));
            }
            dist = noeMatrix.getJmolDistance(atom1.i, atom2.i);
            noe = noeMatrix.getJmolNoe(atom1.i, atom2.i);
            if (Double.isNaN(noe)) {
                dArray = null;
            } else {
                double[] dArray2 = new double[2];
                dArray2[0] = dist;
                dArray = dArray2;
                dArray2[1] = noe;
            }
            return dArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public double[] getNOEorJHH(Atom[] atoms, int mode) {
        return NMRCalculation.calc2or3JorNOE(this.vwr, atoms, null, mode);
    }

    static {
        double enegH = 2.2;
        deltaElectro.put("C", new Double(2.6 - enegH));
        deltaElectro.put("O", new Double(3.5 - enegH));
        deltaElectro.put("N", new Double(3.05 - enegH));
        deltaElectro.put("F", new Double(3.9 - enegH));
        deltaElectro.put("Cl", new Double(3.15 - enegH));
        deltaElectro.put("Br", new Double(2.95 - enegH));
        deltaElectro.put("I", new Double(2.65 - enegH));
        deltaElectro.put("S", new Double(2.58 - enegH));
        deltaElectro.put("Si", new Double(1.9 - enegH));
        pAltona = new double[5][8];
        for (int nNonH = 0; nNonH < 5; ++nNonH) {
            double[] p = pAltona[nNonH];
            switch (nNonH) {
                case 0: 
                case 1: 
                case 2: {
                    p[1] = 13.7;
                    p[2] = -0.73;
                    p[3] = 0.0;
                    p[4] = 0.56;
                    p[5] = -2.47;
                    p[6] = 16.9;
                    p[7] = 0.14;
                    break;
                }
                case 3: {
                    p[1] = 13.22;
                    p[2] = -0.99;
                    p[3] = 0.0;
                    p[4] = 0.87;
                    p[5] = -2.46;
                    p[6] = 19.9;
                    p[7] = 0.0;
                    break;
                }
                case 4: {
                    p[1] = 13.24;
                    p[2] = -0.91;
                    p[3] = 0.0;
                    p[4] = 0.53;
                    p[5] = -2.41;
                    p[6] = 15.5;
                    p[7] = 0.19;
                }
            }
            p[6] = p[6] * Math.PI / 180.0;
        }
    }
}

