/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.impl.projectlevelman.LegacyVcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowConfirmationOption;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowSettingOption;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowSettingOptionImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class OptionsAndConfirmations {
    private final Map<@NonNls String, Boolean> myOptionsValues = new HashMap<String, Boolean>();
    private final Map<@NonNls String, // Could not load outer class - annotation placement on inner may be incorrect
    VcsShowConfirmationOption.Value> myConfirmationsValues = new HashMap<String, VcsShowConfirmationOption.Value>();
    private final Map<@NonNls String, PersistentVcsShowSettingOption> myOptions = new LinkedHashMap<String, PersistentVcsShowSettingOption>();
    private final Map<@NonNls String, PersistentVcsShowConfirmationOption> myConfirmations = new LinkedHashMap<String, PersistentVcsShowConfirmationOption>();

    public OptionsAndConfirmations() {
        this.createSettingFor(VcsConfiguration.StandardOption.ADD);
        this.createSettingFor(VcsConfiguration.StandardOption.REMOVE);
        this.createSettingFor(VcsConfiguration.StandardOption.CHECKOUT);
        this.createSettingFor(VcsConfiguration.StandardOption.UPDATE);
        this.createSettingFor(VcsConfiguration.StandardOption.STATUS);
        this.createSettingFor(VcsConfiguration.StandardOption.EDIT);
        this.createConfirmationFor(VcsConfiguration.StandardConfirmation.ADD);
        this.createConfirmationFor(VcsConfiguration.StandardConfirmation.REMOVE);
    }

    private void createSettingFor(VcsConfiguration.StandardOption option) {
        this.myOptions.put(option.getId(), new PersistentVcsShowSettingOptionImpl(option, this));
    }

    private void createConfirmationFor(VcsConfiguration.StandardConfirmation confirmation) {
        this.myConfirmations.put(confirmation.getId(), new PersistentVcsShowConfirmationOptionImpl(confirmation, this));
    }

    @NotNull
    public PersistentVcsShowConfirmationOption getConfirmation(@NotNull VcsConfiguration.StandardConfirmation option) {
        if (option == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(0);
        }
        PersistentVcsShowConfirmationOption persistentVcsShowConfirmationOption = this.myConfirmations.get(option.getId());
        if (persistentVcsShowConfirmationOption == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(1);
        }
        return persistentVcsShowConfirmationOption;
    }

    @NotNull
    public PersistentVcsShowSettingOption getOption(@NotNull VcsConfiguration.StandardOption option) {
        if (option == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(2);
        }
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = this.myOptions.get(option.getId());
        if (persistentVcsShowSettingOption == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(3);
        }
        return persistentVcsShowSettingOption;
    }

    public List<PersistentVcsShowSettingOption> getAllOptions() {
        return new ArrayList<PersistentVcsShowSettingOption>(this.myOptions.values());
    }

    public List<PersistentVcsShowConfirmationOption> getAllConfirmations() {
        return new ArrayList<PersistentVcsShowConfirmationOption>(this.myConfirmations.values());
    }

    @NotNull
    public PersistentVcsShowSettingOption getOrCreateCustomOption(@NotNull String vcsActionName, @NotNull AbstractVcs vcs) {
        if (vcsActionName == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(4);
        }
        if (vcs == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(5);
        }
        PersistentVcsShowSettingOption persistentVcsShowSettingOption = this.myOptions.computeIfAbsent(vcsActionName, key -> new LegacyVcsShowOptionsSettingImpl(vcsActionName, this));
        if (persistentVcsShowSettingOption == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(6);
        }
        return persistentVcsShowSettingOption;
    }

    void setOptionValue(@NonNls @NotNull String id, boolean value) {
        if (id == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(7);
        }
        this.myOptionsValues.put(id, value);
    }

    void setConfirmationValue(@NonNls @NotNull String id, @NonNls VcsShowConfirmationOption.Value value) {
        if (id == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(8);
        }
        this.myConfirmationsValues.put(id, value);
    }

    boolean getOptionValue(@NonNls @NotNull String id) {
        Boolean value;
        if (id == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(9);
        }
        if ((value = this.myOptionsValues.get(id)) != null) {
            return value;
        }
        return true;
    }

    @NotNull
    VcsShowConfirmationOption.Value getConfirmationValue(@NonNls @NotNull String id) {
        VcsShowConfirmationOption.Value value;
        if (id == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(10);
        }
        if ((value = this.myConfirmationsValues.get(id)) != null) {
            VcsShowConfirmationOption.Value value2 = value;
            if (value2 == null) {
                OptionsAndConfirmations.$$$reportNull$$$0(11);
            }
            return value2;
        }
        VcsShowConfirmationOption.Value value3 = VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
        if (value3 == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(12);
        }
        return value3;
    }

    Map<String, Boolean> getOptionsValues() {
        return this.myOptionsValues;
    }

    Map<String, VcsShowConfirmationOption.Value> getConfirmationsValues() {
        return this.myConfirmationsValues;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/OptionsAndConfirmations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsActionName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/OptionsAndConfirmations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOption";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCustomOption";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmationValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfirmation";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOption";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCustomOption";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setOptionValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setConfirmationValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOptionValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConfirmationValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 11, 12 -> new IllegalStateException(string);
        };
    }
}

