/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.junit;

import com.intellij.rt.execution.testFrameworks.ForkedSplitter;
import com.intellij.rt.junit.IdeaTestRunner;
import com.intellij.rt.junit.JUnitForkedStarter;
import com.intellij.rt.junit.JUnitStarter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JUnitForkedSplitter<T>
extends ForkedSplitter<T> {
    private IdeaTestRunner<T> myTestRunner;

    public JUnitForkedSplitter(String workingDirsPath, String forkMode, List newArgs) {
        super(workingDirsPath, forkMode, newArgs);
    }

    protected String getStarterName() {
        return JUnitForkedStarter.class.getName();
    }

    protected T createRootDescription(String[] args, String configName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.myTestRunner = (IdeaTestRunner)JUnitStarter.getAgentClass((String)this.myNewArgs.get(0)).newInstance();
        return this.myTestRunner.getTestToStart(args, configName);
    }

    protected String getTestClassName(T child) {
        return this.myTestRunner.getTestClassName(child);
    }

    protected List<String> createChildArgs(T child) {
        ArrayList<String> newArgs = new ArrayList<String>();
        newArgs.add(this.myTestRunner.getStartDescription(child));
        newArgs.addAll(this.myNewArgs);
        return newArgs;
    }

    protected List<String> createPerModuleArgs(String packageName, String workingDir, List<String> classNames, T rootDescription, String filters) throws IOException {
        File tempFile = File.createTempFile("idea_junit", ".tmp");
        tempFile.deleteOnExit();
        JUnitStarter.printClassesList(classNames, packageName, "", filters, tempFile);
        ArrayList<String> childArgs = new ArrayList<String>();
        childArgs.add("@" + tempFile.getAbsolutePath());
        childArgs.addAll(this.myNewArgs);
        return childArgs;
    }

    protected List<T> getChildren(T child) {
        return this.myTestRunner.getChildTests(child);
    }
}

