/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.spellchecker;

import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/spellchecker/KotlinSpellcheckingStrategy;", "Lcom/intellij/spellchecker/tokenizer/SpellcheckingStrategy;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "plainTextTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "Lcom/intellij/psi/PsiElement;", "emptyTokenizer", "getTokenizer", "element", "kotlin.spellchecker"})
public final class KotlinSpellcheckingStrategy
extends SpellcheckingStrategy
implements DumbAware {
    @NotNull
    private final Tokenizer<PsiElement> plainTextTokenizer = (Tokenizer)new TokenizerBase((Splitter)PlainTextSplitter.getInstance());
    @NotNull
    private final Tokenizer<PsiElement> emptyTokenizer;

    public KotlinSpellcheckingStrategy() {
        Tokenizer tokenizer = SpellcheckingStrategy.EMPTY_TOKENIZER;
        Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
        this.emptyTokenizer = tokenizer;
    }

    @NotNull
    public Tokenizer<? extends PsiElement> getTokenizer(@Nullable PsiElement element) {
        Tokenizer tokenizer;
        if (element instanceof PsiComment) {
            Tokenizer tokenizer2 = super.getTokenizer(element);
            tokenizer = tokenizer2;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer2, (String)"getTokenizer(...)");
        } else if (element instanceof KtParameter) {
            PsiElement psiElement = ((KtParameter)element).getParent();
            KtParameterList ktParameterList = psiElement instanceof KtParameterList ? (KtParameterList)psiElement : null;
            PsiElement psiElement2 = ktParameterList != null ? ktParameterList.getParent() : null;
            KtNamedFunction function = psiElement2 instanceof KtNamedFunction ? (KtNamedFunction)psiElement2 : null;
            KtNamedFunction ktNamedFunction = function;
            boolean bl = ktNamedFunction != null ? ktNamedFunction.hasModifier(KtTokens.OVERRIDE_KEYWORD) : false;
            if (bl) {
                tokenizer = this.emptyTokenizer;
            } else {
                Tokenizer tokenizer3 = super.getTokenizer(element);
                tokenizer = tokenizer3;
                Intrinsics.checkNotNullExpressionValue((Object)tokenizer3, (String)"getTokenizer(...)");
            }
        } else if (element instanceof PsiNameIdentifierOwner) {
            if (element instanceof KtModifierListOwner && ((KtModifierListOwner)element).hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                tokenizer = this.emptyTokenizer;
            } else {
                Tokenizer tokenizer4 = super.getTokenizer(element);
                tokenizer = tokenizer4;
                Intrinsics.checkNotNullExpressionValue((Object)tokenizer4, (String)"getTokenizer(...)");
            }
        } else {
            tokenizer = element instanceof KtLiteralStringTemplateEntry && !SpellcheckingStrategy.isInjectedLanguageFragment((PsiElement)((KtLiteralStringTemplateEntry)element).getParent()) ? this.plainTextTokenizer : this.emptyTokenizer;
        }
        return tokenizer;
    }
}

