/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005J*\u0010\f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeTypeFixUtils;", "", "<init>", "()V", "familyName", "", "functionOrConstructorParameterPresentation", "element", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "containerName", "baseFunctionOrConstructorParameterPresentation", "presentation", "getTextForQuickFix", "isUnitType", "", "typePresentation", "kotlin.fir.frontend-independent"})
public final class ChangeTypeFixUtils {
    @NotNull
    public static final ChangeTypeFixUtils INSTANCE = new ChangeTypeFixUtils();

    private ChangeTypeFixUtils() {
    }

    @IntentionFamilyName
    @NotNull
    public final String familyName() {
        return KotlinBundle.message((String)"fix.change.return.type.family", (Object[])new Object[0]);
    }

    @Nullable
    public final String functionOrConstructorParameterPresentation(@NotNull KtCallableDeclaration element, @Nullable String containerName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String name2 = element.getName();
        if (name2 != null) {
            String string2 = containerName;
            String fullName = string2 != null ? "'" + string2 + "." + name2 + "'" : "'" + name2 + "'";
            KtCallableDeclaration ktCallableDeclaration = element;
            if (ktCallableDeclaration instanceof KtParameter) {
                Object[] objectArray = new Object[]{fullName};
                string = KotlinBundle.message((String)"fix.change.return.type.presentation.property", (Object[])objectArray);
            } else if (ktCallableDeclaration instanceof KtProperty) {
                Object[] objectArray = new Object[]{fullName};
                string = KotlinBundle.message((String)"fix.change.return.type.presentation.property", (Object[])objectArray);
            } else {
                Object[] objectArray = new Object[]{fullName};
                string = KotlinBundle.message((String)"fix.change.return.type.presentation.function", (Object[])objectArray);
            }
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String baseFunctionOrConstructorParameterPresentation(@NotNull String presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Object[] objectArray = new Object[]{presentation};
        return KotlinBundle.message((String)"fix.change.return.type.presentation.base", (Object[])objectArray);
    }

    @Nullable
    public final String baseFunctionOrConstructorParameterPresentation(@NotNull KtCallableDeclaration element, @Nullable String containerName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = this.functionOrConstructorParameterPresentation(element, containerName);
        if (string == null) {
            return null;
        }
        String presentation = string;
        return this.baseFunctionOrConstructorParameterPresentation(presentation);
    }

    @IntentionName
    @NotNull
    public final String getTextForQuickFix(@NotNull KtCallableDeclaration element, @Nullable String presentation, boolean isUnitType, @NotNull String typePresentation) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)typePresentation, (String)"typePresentation");
        if (isUnitType && element instanceof KtFunction && ((KtFunction)element).hasBlockBody()) {
            String string2;
            if (presentation == null) {
                string2 = KotlinBundle.message((String)"fix.change.return.type.remove.explicit.return.type", (Object[])new Object[0]);
            } else {
                Object[] objectArray = new Object[]{presentation};
                string2 = KotlinBundle.message((String)"fix.change.return.type.remove.explicit.return.type.of", (Object[])objectArray);
            }
            return string2;
        }
        if (element instanceof KtFunction) {
            if (presentation != null) {
                Object[] objectArray = new Object[]{presentation, typePresentation};
                string = KotlinBundle.message((String)"fix.change.return.type.return.type.text.of", (Object[])objectArray);
            } else {
                Object[] objectArray = new Object[]{typePresentation};
                string = KotlinBundle.message((String)"fix.change.return.type.return.type.text", (Object[])objectArray);
            }
        } else if (presentation != null) {
            Object[] objectArray = new Object[]{presentation, typePresentation};
            string = KotlinBundle.message((String)"fix.change.return.type.type.text.of", (Object[])objectArray);
        } else {
            Object[] objectArray = new Object[]{typePresentation};
            string = KotlinBundle.message((String)"fix.change.return.type.type.text", (Object[])objectArray);
        }
        return string;
    }
}

