/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.PsiElementSuitabilityChecker;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.PsiElementSuitabilityCheckers;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixesPsiBasedFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFixBase;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u0002J\r\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0016J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0094\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "element", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getModifier", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "getPresentationImpl", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Factory", "Companion", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nAddModifierFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddModifierFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddModifierFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public class AddModifierFix
extends PsiUpdateModCommandAction<KtModifierListOwner> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtModifierKeywordToken modifier;
    @NotNull
    private static final Set<KtModifierKeywordToken> modifiersWithWarning;
    @NotNull
    private static final Set<KtModifierKeywordToken> modalityModifiers;

    public AddModifierFix(@NotNull KtModifierListOwner element, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        super((PsiElement)element);
        this.modifier = modifier;
    }

    @NotNull
    protected final KtModifierKeywordToken getModifier() {
        return this.modifier;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull KtModifierListOwner element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getPresentationImpl(element);
    }

    @Nullable
    public final Presentation getPresentationImpl(@NotNull KtModifierListOwner element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!KotlinCommonRefactoringUtilKt.canRefactorElement((PsiElement)element)) {
            return null;
        }
        if (modalityModifiers.contains(this.modifier) || KtTokens.VISIBILITY_MODIFIERS.contains((IElementType)this.modifier) || Intrinsics.areEqual((Object)this.modifier, (Object)KtTokens.CONST_KEYWORD)) {
            var3_2 = new Object[2];
            var3_2[0] = RemoveModifierFixBase.Companion.getElementName(element);
            Intrinsics.checkNotNullExpressionValue((Object)this.modifier.getValue(), (String)"getValue(...)");
            string = KotlinBundle.message((String)"fix.add.modifier.text", (Object[])var3_2);
        } else {
            var3_2 = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.modifier.getValue(), (String)"getValue(...)");
            string = KotlinBundle.message((String)"fix.add.modifier.text.generic", (Object[])var3_2);
        }
        String actionName = string;
        return Presentation.of((String)actionName).withFixAllOption((ModCommandAction)this);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"fix.add.modifier.family", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull KtModifierListOwner element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        element.addModifier(this.modifier);
        KtModifierKeywordToken ktModifierKeywordToken = this.modifier;
        if (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.ABSTRACT_KEYWORD)) {
            if (element instanceof KtProperty || element instanceof KtNamedFunction) {
                KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)element));
                if (ktClass != null) {
                    KtClass klass = ktClass;
                    boolean bl = false;
                    if (!klass.hasModifier(KtTokens.ABSTRACT_KEYWORD) && !klass.hasModifier(KtTokens.SEALED_KEYWORD)) {
                        klass.addModifier(KtTokens.ABSTRACT_KEYWORD);
                    }
                }
            }
        } else if (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.OVERRIDE_KEYWORD)) {
            KtModifierKeywordToken visibility2;
            Object object;
            KtModifierKeywordToken ktModifierKeywordToken2 = KtPsiUtilKt.visibilityModifierType((KtModifierListOwner)element);
            if (ktModifierKeywordToken2 != null) {
                KtModifierKeywordToken klass;
                KtModifierKeywordToken it = klass = ktModifierKeywordToken2;
                boolean bl = false;
                object = !Intrinsics.areEqual((Object)it, (Object)KtTokens.PUBLIC_KEYWORD) ? klass : null;
            } else {
                object = null;
            }
            KtModifierKeywordToken ktModifierKeywordToken3 = visibility2 = object;
            if (ktModifierKeywordToken3 != null) {
                KtModifierKeywordToken it = ktModifierKeywordToken3;
                boolean bl = false;
                element.removeModifier(it);
            }
        } else if (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.NOINLINE_KEYWORD)) {
            element.removeModifier(KtTokens.CROSSINLINE_KEYWORD);
        }
    }

    static {
        Object[] objectArray = new KtModifierKeywordToken[]{KtTokens.ABSTRACT_KEYWORD, KtTokens.FINAL_KEYWORD};
        modifiersWithWarning = SetsKt.setOf((Object[])objectArray);
        modalityModifiers = SetsKt.plus(modifiersWithWarning, (Object)KtTokens.OPEN_KEYWORD);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "<init>", "()V", "modifiersWithWarning", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getModifiersWithWarning", "()Ljava/util/Set;", "modalityModifiers", "kotlin.jvm.PlatformType", "createModifierFix", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifier", "kotlin.fir.frontend-independent"})
    public static final class Companion
    implements Factory<AddModifierFix> {
        private Companion() {
        }

        @NotNull
        public final Set<KtModifierKeywordToken> getModifiersWithWarning() {
            return modifiersWithWarning;
        }

        @Override
        @NotNull
        public AddModifierFix createModifierFix(@NotNull KtModifierListOwner element, @NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return new AddModifierFix(element, modifier);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\"\b\b\u0001\u0010\u0001*\u00020\t2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00010\u000bH\u0016J\u001f\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Factory;", "T", "Lcom/intellij/modcommand/ModCommandAction;", "", "createFactory", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixesPsiBasedFactory;", "Lcom/intellij/psi/PsiElement;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifierOwnerClass", "Ljava/lang/Class;", "createIfApplicable", "modifierListOwner", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lcom/intellij/modcommand/ModCommandAction;", "createModifierFix", "element", "kotlin.fir.frontend-independent"})
    @SourceDebugExtension(value={"SMAP\nAddModifierFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddModifierFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Factory\n+ 2 QuickFixesPsiBasedFactory.kt\norg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixesPsiBasedFactoryKt\n*L\n1#1,126:1\n38#2,5:127\n*S KotlinDebug\n*F\n+ 1 AddModifierFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Factory\n*L\n78#1:127,5\n*E\n"})
    public static interface Factory<T extends ModCommandAction> {
        @NotNull
        default public QuickFixesPsiBasedFactory<PsiElement> createFactory(@NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return this.createFactory(modifier, KtModifierListOwner.class);
        }

        @NotNull
        default public <T extends KtModifierListOwner> QuickFixesPsiBasedFactory<PsiElement> createFactory(@NotNull KtModifierKeywordToken modifier, @NotNull Class<T> modifierOwnerClass) {
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            Intrinsics.checkNotNullParameter(modifierOwnerClass, (String)"modifierOwnerClass");
            PsiElementSuitabilityChecker<PsiElement> suitabilityChecker$iv = PsiElementSuitabilityCheckers.INSTANCE.getALWAYS_SUITABLE();
            boolean $i$f$quickFixesPsiBasedFactory = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(PsiElement.class);
            return new QuickFixesPsiBasedFactory<PsiElement>(suitabilityChecker$iv, kClass, modifierOwnerClass, this, modifier){
                final /* synthetic */ Class $modifierOwnerClass$inlined;
                final /* synthetic */ Factory this$0;
                final /* synthetic */ KtModifierKeywordToken $modifier$inlined;
                {
                    this.$modifierOwnerClass$inlined = clazz;
                    this.this$0 = factory2;
                    this.$modifier$inlined = ktModifierKeywordToken;
                    super($super_call_param$1, $suitabilityChecker);
                }

                protected List<IntentionAction> doCreateQuickFix(PsiElement psiElement) {
                    List list2;
                    Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
                    PsiElement e = psiElement;
                    boolean bl = false;
                    KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)e, (Class)this.$modifierOwnerClass$inlined, (boolean)false);
                    if (ktModifierListOwner == null) {
                        list2 = CollectionsKt.emptyList();
                    } else {
                        KtModifierListOwner ktModifierListOwner2 = ktModifierListOwner;
                        Intrinsics.checkNotNull((Object)ktModifierListOwner2);
                        KtModifierListOwner modifierListOwner = ktModifierListOwner2;
                        T t = this.this$0.createIfApplicable(modifierListOwner, this.$modifier$inlined);
                        list2 = CollectionsKt.listOfNotNull((Object)(t != null ? t.asIntention() : null));
                    }
                    return list2;
                }
            };
        }

        @Nullable
        default public T createIfApplicable(@NotNull KtModifierListOwner modifierListOwner, @NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)modifierListOwner, (String)"modifierListOwner");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            KtModifierKeywordToken ktModifierKeywordToken = modifier;
            if (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.ABSTRACT_KEYWORD) || Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.OPEN_KEYWORD)) {
                if (modifierListOwner instanceof KtObjectDeclaration) {
                    return null;
                }
                if (modifierListOwner instanceof KtEnumEntry) {
                    return null;
                }
                if (modifierListOwner instanceof KtDeclaration && !(modifierListOwner instanceof KtClass)) {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)modifierListOwner));
                    if (ktClassOrObject == null) {
                        return null;
                    }
                    KtClassOrObject parentClassOrObject = ktClassOrObject;
                    if (parentClassOrObject instanceof KtObjectDeclaration) {
                        return null;
                    }
                    if (parentClassOrObject instanceof KtEnumEntry) {
                        return null;
                    }
                }
                if (Intrinsics.areEqual((Object)modifier, (Object)KtTokens.ABSTRACT_KEYWORD) && modifierListOwner instanceof KtClass && KotlinPsiUtils.isInlineOrValue((KtClass)modifierListOwner)) {
                    return null;
                }
            } else if (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.INNER_KEYWORD)) {
                if (modifierListOwner instanceof KtObjectDeclaration) {
                    return null;
                }
                if (modifierListOwner instanceof KtClass && (((KtClass)modifierListOwner).isInterface() || ((KtClass)modifierListOwner).isSealed() || ((KtClass)modifierListOwner).isEnum() || ((KtClass)modifierListOwner).isData() || ((KtClass)modifierListOwner).isAnnotation())) {
                    return null;
                }
            }
            return this.createModifierFix(modifierListOwner, modifier);
        }

        @NotNull
        public T createModifierFix(@NotNull KtModifierListOwner var1, @NotNull KtModifierKeywordToken var2);
    }
}

