/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.diagnostics.KaDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.AddDependencyQuickFixHelper;
import org.jetbrains.kotlin.idea.highlighter.UnresolvedReferenceDiagnosticsRestorationKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ImportQuickFix;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ImportQuickFixProvider;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.RenameUnresolvedReferenceFixKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/KotlinFirUnresolvedReferenceQuickFixProvider;", "Lcom/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider;", "Lcom/intellij/psi/PsiReference;", "<init>", "()V", "registerFixes", "", "reference", "registrar", "Lcom/intellij/codeInsight/daemon/QuickFixActionRegistrar;", "getReferenceClass", "Ljava/lang/Class;", "Companion", "kotlin.code-insight.fixes.k2"})
@SourceDebugExtension(value={"SMAP\nKotlinFirUnresolvedReferenceQuickFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFirUnresolvedReferenceQuickFixProvider.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/KotlinFirUnresolvedReferenceQuickFixProvider\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n30#2,2:81\n35#3,9:83\n48#3,2:98\n45#3,2:100\n61#4,5:92\n1#5:97\n*S KotlinDebug\n*F\n+ 1 KotlinFirUnresolvedReferenceQuickFixProvider.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/KotlinFirUnresolvedReferenceQuickFixProvider\n*L\n45#1:81,2\n45#1:83,9\n45#1:98,2\n45#1:100,2\n54#1:92,5\n*E\n"})
public final class KotlinFirUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiReference> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void registerFixes(@NotNull PsiReference reference, @NotNull QuickFixActionRegistrar registrar2) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)registrar2, (String)"registrar");
        PsiElement psiElement = reference.getElement();
        KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        if (ktElement == null) {
            return;
        }
        KtElement ktElement2 = ktElement;
        Module module = GenericPsiUtils.getModule((PsiElement)ktElement2);
        if (!(module != null ? KotlinFacetUtils.isMultiPlatformModule(module) : false)) {
            for (IntentionAction action2 : AddDependencyQuickFixHelper.INSTANCE.createQuickFix((PsiElement)ktElement2)) {
                registrar2.register(action2);
            }
        }
        KtElement useSiteElement$iv = ktElement2;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            Unit unit;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                Set set;
                Set<KaDiagnosticWithPsi<Object>> set2;
                boolean bl = false;
                KaSession $this$registerFixes_u24lambda_u244 = analysisSession$iv$iv;
                boolean bl2 = false;
                Set<KaDiagnosticWithPsi<?>> set3 = UnresolvedReferenceDiagnosticsRestorationKt.restoreKaDiagnosticsForUnresolvedReference($this$registerFixes_u24lambda_u244, ktElement2);
                if (set3.isEmpty()) {
                    boolean bl3 = false;
                    KtBinaryExpression ktBinaryExpression = UnresolvedReferenceDiagnosticsRestorationKt.getBinaryExpressionForOperationReference((PsiElement)ktElement2);
                    set2 = ktBinaryExpression != null ? UnresolvedReferenceDiagnosticsRestorationKt.restoreKaDiagnosticsForUnresolvedReference($this$registerFixes_u24lambda_u244, (KtElement)ktBinaryExpression) : null;
                } else {
                    set2 = set3;
                }
                if ((set = (Set)set2) == null) {
                    set = SetsKt.emptySet();
                }
                Set savedDiagnostics = set;
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl4 = false;
                    String string = "unresolved references diagnostics for file=" + ktElement2.getContainingFile().getVirtualFile().getPath() + ":\n";
                    logger.debug(CollectionsKt.joinToString$default((Iterable)savedDiagnostics, (CharSequence)"\n", (CharSequence)string, null, (int)0, null, KotlinFirUnresolvedReferenceQuickFixProvider::registerFixes$lambda$4$lambda$2$lambda$1, (int)28, null), e$iv);
                }
                for (ImportQuickFix quickFix2 : ImportQuickFixProvider.INSTANCE.getFixes($this$registerFixes_u24lambda_u244, savedDiagnostics)) {
                    registrar2.register((IntentionAction)quickFix2);
                }
                if (ktElement2 instanceof KtNameReferenceExpression) {
                    try {
                        IntentionAction intentionAction = RenameUnresolvedReferenceFixKt.createRenameUnresolvedReferenceFix($this$registerFixes_u24lambda_u244, (KtNameReferenceExpression)ktElement2);
                        if (intentionAction != null) {
                            IntentionAction action3 = intentionAction;
                            boolean bl5 = false;
                            registrar2.register(action3);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof ControlFlowException) {
                            throw e;
                        }
                        throw new KotlinExceptionWithAttachments("Unable to create rename unresolved reference fix", (Throwable)e).withPsiAttachment("element.kt", (PsiElement)ktElement2).withPsiAttachment("file.kt", (PsiElement)((KtNameReferenceExpression)ktElement2).getContainingFile());
                    }
                }
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
    }

    @NotNull
    public Class<PsiReference> getReferenceClass() {
        return PsiReference.class;
    }

    private static final CharSequence registerFixes$lambda$4$lambda$2$lambda$1(KaDiagnosticWithPsi it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDefaultMessage() + "; textRanges=" + it.getTextRanges();
    }

    static {
        Logger logger = Logger.getInstance(KotlinFirUnresolvedReferenceQuickFixProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/KotlinFirUnresolvedReferenceQuickFixProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.code-insight.fixes.k2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

