/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.EvaluateCompileTimeExpressionIntentionKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u000e\u0010\f\u001a\u00020\u0006*\u0004\u0018\u00010\rH\u0002J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/EvaluateCompileTimeExpressionIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "<init>", "()V", "isApplicableTo", "", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isConstantExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getConstantValue", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nEvaluateCompileTimeExpressionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluateCompileTimeExpressionIntention.kt\norg/jetbrains/kotlin/idea/intentions/EvaluateCompileTimeExpressionIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,71:1\n213#2:72\n*S KotlinDebug\n*F\n+ 1 EvaluateCompileTimeExpressionIntention.kt\norg/jetbrains/kotlin/idea/intentions/EvaluateCompileTimeExpressionIntention\n*L\n24#1:72\n*E\n"})
public final class EvaluateCompileTimeExpressionIntention
extends SelfTargetingOffsetIndependentIntention<KtBinaryExpression> {
    public EvaluateCompileTimeExpressionIntention() {
        super(KtBinaryExpression.class, KotlinBundle.lazyMessage((String)"evaluate.compile.time.expression", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBinaryExpression.class, (boolean)true) != null || !this.isConstantExpression((KtExpression)element)) {
            return false;
        }
        String string = this.getConstantValue(element);
        if (string == null) {
            return false;
        }
        String constantValue = string;
        this.setTextGetter((Function0<String>)((Function0)() -> EvaluateCompileTimeExpressionIntention.isApplicableTo$lambda$0(constantValue)));
        return true;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = this.getConstantValue(element);
        if (string == null) {
            return;
        }
        String constantValue = string;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        element.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createExpression(constantValue));
    }

    private final boolean isConstantExpression(KtExpression $this$isConstantExpression) {
        KtExpression expression = KtPsiUtil.deparenthesize((KtExpression)$this$isConstantExpression);
        return expression instanceof KtConstantExpression ? EvaluateCompileTimeExpressionIntentionKt.access$getConstantNodeTypes$p().contains(((KtConstantExpression)expression).getElementType()) : (expression instanceof KtPrefixExpression ? this.isConstantExpression(((KtPrefixExpression)expression).getBaseExpression()) : (expression instanceof KtBinaryExpression ? this.isConstantExpression(((KtBinaryExpression)expression).getLeft()) && this.isConstantExpression(((KtBinaryExpression)expression).getRight()) : false));
    }

    private final String getConstantValue(KtBinaryExpression $this$getConstantValue) {
        BindingContext context = ResolutionUtils.analyze((KtElement)$this$getConstantValue, BodyResolveMode.PARTIAL);
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)((KtExpression)$this$getConstantValue), (BindingContext)context);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant((KtExpression)$this$getConstantValue, context);
        if (compileTimeConstant == null || (compileTimeConstant = compileTimeConstant.toConstantValue(type2)) == null) {
            return null;
        }
        CompileTimeConstant constantValue = compileTimeConstant;
        Object value = constantValue.getValue();
        return value instanceof Character ? "'" + StringUtil.escapeStringCharacters((String)String.valueOf(((Character)value).charValue())) + "'" : (value instanceof Long ? value + "L" : (value instanceof Float ? (Float.isNaN(((Number)value).floatValue()) ? "Float.NaN" : (Float.isInfinite(((Number)value).floatValue()) ? (((Number)value).floatValue() > 0.0f ? "Float.POSITIVE_INFINITY" : "Float.NEGATIVE_INFINITY") : value + "f")) : (value instanceof Double ? (Double.isNaN(((Number)value).doubleValue()) ? "Double.NaN" : (Double.isInfinite(((Number)value).doubleValue()) ? (((Number)value).doubleValue() > 0.0 ? "Double.POSITIVE_INFINITY" : "Double.NEGATIVE_INFINITY") : String.valueOf(((Number)value).doubleValue()))) : String.valueOf(value))));
    }

    private static final String isApplicableTo$lambda$0(String $constantValue) {
        Object[] objectArray = new Object[]{$constantValue};
        return KotlinBundle.message((String)"replace.with.0", (Object[])objectArray);
    }
}

