/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.imports;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.idea.base.psi.imports.KotlinImportPathComparator;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.imports.ImportMapper;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u0000 T2\u00020\u0001:\u0006TUVWXYB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001aJ\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u001c*\u00020\u001dH\u0002J\u0013\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0082\u0010J\u0010\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001aH\u0002J\u001e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020%2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002JF\u00104\u001a\u00020/2\f\u00105\u001a\b\u0012\u0004\u0012\u00020$022\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u00020(08072\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u0014082\u0006\u0010:\u001a\u00020\u0003H\u0002J\u001e\u0010;\u001a\u00020<2\u0006\u0010:\u001a\u00020\u00032\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001402H\u0002J\f\u0010=\u001a\u00020<*\u00020\u0003H\u0002J&\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020<2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020302H\u0002J&\u0010B\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%020C*\u00020<2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\u0018\u0010D\u001a\u00020\u001c2\u0006\u00100\u001a\u00020%2\u0006\u0010E\u001a\u00020$H\u0002J\u0010\u0010F\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020$H\u0002J\u0010\u0010G\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020$H\u0002J\u0010\u0010H\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020$H\u0002J\u0010\u0010I\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020$H\u0002J\f\u0010J\u001a\u00020K*\u00020%H\u0002J$\u0010L\u001a\u00020\u001c2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020%022\f\u0010N\u001a\b\u0012\u0004\u0012\u00020%02H\u0002J\u0018\u0010L\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020%2\u0006\u0010P\u001a\u00020%H\u0002J\u0014\u0010Q\u001a\u00020\u001c*\u00020%2\u0006\u0010R\u001a\u00020%H\u0002J\f\u0010S\u001a\u00020\u001c*\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010#\u001a\u0004\u0018\u00010$*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0018\u0010#\u001a\u00020$*\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010)R\u0018\u0010+\u001a\u00020\u001c*\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006Z"}, d2={"Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "data", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "options", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$Options;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$Options;Lorg/jetbrains/kotlin/config/ApiVersion;)V", "importInsertHelper", "Lorg/jetbrains/kotlin/idea/util/ImportInsertHelper;", "importRules", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportRule;", "Lkotlin/collections/HashSet;", "importPaths", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "getImportPaths", "()Ljava/util/Set;", "importPaths$delegate", "Lkotlin/Lazy;", "buildOptimizedImports", "", "mayReferToSomeUnresolvedName", "", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "isExistedUnresolvedName", "getExpressionToAnalyze", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "importDescriptorWithMapping", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getImportDescriptorWithMapping", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportableDescriptor;", "(Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportableDescriptor;)Lorg/jetbrains/kotlin/name/FqName;", "tryBuildOptimizedImports", "fromCurrentFile", "getFromCurrentFile", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "lockImportForDescriptor", "", "descriptor", "existingNames", "", "Lorg/jetbrains/kotlin/name/Name;", "addExplicitImportsForClassesWhenRequired", "classNamesToCheck", "descriptorsByParentFqName", "", "", "importsToGenerate", "originalFile", "buildScopeByImports", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "getFileResolutionScope", "areScopeSlicesEqual", "scope1", "scope2", "names", "extractSliceTower", "Lkotlin/sequences/Sequence;", "canUseStarImport", "fqName", "needExplicitImport", "hasAlias", "isImportedByDefault", "isImportedByLowPriorityDefault", "nameCountToUseStar", "", "areTargetsEqual", "descriptors1", "descriptors2", "first", "second", "isAliasTo", "other", "isAllowedByRules", "Companion", "AbstractReference", "ImportableDescriptor", "InputData", "Options", "ImportRule", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nOptimizedImportsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimizedImportsBuilder.kt\norg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ResolutionFacade.kt\norg/jetbrains/kotlin/idea/resolve/ResolutionFacadeKt\n*L\n1#1,405:1\n1163#2,3:406\n547#2,2:441\n1056#3:409\n808#3,11:410\n1634#3,3:421\n1563#3:431\n1634#3,3:432\n774#3:435\n865#3,2:436\n1634#3,3:438\n1740#3,3:443\n1563#3:446\n1634#3,3:447\n1056#3:450\n1491#3:451\n1516#3,3:452\n1519#3,3:462\n1869#3,2:466\n774#3:468\n865#3,2:469\n774#3:471\n865#3,2:472\n1740#3,3:475\n2746#3,3:478\n1617#3,9:481\n1869#3:490\n1870#3:492\n1626#3:493\n1374#3:494\n1460#3,5:495\n382#4,7:424\n382#4,7:455\n1#5:465\n1#5:491\n55#6:474\n*S KotlinDebug\n*F\n+ 1 OptimizedImportsBuilder.kt\norg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder\n*L\n96#1:406,3\n173#1:441,2\n103#1:409\n133#1:410,11\n133#1:421,3\n161#1:431\n161#1:432,3\n168#1:435\n168#1:436,2\n168#1:438,3\n175#1:443,3\n188#1:446\n188#1:447,3\n196#1:450\n201#1:451\n201#1:452,3\n201#1:462,3\n241#1:466,2\n279#1:468\n279#1:469,2\n288#1:471\n288#1:472,2\n385#1:475,3\n403#1:478,3\n88#1:481,9\n88#1:490\n88#1:492\n88#1:493\n345#1:494\n345#1:495,5\n147#1:424,7\n201#1:455,7\n88#1:491\n326#1:474\n*E\n"})
public final class OptimizedImportsBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile file;
    @NotNull
    private final InputData data;
    @NotNull
    private final Options options;
    @NotNull
    private final ApiVersion apiVersion;
    @NotNull
    private final ImportInsertHelper importInsertHelper;
    @NotNull
    private final HashSet<ImportRule> importRules;
    @NotNull
    private final Lazy importPaths$delegate;
    @Nullable
    private static StringBuilder testLog;

    public OptimizedImportsBuilder(@NotNull KtFile file, @NotNull InputData data, @NotNull Options options2, @NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        this.file = file;
        this.data = data;
        this.options = options2;
        this.apiVersion = apiVersion;
        Project project = this.file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.importInsertHelper = ImportInsertHelper.Companion.getInstance(project);
        this.importRules = new HashSet();
        this.importPaths$delegate = LazyKt.lazy(() -> OptimizedImportsBuilder.importPaths_delegate$lambda$1(this));
    }

    private final Set<ImportPath> getImportPaths() {
        Lazy lazy = this.importPaths$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<ImportPath> buildOptimizedImports() {
        void $this$mapTo$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.file.getImportDirectives()), arg_0 -> OptimizedImportsBuilder.buildOptimizedImports$lambda$2(this, arg_0)), OptimizedImportsBuilder::buildOptimizedImports$lambda$3);
        Collection destination$iv = this.importRules;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ImportPath importPath = (ImportPath)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(new ImportRule.Add((ImportPath)it));
        }
        while (true) {
            ProgressManager.checkCanceled();
            int importRulesBefore = this.importRules.size();
            List<ImportPath> result2 = this.tryBuildOptimizedImports();
            if (this.importRules.size() == importRulesBefore) {
                return result2;
            }
            StringBuilder stringBuilder = testLog;
            if (stringBuilder == null) continue;
            Iterable $this$sortedBy$iv = this.importRules;
            boolean $i$f$sortedBy = false;
            stringBuilder.append("Trying to build import list again with import rules: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ImportRule it = (ImportRule)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.toString());
                    it = (ImportRule)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.toString())));
                }
            }), null, null, null, (int)0, null, null, (int)63, null) + "\n");
        }
    }

    private final boolean mayReferToSomeUnresolvedName(KtImportDirective $this$mayReferToSomeUnresolvedName) {
        return $this$mayReferToSomeUnresolvedName.isAllUnder() && !((Collection)this.data.getUnresolvedNames()).isEmpty();
    }

    private final boolean isExistedUnresolvedName(KtImportDirective $this$isExistedUnresolvedName) {
        return CollectionsKt.contains((Iterable)this.data.getUnresolvedNames(), (Object)$this$isExistedUnresolvedName.getImportedName());
    }

    private final KtExpression getExpressionToAnalyze(KtElement element) {
        PsiElement parent2;
        OptimizedImportsBuilder optimizedImportsBuilder = this;
        while (true) {
            KtQualifiedExpression ktQualifiedExpression;
            OptimizedImportsBuilder optimizedImportsBuilder2;
            parent2 = element.getParent();
            if (parent2 instanceof KtQualifiedExpression) {
                optimizedImportsBuilder2 = optimizedImportsBuilder;
                ktQualifiedExpression = (KtQualifiedExpression)parent2;
                optimizedImportsBuilder = optimizedImportsBuilder2;
                element = (KtElement)ktQualifiedExpression;
                continue;
            }
            if (!(parent2 instanceof KtCallExpression) || !Intrinsics.areEqual((Object)element, (Object)((KtCallExpression)parent2).getCalleeExpression())) break;
            optimizedImportsBuilder2 = optimizedImportsBuilder;
            ktQualifiedExpression = (KtCallExpression)parent2;
            optimizedImportsBuilder = optimizedImportsBuilder2;
            element = (KtElement)ktQualifiedExpression;
        }
        return parent2 instanceof KtOperationExpression && Intrinsics.areEqual((Object)element, (Object)((KtOperationExpression)parent2).getOperationReference()) ? (KtExpression)parent2 : (parent2 instanceof KtCallableReferenceExpression && Intrinsics.areEqual((Object)element, (Object)((KtCallableReferenceExpression)parent2).getCallableReference()) ? (KtExpression)parent2 : (parent2 instanceof KtUserType ? null : (element instanceof KtExpression ? (KtExpression)element : null)));
    }

    /*
     * WARNING - void declaration
     */
    private final FqName getImportDescriptorWithMapping(DeclarationDescriptor $this$importDescriptorWithMapping) {
        FqName fqName2;
        FqName fqName3 = ImportsUtils.getImportableFqName($this$importDescriptorWithMapping);
        if (fqName3 != null) {
            FqName fqName4 = fqName3;
            boolean bl = false;
            fqName2 = ImportMapper.Companion.findCorrespondingKotlinFqName(fqName4, this.apiVersion);
            if (fqName2 == null) {
                void var2_2;
                fqName2 = var2_2;
            }
        } else {
            fqName2 = null;
        }
        return fqName2;
    }

    private final FqName getImportDescriptorWithMapping(ImportableDescriptor $this$importDescriptorWithMapping) {
        FqName fqName2 = ImportMapper.Companion.findCorrespondingKotlinFqName($this$importDescriptorWithMapping.getFqName(), this.apiVersion);
        if (fqName2 == null) {
            fqName2 = $this$importDescriptorWithMapping.getFqName();
        }
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ImportPath> tryBuildOptimizedImports() {
        void $this$groupByTo$iv$iv;
        Collection collection;
        Iterable $this$sortedBy$iv;
        Iterable parentFqName;
        Collection collection2;
        void $this$mapTo$iv;
        void $this$filterIsInstanceTo$iv$iv;
        HashSet<ImportPath> importsToGenerate = new HashSet<ImportPath>();
        Iterable $this$filterIsInstance$iv = this.importRules;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection collection3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ImportRule.Add)) continue;
            collection3.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)collection3;
        Collection destination$iv = importsToGenerate;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Iterator it;
            ImportRule.Add add2 = (ImportRule.Add)item$iv;
            collection2 = destination$iv;
            boolean bl = false;
            collection2.add(((ImportRule.Add)((Object)it)).getImportPath());
        }
        HashMap descriptorsByParentFqName = new HashMap();
        for (ImportableDescriptor importableDescriptor : this.data.getDescriptorsToImport()) {
            DeclarationDescriptor declarationDescriptor = importableDescriptor.component1();
            FqName fqName2 = importableDescriptor.component2();
            for (Name name2 : (Set)MapsKt.getValue(this.data.getNamesToImport(), (Object)fqName2)) {
                boolean bl;
                FqName resultFqName;
                ImportPath explicitImportPath;
                Name alias = !Intrinsics.areEqual((Object)name2, (Object)fqName2.shortName()) ? name2 : null;
                FqName fqName3 = ImportMapper.Companion.findCorrespondingKotlinFqName(fqName2, this.apiVersion);
                if (fqName3 == null) {
                    fqName3 = fqName2;
                }
                if (importsToGenerate.contains(explicitImportPath = new ImportPath(resultFqName = fqName3, false, alias))) continue;
                parentFqName = resultFqName.parent();
                if (alias == null && this.canUseStarImport(declarationDescriptor, resultFqName) && this.isAllowedByRules(new ImportPath((FqName)parentFqName, true, null, 4, null))) {
                    Object object;
                    void $this$getOrPut$iv;
                    Map map2 = descriptorsByParentFqName;
                    Iterable key$iv = parentFqName;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        Set answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    bl = ((Set)object).add(importableDescriptor);
                    continue;
                }
                bl = importsToGenerate.add(explicitImportPath);
            }
        }
        HashSet classNamesToCheck = new HashSet();
        for (Map.Entry entry : ((Map)descriptorsByParentFqName).entrySet()) {
            boolean bl;
            ImportPath starImportPath;
            block33: {
                void $this$filterTo$iv;
                Sequence $this$mapTo$iv2;
                boolean useExplicitImports;
                void $this$mapTo$iv$iv;
                FqName parentFqName2 = (FqName)entry.getKey();
                Set descriptors = (Set)entry.getValue();
                ProgressManager.checkCanceled();
                starImportPath = new ImportPath(parentFqName2, true, null, 4, null);
                if (importsToGenerate.contains(starImportPath)) continue;
                Iterable $this$map$iv = descriptors;
                boolean $i$f$map = false;
                parentFqName = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo222 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ImportableDescriptor answer$iv = (ImportableDescriptor)item$iv$iv;
                    collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(this.getImportDescriptorWithMapping((ImportableDescriptor)it));
                }
                Set fqNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                int nameCountToUseStar = this.nameCountToUseStar(((ImportableDescriptor)CollectionsKt.first((Iterable)descriptors)).getDescriptor());
                boolean bl2 = useExplicitImports = fqNames.size() < nameCountToUseStar && (Boolean)this.options.isInPackagesToUseStarImport().invoke((Object)parentFqName2) == false || !this.isAllowedByRules(starImportPath);
                if (useExplicitImports) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = fqNames;
                    boolean $i$f$filter = false;
                    Iterable $i$f$mapTo222 = $this$filter$iv;
                    Iterator destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        FqName p0 = (FqName)element$iv$iv;
                        boolean bl5 = false;
                        if (!this.needExplicitImport(p0)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)((Object)destination$iv$iv3);
                    Collection destination$iv2 = importsToGenerate;
                    boolean $i$f$mapTo23 = false;
                    for (Object item$iv : $this$mapTo$iv2) {
                        FqName it = (FqName)item$iv;
                        collection2 = destination$iv2;
                        boolean bl6 = false;
                        collection2.add(new ImportPath(it, false, null, 4, null));
                    }
                    continue;
                }
                $this$mapTo$iv2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)descriptors), OptimizedImportsBuilder::tryBuildOptimizedImports$lambda$11), arg_0 -> OptimizedImportsBuilder.tryBuildOptimizedImports$lambda$12(this, arg_0));
                Collection destination$iv3 = classNamesToCheck;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    FqName p0 = (FqName)element$iv;
                    boolean bl7 = false;
                    if (!this.needExplicitImport(p0)) continue;
                    destination$iv3.add(element$iv);
                }
                Iterable $this$all$iv = fqNames;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FqName p0 = (FqName)element$iv;
                        boolean bl8 = false;
                        if (this.needExplicitImport(p0)) continue;
                        bl = false;
                        break block33;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            importsToGenerate.add(starImportPath);
        }
        this.addExplicitImportsForClassesWhenRequired(classNamesToCheck, descriptorsByParentFqName, (Set<ImportPath>)importsToGenerate, this.file);
        List sortedImportsToGenerate = CollectionsKt.sortedWith((Iterable)importsToGenerate, KotlinImportPathComparator.Companion.create(this.file));
        List list2 = this.file.getImportDirectives();
        if (list2.size() == sortedImportsToGenerate.size()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable starImportPath = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtImportDirective $i$f$all = (KtImportDirective)item$iv$iv;
                collection2 = destination$iv$iv4;
                boolean bl = false;
                collection2.add(it.getImportPath());
            }
            if (Intrinsics.areEqual((Object)((List)destination$iv$iv4), (Object)sortedImportsToGenerate)) {
                return null;
            }
        }
        ImportingScope originalFileScope = this.getFileResolutionScope(this.file);
        ImportingScope newFileScope = this.buildScopeByImports(this.file, sortedImportsToGenerate);
        Collection it = this.data.getReferences();
        boolean bl = false;
        if (testLog != null) {
            $this$sortedBy$iv = it;
            boolean $i$f$sortedBy = false;
            collection = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AbstractReference reference = (AbstractReference)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)reference.toString());
                    reference = (AbstractReference)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)reference.toString())));
                }
            });
        } else {
            collection = it;
        }
        Collection references = collection;
        Iterable $this$groupBy$iv = references;
        boolean $i$f$groupBy = false;
        $this$sortedBy$iv = $this$groupBy$iv;
        Map destination$iv$iv5 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            AbstractReference it2 = (AbstractReference)element$iv$iv;
            boolean bl9 = false;
            Collection<Name> key$iv$iv = it2.getDependsOnNames();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv5;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl10 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry entry : destination$iv$iv5.entrySet()) {
            Collection names = (Collection)entry.getKey();
            List refs = (List)entry.getValue();
            if (this.areScopeSlicesEqual(originalFileScope, newFileScope, names)) continue;
            for (AbstractReference ref : refs) {
                Collection<DeclarationDescriptor> newTargets;
                Collection<DeclarationDescriptor> oldTargets;
                KtExpression expressionToAnalyze;
                ProgressManager.checkCanceled();
                KtElement element = ref.getElement();
                BindingContext bindingContext = ResolutionUtils.analyze(element, BodyResolveMode.PARTIAL);
                LexicalScope newScope = ScopeUtilsKt.replaceImportingScopes((LexicalScope)ScopeUtils.getResolutionScope((PsiElement)element, bindingContext, ResolutionUtils.getResolutionFacade((KtElement)this.file)), (ImportingScope)newFileScope);
                PsiElement parent2 = element.getParent();
                if (parent2 instanceof KtUserType) {
                    KtUserType qualifier2 = (KtUserType)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)parent2, OptimizedImportsBuilder::tryBuildOptimizedImports$lambda$19));
                    String string = qualifier2.getReferencedName();
                    if (string != null) {
                        ClassifierDescriptor oldTarget;
                        ClassifierDescriptor newTarget;
                        String name3;
                        String it3 = string;
                        boolean bl11 = false;
                        Name name2 = Name.identifier((String)it3);
                        string = name2;
                        if (name2 == null || ScopeUtilsKt.findClassifier((HierarchicalScope)((HierarchicalScope)originalFileScope), (Name)(name3 = string), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE)) == null || ((newTarget = ScopeUtilsKt.findClassifier((HierarchicalScope)((HierarchicalScope)newScope), (Name)name3, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE))) != null || this.getFromCurrentFile((DeclarationDescriptor)oldTarget)) && (newTarget == null || this.areTargetsEqual((DeclarationDescriptor)oldTarget, (DeclarationDescriptor)newTarget))) continue;
                        StringBuilder stringBuilder = testLog;
                        if (stringBuilder != null) {
                            stringBuilder.append("Changed resolve type of " + ref + "\n");
                        }
                        this.lockImportForDescriptor((DeclarationDescriptor)oldTarget, names);
                    }
                    continue;
                }
                if (this.getExpressionToAnalyze(element) == null) continue;
                BindingContext newBindingContext = ExtendedResolutionApiKt.analyzeAsReplacement$default(expressionToAnalyze, expressionToAnalyze, bindingContext, newScope, (BindingTrace)new BindingTraceContext(bindingContext.getProject()), null, 16, null);
                StringBuilder stringBuilder = testLog;
                if (stringBuilder != null) {
                    stringBuilder.append("Additional checking of reference " + ref + "\n");
                }
                if (this.areTargetsEqual(oldTargets = ref.resolve(bindingContext), newTargets = ref.resolve(newBindingContext))) continue;
                StringBuilder stringBuilder2 = testLog;
                if (stringBuilder2 != null) {
                    stringBuilder2.append("Changed resolve of " + ref + "\n");
                }
                Iterable $this$forEach$iv = CollectionsKt.plus(oldTargets, (Iterable)newTargets);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DeclarationDescriptor it4 = (DeclarationDescriptor)element$iv;
                    boolean bl12 = false;
                    this.lockImportForDescriptor(it4, names);
                }
            }
        }
        return sortedImportsToGenerate;
    }

    private final boolean getFromCurrentFile(DeclarationDescriptor $this$fromCurrentFile) {
        FqName fqName2 = ImportsUtils.getImportableFqName($this$fromCurrentFile);
        return Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.parent() : null), (Object)this.file.getPackageFqName());
    }

    private final void lockImportForDescriptor(DeclarationDescriptor descriptor2, Collection<Name> existingNames) {
        FqName fqName2 = this.getImportDescriptorWithMapping(descriptor2);
        if (fqName2 == null) {
            return;
        }
        FqName fqName3 = fqName2;
        Collection<Object> collection = this.data.getNamesToImport().get(fqName3);
        if (collection == null) {
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)descriptor2.getName());
        }
        Set names = CollectionsKt.intersect((Iterable)collection, (Iterable)CollectionsKt.toSet((Iterable)existingNames));
        ImportPath starImportPath = new ImportPath(fqName3.parent(), true, null, 4, null);
        for (Name name2 : names) {
            Name alias = !Intrinsics.areEqual((Object)name2, (Object)fqName3.shortName()) ? name2 : null;
            ImportPath explicitImportPath = new ImportPath(fqName3, false, alias);
            boolean bl = this.getImportPaths().contains(explicitImportPath) ? this.importRules.add(new ImportRule.Add(explicitImportPath)) : (alias == null && this.getImportPaths().contains(starImportPath) ? this.importRules.add(new ImportRule.Add(starImportPath)) : this.importRules.add(new ImportRule.DoNotAdd(starImportPath)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addExplicitImportsForClassesWhenRequired(Collection<FqName> classNamesToCheck, Map<FqName, ? extends Set<ImportableDescriptor>> descriptorsByParentFqName, Set<ImportPath> importsToGenerate, KtFile originalFile) {
        Object it;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = importsToGenerate;
        KtFile ktFile2 = originalFile;
        OptimizedImportsBuilder optimizedImportsBuilder = this;
        boolean $i$f$filter = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ImportPath)element$iv$iv;
            boolean bl = false;
            if (!it.isAllUnder()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        ImportingScope scope = optimizedImportsBuilder.buildScopeByImports(ktFile2, list2);
        for (FqName fqName2 : classNamesToCheck) {
            void $this$filterTo$iv$iv2;
            ClassifierDescriptor classifierDescriptor = ScopeUtilsKt.findClassifier((HierarchicalScope)((HierarchicalScope)scope), (Name)fqName2.shortName(), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
            if (Intrinsics.areEqual((Object)(classifierDescriptor != null ? ImportsUtils.getImportableFqName((DeclarationDescriptor)classifierDescriptor) : null), (Object)fqName2)) continue;
            importsToGenerate.add(new ImportPath(fqName2, false, null, 4, null));
            FqName parentFqName = fqName2.parent();
            Set siblingsToImport = (Set)MapsKt.getValue(descriptorsByParentFqName, (Object)parentFqName);
            Iterable $this$filter$iv2 = siblingsToImport;
            boolean $i$f$filter2 = false;
            it = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                ImportableDescriptor it2 = (ImportableDescriptor)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getFqName(), (Object)fqName2)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (ImportableDescriptor descriptor2 : (List)destination$iv$iv2) {
                siblingsToImport.remove(descriptor2);
            }
            if (!siblingsToImport.isEmpty()) continue;
            importsToGenerate.remove(new ImportPath(parentFqName, true, null, 4, null));
        }
    }

    private final ImportingScope buildScopeByImports(KtFile originalFile, Collection<ImportPath> importsToGenerate) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildScopeByImports_u24lambda_u2425 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildScopeByImports_u24lambda_u2425.append("package ");
        $this$buildScopeByImports_u24lambda_u2425.append(RenderingUtilsKt.render((FqNameUnsafe)originalFile.getPackageFqName().toUnsafe()));
        $this$buildScopeByImports_u24lambda_u2425.append("\n");
        for (ImportPath importPath : importsToGenerate) {
            $this$buildScopeByImports_u24lambda_u2425.append("import ");
            $this$buildScopeByImports_u24lambda_u2425.append(importPath.getPathStr());
            if (importPath.hasAlias()) {
                $this$buildScopeByImports_u24lambda_u2425.append("=");
                Name name2 = importPath.getAlias();
                Intrinsics.checkNotNull((Object)name2);
                $this$buildScopeByImports_u24lambda_u2425.append(RenderingUtilsKt.render((Name)name2));
            }
            $this$buildScopeByImports_u24lambda_u2425.append("\n");
        }
        String fileText = stringBuilder.toString();
        KtFile fileWithImports = KtPsiFactory.Companion.contextual$default((KtPsiFactory.Companion)KtPsiFactory.Companion, (PsiElement)((PsiElement)originalFile), (boolean)false, (boolean)false, (int)6, null).createFile("Dummy_" + originalFile.getName(), fileText);
        if (this.file.isScript()) {
            fileWithImports.setOriginalFile((PsiFile)originalFile);
        }
        return this.getFileResolutionScope(fileWithImports);
    }

    private final ImportingScope getFileResolutionScope(KtFile $this$getFileResolutionScope) {
        ResolutionFacade $this$frontendService$iv = ResolutionUtils.getResolutionFacade((KtElement)$this$getFileResolutionScope);
        boolean $i$f$frontendService = false;
        return $this$frontendService$iv.getFrontendService(FileScopeProvider.class).getFileScopes($this$getFileResolutionScope).getImportingScope();
    }

    private final boolean areScopeSlicesEqual(ImportingScope scope1, ImportingScope scope2, Collection<Name> names) {
        Sequence<Collection<DeclarationDescriptor>> tower1 = this.extractSliceTower(scope1, names);
        Sequence<Collection<DeclarationDescriptor>> tower2 = this.extractSliceTower(scope2, names);
        Iterator iterator1 = tower1.iterator();
        Iterator iterator2 = tower2.iterator();
        do {
            if (!iterator1.hasNext()) {
                return !iterator2.hasNext();
            }
            if (iterator2.hasNext()) continue;
            return false;
        } while (this.areTargetsEqual((Collection)iterator1.next(), (Collection)iterator2.next()));
        return false;
    }

    private final Sequence<Collection<DeclarationDescriptor>> extractSliceTower(ImportingScope $this$extractSliceTower, Collection<Name> names) {
        return SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ScopeUtilsKt.getParentsWithSelf((HierarchicalScope)((HierarchicalScope)$this$extractSliceTower)), arg_0 -> OptimizedImportsBuilder.extractSliceTower$lambda$27(names, arg_0)), OptimizedImportsBuilder::extractSliceTower$lambda$28);
    }

    private final boolean canUseStarImport(DeclarationDescriptor descriptor2, FqName fqName2) {
        boolean bl;
        if (fqName2.parent().isRoot()) {
            bl = false;
        } else {
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            bl = (classDescriptor != null ? classDescriptor.getKind() : null) != ClassKind.OBJECT;
        }
        return bl;
    }

    private final boolean needExplicitImport(FqName fqName2) {
        return this.hasAlias(fqName2) || !this.isImportedByDefault(fqName2);
    }

    private final boolean hasAlias(FqName fqName2) {
        boolean bl;
        Set<Name> set = this.data.getNamesToImport().get(fqName2);
        if (set != null) {
            Set<Name> it = set;
            boolean bl2 = false;
            bl = CollectionsKt.singleOrNull((Iterable)it) == null;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isImportedByDefault(FqName fqName2) {
        return this.importInsertHelper.isImportedWithDefault(new ImportPath(fqName2, false, null, 4, null), this.file);
    }

    private final boolean isImportedByLowPriorityDefault(FqName fqName2) {
        return this.importInsertHelper.isImportedWithLowPriorityDefaultImport(new ImportPath(fqName2, false, null, 4, null), this.file);
    }

    private final int nameCountToUseStar(DeclarationDescriptor $this$nameCountToUseStar) {
        boolean isMember = $this$nameCountToUseStar.getContainingDeclaration() instanceof ClassDescriptor;
        return isMember ? this.options.getNameCountToUseStarImportForMembers() : this.options.getNameCountToUseStarImport();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areTargetsEqual(Collection<? extends DeclarationDescriptor> descriptors1, Collection<? extends DeclarationDescriptor> descriptors2) {
        DeclarationDescriptor second;
        Pair pair;
        DeclarationDescriptor first2;
        if (descriptors1.size() != descriptors2.size()) return false;
        Iterable $this$all$iv = CollectionsKt.zip((Iterable)descriptors1, (Iterable)descriptors2);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            pair = (Pair)element$iv;
            boolean bl = false;
        } while (this.areTargetsEqual(first2 = (DeclarationDescriptor)pair.component1(), second = (DeclarationDescriptor)pair.component2()));
        return false;
    }

    private final boolean areTargetsEqual(DeclarationDescriptor first2, DeclarationDescriptor second) {
        FqName secondFqName;
        if (Intrinsics.areEqual((Object)first2, (Object)second)) {
            return true;
        }
        FqName firstFqName = this.getImportDescriptorWithMapping(first2);
        return Intrinsics.areEqual((Object)firstFqName, (Object)(secondFqName = this.getImportDescriptorWithMapping(second))) || this.isAliasTo(first2, second) && secondFqName != null && this.isImportedByLowPriorityDefault(secondFqName) || this.isAliasTo(second, first2) && firstFqName != null && this.isImportedByLowPriorityDefault(firstFqName);
    }

    private final boolean isAliasTo(DeclarationDescriptor $this$isAliasTo, DeclarationDescriptor other) {
        return $this$isAliasTo instanceof TypeAliasDescriptor && Intrinsics.areEqual((Object)((TypeAliasDescriptor)$this$isAliasTo).getClassDescriptor(), (Object)other) || $this$isAliasTo instanceof TypeAliasConstructorDescriptor && Intrinsics.areEqual((Object)((TypeAliasConstructorDescriptor)$this$isAliasTo).getUnderlyingConstructorDescriptor(), (Object)other);
    }

    private final boolean isAllowedByRules(ImportPath $this$isAllowedByRules) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.importRules;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ImportRule it = (ImportRule)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ImportRule.DoNotAdd && Intrinsics.areEqual((Object)((ImportRule.DoNotAdd)it).getImportPath(), (Object)$this$isAllowedByRules))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set importPaths_delegate$lambda$1(OptimizedImportsBuilder this$0) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this$0.file.getImportDirectives();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ImportPath it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtImportDirective it = (KtImportDirective)element$iv$iv;
            boolean bl2 = false;
            if (it.getImportPath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final boolean buildOptimizedImports$lambda$2(OptimizedImportsBuilder this$0, KtImportDirective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.mayReferToSomeUnresolvedName(it) || this$0.isExistedUnresolvedName(it);
    }

    private static final ImportPath buildOptimizedImports$lambda$3(KtImportDirective it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getImportPath();
    }

    private static final boolean tryBuildOptimizedImports$lambda$11(ImportableDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDescriptor() instanceof ClassDescriptor;
    }

    private static final FqName tryBuildOptimizedImports$lambda$12(OptimizedImportsBuilder this$0, ImportableDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getImportDescriptorWithMapping(it);
    }

    private static final KtUserType tryBuildOptimizedImports$lambda$19(KtUserType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getQualifier();
    }

    /*
     * WARNING - void declaration
     */
    private static final List extractSliceTower$lambda$27(Collection $names, HierarchicalScope scope) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Iterable $this$flatMap$iv = $names;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Name name2 = (Name)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Collection contributedFunctions = scope.getContributedFunctions(name2, (LookupLocation)NoLookupLocation.FROM_IDE);
            ProgressManager.checkCanceled();
            Collection contributedVariables = scope.getContributedVariables(name2, (LookupLocation)NoLookupLocation.FROM_IDE);
            ProgressManager.checkCanceled();
            ClassifierDescriptor contributedClassifier = scope.getContributedClassifier(name2, (LookupLocation)NoLookupLocation.FROM_IDE);
            Iterable list$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)contributedFunctions, (Iterable)contributedVariables), (Iterable)CollectionsKt.listOfNotNull((Object)contributedClassifier));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean extractSliceTower$lambda$28(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !((Collection)it).isEmpty();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000eH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$AbstractReference;", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "dependsOnNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getDependsOnNames", "()Ljava/util/Collection;", "resolve", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.idea"})
    public static interface AbstractReference {
        @NotNull
        public KtElement getElement();

        @NotNull
        public Collection<Name> getDependsOnNames();

        @NotNull
        public Collection<DeclarationDescriptor> resolve(@NotNull BindingContext var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R4\u0010\u0007\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$Companion;", "", "<init>", "()V", "value", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "testLog", "getTestLog", "()Ljava/lang/StringBuilder;", "setTestLog", "(Ljava/lang/StringBuilder;)V", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final StringBuilder getTestLog() {
            return testLog;
        }

        @TestOnly
        public final void setTestLog(@Nullable StringBuilder stringBuilder) {
            testLog = stringBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportRule;", "", "<init>", "()V", "Add", "DoNotAdd", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportRule$Add;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportRule$DoNotAdd;", "kotlin.idea"})
    private static abstract class ImportRule {
        private ImportRule() {
        }

        public /* synthetic */ ImportRule(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportRule$Add;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportRule;", "importPath", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "<init>", "(Lorg/jetbrains/kotlin/resolve/ImportPath;)V", "getImportPath", "()Lorg/jetbrains/kotlin/resolve/ImportPath;", "toString", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "kotlin.idea"})
        public static final class Add
        extends ImportRule {
            @NotNull
            private final ImportPath importPath;

            public Add(@NotNull ImportPath importPath) {
                Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
                super(null);
                this.importPath = importPath;
            }

            @NotNull
            public final ImportPath getImportPath() {
                return this.importPath;
            }

            @NotNull
            public String toString() {
                return "+" + this.importPath;
            }

            @NotNull
            public final ImportPath component1() {
                return this.importPath;
            }

            @NotNull
            public final Add copy(@NotNull ImportPath importPath) {
                Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
                return new Add(importPath);
            }

            public static /* synthetic */ Add copy$default(Add add2, ImportPath importPath, int n, Object object) {
                if ((n & 1) != 0) {
                    importPath = add2.importPath;
                }
                return add2.copy(importPath);
            }

            public int hashCode() {
                return this.importPath.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Add)) {
                    return false;
                }
                Add add2 = (Add)other;
                return Intrinsics.areEqual((Object)this.importPath, (Object)add2.importPath);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportRule$DoNotAdd;", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportRule;", "importPath", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "<init>", "(Lorg/jetbrains/kotlin/resolve/ImportPath;)V", "getImportPath", "()Lorg/jetbrains/kotlin/resolve/ImportPath;", "toString", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "kotlin.idea"})
        public static final class DoNotAdd
        extends ImportRule {
            @NotNull
            private final ImportPath importPath;

            public DoNotAdd(@NotNull ImportPath importPath) {
                Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
                super(null);
                this.importPath = importPath;
            }

            @NotNull
            public final ImportPath getImportPath() {
                return this.importPath;
            }

            @NotNull
            public String toString() {
                return "-" + this.importPath;
            }

            @NotNull
            public final ImportPath component1() {
                return this.importPath;
            }

            @NotNull
            public final DoNotAdd copy(@NotNull ImportPath importPath) {
                Intrinsics.checkNotNullParameter((Object)importPath, (String)"importPath");
                return new DoNotAdd(importPath);
            }

            public static /* synthetic */ DoNotAdd copy$default(DoNotAdd doNotAdd, ImportPath importPath, int n, Object object) {
                if ((n & 1) != 0) {
                    importPath = doNotAdd.importPath;
                }
                return doNotAdd.copy(importPath);
            }

            public int hashCode() {
                return this.importPath.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DoNotAdd)) {
                    return false;
                }
                DoNotAdd doNotAdd = (DoNotAdd)other;
                return Intrinsics.areEqual((Object)this.importPath, (Object)doNotAdd.importPath);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportableDescriptor;", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/name/FqName;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
    public static final class ImportableDescriptor {
        @NotNull
        private final DeclarationDescriptor descriptor;
        @NotNull
        private final FqName fqName;

        public ImportableDescriptor(@NotNull DeclarationDescriptor descriptor2, @NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            this.descriptor = descriptor2;
            this.fqName = fqName2;
        }

        @NotNull
        public final DeclarationDescriptor getDescriptor() {
            return this.descriptor;
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final DeclarationDescriptor component1() {
            return this.descriptor;
        }

        @NotNull
        public final FqName component2() {
            return this.fqName;
        }

        @NotNull
        public final ImportableDescriptor copy(@NotNull DeclarationDescriptor descriptor2, @NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            return new ImportableDescriptor(descriptor2, fqName2);
        }

        public static /* synthetic */ ImportableDescriptor copy$default(ImportableDescriptor importableDescriptor, DeclarationDescriptor declarationDescriptor, FqName fqName2, int n, Object object) {
            if ((n & 1) != 0) {
                declarationDescriptor = importableDescriptor.descriptor;
            }
            if ((n & 2) != 0) {
                fqName2 = importableDescriptor.fqName;
            }
            return importableDescriptor.copy(declarationDescriptor, fqName2);
        }

        @NotNull
        public String toString() {
            return "ImportableDescriptor(descriptor=" + this.descriptor + ", fqName=" + this.fqName + ")";
        }

        public int hashCode() {
            int result2 = this.descriptor.hashCode();
            result2 = result2 * 31 + this.fqName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImportableDescriptor)) {
                return false;
            }
            ImportableDescriptor importableDescriptor = (ImportableDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.descriptor, (Object)importableDescriptor.descriptor)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fqName, (Object)importableDescriptor.fqName);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$InputData;", "", "descriptorsToImport", "", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$ImportableDescriptor;", "namesToImport", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/name/Name;", "references", "", "Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$AbstractReference;", "unresolvedNames", "<init>", "(Ljava/util/Set;Ljava/util/Map;Ljava/util/Collection;Ljava/util/Set;)V", "getDescriptorsToImport", "()Ljava/util/Set;", "getNamesToImport", "()Ljava/util/Map;", "getReferences", "()Ljava/util/Collection;", "getUnresolvedNames", "kotlin.idea"})
    public static final class InputData {
        @NotNull
        private final Set<ImportableDescriptor> descriptorsToImport;
        @NotNull
        private final Map<FqName, Set<Name>> namesToImport;
        @NotNull
        private final Collection<AbstractReference> references;
        @NotNull
        private final Set<Name> unresolvedNames;

        public InputData(@NotNull Set<ImportableDescriptor> descriptorsToImport, @NotNull Map<FqName, ? extends Set<Name>> namesToImport, @NotNull Collection<? extends AbstractReference> references, @NotNull Set<Name> unresolvedNames) {
            Intrinsics.checkNotNullParameter(descriptorsToImport, (String)"descriptorsToImport");
            Intrinsics.checkNotNullParameter(namesToImport, (String)"namesToImport");
            Intrinsics.checkNotNullParameter(references, (String)"references");
            Intrinsics.checkNotNullParameter(unresolvedNames, (String)"unresolvedNames");
            this.descriptorsToImport = descriptorsToImport;
            this.namesToImport = namesToImport;
            this.references = references;
            this.unresolvedNames = unresolvedNames;
        }

        @NotNull
        public final Set<ImportableDescriptor> getDescriptorsToImport() {
            return this.descriptorsToImport;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getNamesToImport() {
            return this.namesToImport;
        }

        @NotNull
        public final Collection<AbstractReference> getReferences() {
            return this.references;
        }

        @NotNull
        public final Set<Name> getUnresolvedNames() {
            return this.unresolvedNames;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/imports/OptimizedImportsBuilder$Options;", "", "nameCountToUseStarImport", "", "nameCountToUseStarImportForMembers", "isInPackagesToUseStarImport", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/FqName;", "", "<init>", "(IILkotlin/jvm/functions/Function1;)V", "getNameCountToUseStarImport", "()I", "getNameCountToUseStarImportForMembers", "()Lkotlin/jvm/functions/Function1;", "kotlin.idea"})
    public static final class Options {
        private final int nameCountToUseStarImport;
        private final int nameCountToUseStarImportForMembers;
        @NotNull
        private final Function1<FqName, Boolean> isInPackagesToUseStarImport;

        public Options(int nameCountToUseStarImport, int nameCountToUseStarImportForMembers, @NotNull Function1<? super FqName, Boolean> isInPackagesToUseStarImport) {
            Intrinsics.checkNotNullParameter(isInPackagesToUseStarImport, (String)"isInPackagesToUseStarImport");
            this.nameCountToUseStarImport = nameCountToUseStarImport;
            this.nameCountToUseStarImportForMembers = nameCountToUseStarImportForMembers;
            this.isInPackagesToUseStarImport = isInPackagesToUseStarImport;
        }

        public final int getNameCountToUseStarImport() {
            return this.nameCountToUseStarImport;
        }

        public final int getNameCountToUseStarImportForMembers() {
            return this.nameCountToUseStarImportForMembers;
        }

        @NotNull
        public final Function1<FqName, Boolean> isInPackagesToUseStarImport() {
            return this.isInPackagesToUseStarImport;
        }
    }
}

