/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginMode;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinPluginKindSwitcherControllerKt;
import org.jetbrains.kotlin.idea.preferences.KotlinPreferencesBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinPluginKindSwitcherController;", "", "<init>", "()V", "initialValue", "Lorg/jetbrains/kotlin/idea/base/plugin/KotlinPluginMode;", "chosenKind", "pluginKindWillBeSwitchedAfterRestart", "", "getPluginKindWillBeSwitchedAfterRestart", "()Z", "checkBox", "Lcom/intellij/ui/components/JBCheckBox;", "pluginTypeChooserPanel", "Lcom/intellij/ui/dsl/builder/Panel;", "currentPluginPanel", "productName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getProductName", "()Ljava/lang/String;", "isModified", "applyChanges", "", "reset", "createComponent", "Ljavax/swing/JComponent;", "cancelSwitching", "updatePanels", "canSwitchKotlinPluginModeViaUI", "updateCheckBoxToChosenKind", "Companion", "kotlin.preferences"})
@SourceDebugExtension(value={"SMAP\nKotlinPluginKindSwitcherController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPluginKindSwitcherController.kt\norg/jetbrains/kotlin/idea/configuration/ui/KotlinPluginKindSwitcherController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class KotlinPluginKindSwitcherController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinPluginMode initialValue;
    @NotNull
    private KotlinPluginMode chosenKind;
    private JBCheckBox checkBox;
    private Panel pluginTypeChooserPanel;
    private Panel currentPluginPanel;

    public KotlinPluginKindSwitcherController() {
        this.chosenKind = this.initialValue = KotlinPluginKindSwitcherControllerKt.access$getPluginKindByVmOptions();
    }

    private final boolean getPluginKindWillBeSwitchedAfterRestart() {
        return KotlinPluginModeProvider.Companion.getCurrentPluginMode() != this.chosenKind;
    }

    private final String getProductName() {
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
        return string;
    }

    public final boolean isModified() {
        return KotlinPluginKindSwitcherControllerKt.access$getPluginKindByVmOptions() != this.chosenKind;
    }

    public final void applyChanges() {
        KotlinPluginKindSwitcherControllerKt.access$setUseK2Plugin(this.chosenKind == KotlinPluginMode.K2);
        this.updatePanels();
        if (this.getPluginKindWillBeSwitchedAfterRestart()) {
            Companion.suggestRestart(this.getProductName());
        }
    }

    public final void reset() {
        if (!this.isModified()) {
            return;
        }
        this.chosenKind = KotlinPluginKindSwitcherControllerKt.access$getPluginKindByVmOptions();
        this.updateCheckBoxToChosenKind();
        this.updatePanels();
    }

    @NotNull
    public final JComponent createComponent() {
        return (JComponent)BuilderKt.panel(arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14(this, arg_0));
    }

    private final void cancelSwitching() {
        this.chosenKind = KotlinPluginModeProvider.Companion.getCurrentPluginMode();
        this.updateCheckBoxToChosenKind();
        this.updatePanels();
    }

    private final void updatePanels() {
        boolean visible = this.canSwitchKotlinPluginModeViaUI() && this.getPluginKindWillBeSwitchedAfterRestart();
        Panel panel = this.currentPluginPanel;
        if (panel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentPluginPanel");
            panel = null;
        }
        panel.visible(visible);
        Panel panel2 = this.pluginTypeChooserPanel;
        if (panel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pluginTypeChooserPanel");
            panel2 = null;
        }
        panel2.visible(!visible);
    }

    private final boolean canSwitchKotlinPluginModeViaUI() {
        return VMOptions.canWriteOptions();
    }

    private final void updateCheckBoxToChosenKind() {
        JBCheckBox jBCheckBox = this.checkBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"checkBox");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(this.chosenKind == KotlinPluginMode.K2);
    }

    private static final Unit createComponent$lambda$14$lambda$6$lambda$0(KotlinPluginMode $currentPluginMode, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$currentPluginMode.getPluginModeDescription()};
        String text = KotlinPreferencesBundle.message("label.your.current.plugin", objectArray);
        Row.text$default((Row)$this$row, (String)text, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$6$lambda$1(KotlinPluginMode $currentPluginMode, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$currentPluginMode.getOther().getPluginModeDescription()};
        String text = KotlinPreferencesBundle.message("label.plugin.will.be.switched.after.ide.restart", objectArray);
        Row.text$default((Row)$this$row, (String)text, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$6$lambda$3$lambda$2(KotlinPluginKindSwitcherController this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Companion.suggestRestart(this$0.getProductName());
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$6$lambda$3(KotlinPluginKindSwitcherController this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{this$0.getProductName()};
        String string = IdeBundle.message((String)"dialog.message.must.be.restarted.for.changes.to.take.effect", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.link(string, arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$6$lambda$3$lambda$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$6$lambda$5$lambda$4(KotlinPluginKindSwitcherController this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.cancelSwitching();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$6$lambda$5(KotlinPluginKindSwitcherController this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.link(KotlinPreferencesBundle.message("link.label.cancel.switching", new Object[0]), arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$6$lambda$5$lambda$4(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$6(KotlinPluginKindSwitcherController this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        KotlinPluginMode currentPluginMode = KotlinPluginModeProvider.Companion.getCurrentPluginMode();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$6$lambda$0(currentPluginMode, arg_0), (int)1, null);
        if (this$0.canSwitchKotlinPluginModeViaUI()) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$6$lambda$1(currentPluginMode, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$6$lambda$3(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$6$lambda$5(this$0, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$13$lambda$9$lambda$8(KotlinPluginKindSwitcherController this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.chosenKind = KotlinPluginMode.Companion.of(it.isSelected());
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$13$lambda$9(KotlinPluginKindSwitcherController this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell it = cell = $this$row.checkBox(KotlinPreferencesBundle.message("checkbox.enable.k2.based.kotlin.plugin", new Object[0]));
        boolean bl = false;
        this$0.checkBox = (JBCheckBox)it.getComponent();
        $this$row.enabled(this$0.canSwitchKotlinPluginModeViaUI());
        cell.onChanged(arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$13$lambda$9$lambda$8(this$0, arg_0)).gap(RightGap.SMALL);
        this$0.updateCheckBoxToChosenKind();
        if (this$0.canSwitchKotlinPluginModeViaUI()) {
            Row.comment$default((Row)$this$row, (String)KotlinPreferencesBundle.message("kotlin.plugin.type.restart.required.comment", new Object[0]), (int)0, null, (int)6, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$13$lambda$11(KotlinPluginKindSwitcherController this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Icon icon2 = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Warning");
        $this$row.icon(icon2).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
        Object[] objectArray = new Object[3];
        objectArray[0] = this$0.getProductName();
        Integer n = 1;
        int n2 = ((Number)n).intValue();
        int n3 = 1;
        Object[] objectArray2 = objectArray;
        String string = "text.k2.based.kotlin.plugin.vmoptions.are.not.writable.0.1.2";
        Row row = $this$row;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)KotlinPluginKindSwitcherControllerKt.access$getUseK2Plugin(), (Object)true);
        Integer n4 = bl2 ? n : null;
        objectArray2[n3] = n4 != null ? n4 : 2;
        objectArray[2] = "-Didea.kotlin.plugin.use.k2=";
        Row.text$default((Row)row, (String)KotlinPreferencesBundle.message(string, objectArray), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$13$lambda$12(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.comment$default((Row)$this$row, (String)KotlinPreferencesBundle.message("text.k2.based.kotlin.plugin", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14$lambda$13(KotlinPluginKindSwitcherController this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$13$lambda$9(this$0, arg_0), (int)1, null);
        if (!this$0.canSwitchKotlinPluginModeViaUI()) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$13$lambda$11(this$0, arg_0), (int)1, null);
        }
        Panel.row$default((Panel)$this$panel, null, KotlinPluginKindSwitcherController::createComponent$lambda$14$lambda$13$lambda$12, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$14(KotlinPluginKindSwitcherController this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        this$0.currentPluginPanel = $this$panel.panel(arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$6(this$0, arg_0));
        this$0.pluginTypeChooserPanel = $this$panel.panel(arg_0 -> KotlinPluginKindSwitcherController.createComponent$lambda$14$lambda$13(this$0, arg_0));
        this$0.updatePanels();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinPluginKindSwitcherController$Companion;", "", "<init>", "()V", "createIfPluginSwitchIsPossible", "Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinPluginKindSwitcherController;", "suggestRestart", "", "productName", "", "kotlin.preferences"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinPluginKindSwitcherController createIfPluginSwitchIsPossible() {
            return new KotlinPluginKindSwitcherController();
        }

        public final void suggestRestart(@NotNull String productName) {
            Intrinsics.checkNotNullParameter((Object)productName, (String)"productName");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
            ApplicationEx application2 = (ApplicationEx)application;
            Object[] objectArray = new Object[]{productName};
            String string = IdeBundle.message((String)"dialog.message.must.be.restarted.for.changes.to.take.effect", (Object[])objectArray);
            objectArray = new Object[]{application2.isRestartCapable() ? 0 : 1};
            String string2 = IdeBundle.message((String)"button.now", (Object[])objectArray);
            objectArray = new Object[]{application2.isRestartCapable() ? 0 : 1};
            int result2 = Messages.showOkCancelDialog((String)string, (String)IdeBundle.message((String)"dialog.title.restart.required", (Object[])new Object[0]), (String)string2, (String)IdeBundle.message((String)"button.later", (Object[])objectArray), (Icon)Messages.getQuestionIcon());
            if (result2 == 0) {
                application2.restart(true);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

