/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.AddLoopLabelUtil;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\u000fH\u0016J\r\u0010\u0010\u001a\u00070\f\u00a2\u0006\u0002\b\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J#\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0094\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/quickFix/AddLoopLabelFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "Lcom/intellij/codeInspection/LocalQuickFix;", "loop", "jumpExpression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtLoopExpression;Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;)V", "jumpExpressionPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "existingLabelName", "", "description", "getText", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "addLoopLabel", "Lorg/jetbrains/kotlin/psi/KtExpression;", "loopExpression", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nAddLoopLabelFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddLoopLabelFix.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/quickFix/AddLoopLabelFix\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,76:1\n29#2,7:77\n*S KotlinDebug\n*F\n+ 1 AddLoopLabelFix.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/quickFix/AddLoopLabelFix\n*L\n68#1:77,7\n*E\n"})
public final class AddLoopLabelFix
extends KotlinQuickFixAction<KtLoopExpression>
implements LocalQuickFix {
    @NotNull
    private final SmartPsiElementPointer<KtExpressionWithLabel> jumpExpressionPointer;
    @Nullable
    private final String existingLabelName;
    @Nls
    @NotNull
    private final String description;

    /*
     * WARNING - void declaration
     */
    public AddLoopLabelFix(@NotNull KtLoopExpression loop, @NotNull KtExpressionWithLabel jumpExpression) {
        String string;
        void $this$description_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)jumpExpression, (String)"jumpExpression");
        super((PsiElement)loop);
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)jumpExpression));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.jumpExpressionPointer = smartPsiElementPointer;
        this.existingLabelName = AddLoopLabelUtil.INSTANCE.getExistingLabelName(loop);
        AddLoopLabelFix addLoopLabelFix = this;
        AddLoopLabelFix addLoopLabelFix2 = this;
        boolean bl = false;
        if ($this$description_u24lambda_u240.existingLabelName != null) {
            String labelName = "@" + $this$description_u24lambda_u240.existingLabelName;
            Object[] objectArray = new Object[2];
            objectArray[0] = labelName;
            Intrinsics.checkNotNullExpressionValue((Object)jumpExpression.getText(), (String)"getText(...)");
            string = KotlinBundle.message((String)"fix.add.loop.label.text", (Object[])objectArray);
        } else {
            string = KotlinBundle.message((String)"fix.add.loop.label.text.generic", (Object[])new Object[0]);
        }
        addLoopLabelFix2.description = string;
    }

    @NotNull
    public String getText() {
        return this.description;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.applyFix();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.applyFix();
    }

    private final void applyFix() {
        KtLoopExpression ktLoopExpression = (KtLoopExpression)this.getElement();
        if (ktLoopExpression == null) {
            return;
        }
        KtLoopExpression loopExpression = ktLoopExpression;
        KtExpressionWithLabel ktExpressionWithLabel = (KtExpressionWithLabel)this.jumpExpressionPointer.getElement();
        if (ktExpressionWithLabel == null) {
            return;
        }
        KtExpressionWithLabel jumpExpression = ktExpressionWithLabel;
        this.addLoopLabel(loopExpression, jumpExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression addLoopLabel(KtLoopExpression loopExpression, KtExpressionWithLabel jumpExpression) {
        KtExpression ktExpression;
        String string = AddLoopLabelUtil.INSTANCE.getExistingLabelName(loopExpression);
        if (string == null) {
            string = AddLoopLabelUtil.INSTANCE.getUniqueLabelName(loopExpression);
        }
        String labelName = string;
        Project project = loopExpression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        jumpExpression.replace((PsiElement)ktPsiFactory.createExpression(jumpExpression.getText() + "@" + labelName));
        if (AddLoopLabelUtil.INSTANCE.getExistingLabelName(loopExpression) == null) {
            PsiElement psiElement;
            void newElement$iv;
            void $this$replaced$iv;
            PsiElement psiElement2 = (PsiElement)loopExpression;
            Object[] objectArray = new Object[]{labelName, loopExpression};
            objectArray = (Object[])CreateByPatternKt.createExpressionByPattern((KtPsiFactory)ktPsiFactory, (String)"$0@ $1", (Object[])objectArray, (boolean)false);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression2;
                }
            }
            ktExpression = (KtExpression)psiElement;
        } else {
            ktExpression = (KtExpression)loopExpression;
        }
        return ktExpression;
    }
}

