/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKindKt;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H&J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\rJ\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0016H\u0004R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "", "<init>", "()V", "getStdlibJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "supportedLibraryKind", "Lorg/jetbrains/kotlin/idea/base/platforms/KotlinLibraryKind;", "getSupportedLibraryKind", "()Lorg/jetbrains/kotlin/idea/base/platforms/KotlinLibraryKind;", "isStdlib", "", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "ignoreKind", "getStdlibVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "isSupported", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "Lorg/jetbrains/kotlin/idea/base/platforms/KotlinJavaScriptStdlibDetectorFacility;", "Lorg/jetbrains/kotlin/idea/base/platforms/KotlinJvmStdlibDetectorFacility;", "kotlin.base.platforms"})
public abstract class StdlibDetectorFacility {
    private StdlibDetectorFacility() {
    }

    @Nullable
    public abstract VirtualFile getStdlibJar(@NotNull List<? extends VirtualFile> var1);

    @Nullable
    protected abstract KotlinLibraryKind getSupportedLibraryKind();

    public final boolean isStdlib(@NotNull Project project, @NotNull Library library, boolean ignoreKind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (!(library instanceof LibraryEx) || ((LibraryEx)library).isDisposed()) {
            return false;
        }
        if (!ignoreKind && !this.isSupported(project, (LibraryEx)library)) {
            return false;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        List classes = CollectionsKt.listOf((Object[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        return this.getStdlibJar(classes) != null;
    }

    public static /* synthetic */ boolean isStdlib$default(StdlibDetectorFacility stdlibDetectorFacility, Project project, Library library, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isStdlib");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return stdlibDetectorFacility.isStdlib(project, library, bl);
    }

    @Nullable
    public final IdeKotlinVersion getStdlibVersion(@NotNull List<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        VirtualFile virtualFile = this.getStdlibJar(roots);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile stdlibJar = virtualFile;
        return IdeKotlinVersion.Companion.fromManifest(stdlibJar);
    }

    @Nullable
    public final IdeKotlinVersion getStdlibVersion(@NotNull Project project, @NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (!(library instanceof LibraryEx) || ((LibraryEx)library).isDisposed() || !this.isSupported(project, (LibraryEx)library)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        return this.getStdlibVersion(ArraysKt.asList((Object[])virtualFileArray));
    }

    protected final boolean isSupported(@NotNull Project project, @NotNull LibraryEx library) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return Intrinsics.areEqual(KotlinLibraryKindKt.detectLibraryKind((Library)library, project), (Object)this.getSupportedLibraryKind());
    }

    public /* synthetic */ StdlibDetectorFacility(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

