/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.k2.roots;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.scripting.shared.GradleImportHelperKt;
import org.jetbrains.kotlin.gradle.scripting.shared.UtilsKt;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRoot;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootData;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootDataSerializer;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleScriptInfo;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Imported;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.Legacy;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.New;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J$\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00190\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/k2/roots/GradleBuildRootsLocatorImpl;", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootsLocator;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "loadLinkedRoot", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRoot;", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "version", "", "add", "", "newRoot", "remove", "rootPath", "updateNotifications", "unused", "", "shouldUpdatePath", "Lkotlin/Function1;", "updateFloatingAction", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "addFromSettings", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootData;", "data", "tryLoadFromFsCache", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/Imported;", "getScriptInfo", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleScriptInfo;", "localPath", "kotlin.gradle.scripting.k2"})
@SourceDebugExtension(value={"SMAP\nGradleBuildRootsLocatorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootsLocatorImpl.kt\norg/jetbrains/kotlin/gradle/scripting/k2/roots/GradleBuildRootsLocatorImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n11546#2,9:92\n13472#2:101\n13473#2:103\n11555#2:104\n1#3:102\n774#4:105\n865#4,2:106\n*S KotlinDebug\n*F\n+ 1 GradleBuildRootsLocatorImpl.kt\norg/jetbrains/kotlin/gradle/scripting/k2/roots/GradleBuildRootsLocatorImpl\n*L\n56#1:92,9\n56#1:101\n56#1:103\n56#1:104\n56#1:102\n57#1:105\n57#1:106,2\n*E\n"})
public final class GradleBuildRootsLocatorImpl
extends GradleBuildRootsLocator {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;

    public GradleBuildRootsLocatorImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project, coroutineScope);
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Override
    @NotNull
    public GradleBuildRoot loadLinkedRoot(@NotNull GradleProjectSettings settings2, @NotNull String version) {
        GradleBuildRoot gradleBuildRoot;
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        boolean supported = UtilsKt.kotlinDslScriptsModelImportSupported(version);
        if (supported) {
            Imported imported = this.tryLoadFromFsCache(settings2, version);
            gradleBuildRoot = imported != null ? (GradleBuildRoot)imported : (GradleBuildRoot)new New(settings2, null, 2, null);
        } else {
            gradleBuildRoot = new Legacy(settings2, null, 2, null);
        }
        return gradleBuildRoot;
    }

    @Override
    public void add(@NotNull GradleBuildRoot newRoot) {
        Intrinsics.checkNotNullParameter((Object)newRoot, (String)"newRoot");
        GradleBuildRoot old = this.getRoots().add(newRoot);
        if (old instanceof Imported && !(newRoot instanceof Imported)) {
            this.removeData(((Imported)old).getPathPrefix());
        }
        GradleBuildRootsLocator.updateNotifications$default(this, false, arg_0 -> GradleBuildRootsLocatorImpl.add$lambda$0(newRoot, arg_0), 1, null);
    }

    @Override
    public void remove(@NotNull String rootPath) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        GradleBuildRoot removed = this.getRoots().remove(rootPath);
        if (removed instanceof Imported) {
            this.removeData(rootPath);
        }
        GradleBuildRootsLocator.updateNotifications$default(this, false, arg_0 -> GradleBuildRootsLocatorImpl.remove$lambda$1(rootPath, arg_0), 1, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateNotifications(boolean unused, @NotNull Function1<? super String, Boolean> shouldUpdatePath) {
        Intrinsics.checkNotNullParameter(shouldUpdatePath, (String)"shouldUpdatePath");
        if (!this.project.isOpen()) {
            return;
        }
        v0 = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
        if (v0 != null && (v0 = v0.getFile()) != null) {
            it = v0;
            $i$a$-let-GradleBuildRootsLocatorImpl$updateNotifications$1 = false;
            v1 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
            if (((Boolean)shouldUpdatePath.invoke((Object)v1)).booleanValue()) {
                v2 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getPath(...)");
                if (this.maybeAffectedGradleProjectFile(v2)) {
                    this.updateFloatingAction((VirtualFile)it);
                }
            }
        }
        v3 = FileEditorManager.getInstance((Project)this.project).getSelectedEditors();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getSelectedEditors(...)");
        var4_6 = v3;
        $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var12_14 = ((void)$this$forEach$iv$iv$iv).length;
        for (var11_12 = 0; var11_12 < var12_14; ++var11_12) {
            element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var11_12];
            $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
            it = (FileEditor)element$iv$iv;
            $i$a$-mapNotNull-GradleBuildRootsLocatorImpl$updateNotifications$openedScripts$1 = false;
            if (it.getFile() == null) continue;
            $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (VirtualFile)element$iv$iv;
            $i$a$-filter-GradleBuildRootsLocatorImpl$updateNotifications$openedScripts$2 = false;
            v4 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getPath(...)");
            if (!((Boolean)shouldUpdatePath.invoke((Object)v4)).booleanValue()) ** GOTO lbl-1000
            v5 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getPath(...)");
            if (this.maybeAffectedGradleProjectFile(v5)) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            if (!v6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        openedScripts = (List)destination$iv$iv;
        if (openedScripts.isEmpty()) {
            return;
        }
        EditorNotifications.getInstance((Project)this.project).updateAllNotifications();
    }

    private final void updateFloatingAction(VirtualFile file) {
        block1: {
            if (!this.isConfigurationOutOfDate(file)) break block1;
            Object object = GradleBuildRootsLocator.Companion.getInstance(this.project).getScriptInfo(file);
            if (object != null && (object = ((GradleScriptInfo)object).getBuildRoot()) != null) {
                Object it = object;
                boolean bl = false;
                GradleImportHelperKt.runPartialGradleImport(this.project, (GradleBuildRoot)it);
            }
        }
    }

    private final GradleBuildRootData addFromSettings(GradleBuildRootData data, GradleProjectSettings settings2) {
        Set set = CollectionsKt.toSet((Iterable)data.getProjectRoots());
        Set set2 = settings2.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getModules(...)");
        return GradleBuildRootData.copy$default(data, 0L, SetsKt.plus((Set)set, (Iterable)set2), null, null, null, 29, null);
    }

    private final Imported tryLoadFromFsCache(GradleProjectSettings settings2, String version) {
        GradleBuildRootsLocator gradleBuildRootsLocator = this;
        String string = settings2.getExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
        return GradleBuildRootsLocator.tryCreateImportedRoot$default(gradleBuildRootsLocator, string, null, arg_0 -> GradleBuildRootsLocatorImpl.tryLoadFromFsCache$lambda$7(version, this, settings2, arg_0), 2, null);
    }

    @Override
    @Nullable
    public GradleScriptInfo getScriptInfo(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return null;
    }

    private static final boolean add$lambda$0(GradleBuildRoot $newRoot, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)$newRoot.getPathPrefix(), (boolean)false, (int)2, null);
    }

    private static final boolean remove$lambda$1(String $rootPath, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)$rootPath, (boolean)false, (int)2, null);
    }

    private static final GradleBuildRootData tryLoadFromFsCache$lambda$7(String $version, GradleBuildRootsLocatorImpl this$0, GradleProjectSettings $settings, VirtualFile it) {
        GradleBuildRootData gradleBuildRootData;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GradleBuildRootData gradleBuildRootData2 = GradleBuildRootDataSerializer.Companion.getInstance().read(it);
        if (gradleBuildRootData2 != null) {
            GradleBuildRootData data = gradleBuildRootData2;
            boolean bl = false;
            String gradleHome = data.getGradleHome();
            gradleBuildRootData = !StringsKt.isBlank((CharSequence)gradleHome) && !Intrinsics.areEqual((Object)GradleInstallationManager.Companion.getGradleVersion(Path.of(gradleHome, new String[0])), (Object)$version) ? null : this$0.addFromSettings(data, $settings);
        } else {
            gradleBuildRootData = null;
        }
        return gradleBuildRootData;
    }
}

