/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJA\u0010\u000e\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0015H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVisibilityQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;)V", "checkClassLikeSymbol", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isStandalone", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;Z)V", "toInvisibleCompanion", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
public final class FirVisibilityQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirVisibilityQualifierChecker INSTANCE = new FirVisibilityQualifierChecker();

    private FirVisibilityQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirResolvedQualifier expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FirClassLikeSymbol<?> firClassLikeSymbol = expression.getSymbol();
        if (firClassLikeSymbol == null) {
            return;
        }
        this.checkClassLikeSymbol(context, reporter, firClassLikeSymbol, expression, FirHelpersKt.isStandalone(context, expression));
    }

    private final void checkClassLikeSymbol(CheckerContext context, DiagnosticReporter reporter, FirClassLikeSymbol<?> symbol, FirResolvedQualifier expression, boolean isStandalone) {
        block8: {
            Object object;
            FirFileSymbol firFileSymbol = context.getContainingFileSymbol();
            if (firFileSymbol == null) {
                return;
            }
            FirFileSymbol containingFileSymbol = firFileSymbol;
            KtSourceElement ktSourceElement = expression.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitReceiver.INSTANCE) && !FirVisibilityCheckerKt.isClassLikeVisible(FirVisibilityCheckerKt.getVisibilityChecker(context.getSession()), symbol, context.getSession(), containingFileSymbol, context.getContainingDeclarations())) {
                List<FirDeclaration> list2;
                if (!(expression instanceof FirErrorResolvedQualifier && ((FirErrorResolvedQualifier)expression).getDiagnostic() instanceof ConeVisibilityError || ((list2 = context.getContainingFileSymbol()) != null && (list2 = (FirFile)((FirBasedSymbol)((Object)list2)).getFir()) != null && (list2 = ((FirFile)((Object)list2)).getDeclarations()) != null ? (FirDeclaration)CollectionsKt.singleOrNull(list2) : null) instanceof FirCodeFragment)) {
                    reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)symbol, expression.getSource(), context.getSession()), (DiagnosticContext)context);
                }
                return;
            }
            if (isStandalone) {
                FirRegularClassSymbol firRegularClassSymbol;
                FirRegularClassSymbol invisibleCompanion;
                FirClassLikeSymbol<?> firClassLikeSymbol = expression.getSymbol();
                FirRegularClassSymbol firRegularClassSymbol2 = invisibleCompanion = firClassLikeSymbol != null && (firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(firClassLikeSymbol, context.getSession())) != null ? this.toInvisibleCompanion(context, firRegularClassSymbol) : null;
                if (invisibleCompanion != null) {
                    List<FirDeclaration> list3;
                    if (!(expression instanceof FirErrorResolvedQualifier && ((FirErrorResolvedQualifier)expression).getDiagnostic() instanceof ConeVisibilityError || ((list3 = context.getContainingFileSymbol()) != null && (list3 = (FirFile)((FirBasedSymbol)((Object)list3)).getFir()) != null && (list3 = ((FirFile)((Object)list3)).getDeclarations()) != null ? (FirDeclaration)CollectionsKt.singleOrNull(list3) : null) instanceof FirCodeFragment)) {
                        reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(invisibleCompanion, expression.getSource(), context.getSession()), (DiagnosticContext)context);
                    }
                    return;
                }
            }
            if (symbol instanceof FirTypeAliasSymbol) {
                FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toClassLikeSymbol(((FirTypeAliasSymbol)symbol).getResolvedExpandedTypeRef().getConeType(), context.getSession());
                if (firClassLikeSymbol != null) {
                    FirClassLikeSymbol<?> it = firClassLikeSymbol;
                    boolean bl = false;
                    INSTANCE.checkClassLikeSymbol(context, reporter, it, expression, isStandalone);
                }
            }
            if ((object = FirVisibilityCheckerKt.getOwnerLookupTag((FirBasedSymbol)symbol)) == null || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context.getSession())) == null) break block8;
            Object it = object;
            boolean bl = false;
            INSTANCE.checkClassLikeSymbol(context, reporter, (FirClassLikeSymbol<?>)it, expression, false);
        }
    }

    private final FirRegularClassSymbol toInvisibleCompanion(CheckerContext context, FirRegularClassSymbol $this$toInvisibleCompanion) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirFileSymbol firFileSymbol = context.getContainingFileSymbol();
        if (firFileSymbol == null) {
            return null;
        }
        FirFileSymbol firFile = firFileSymbol;
        FirRegularClassSymbol firRegularClassSymbol2 = $this$toInvisibleCompanion.getResolvedCompanionObjectSymbol();
        if (firRegularClassSymbol2 != null) {
            FirRegularClassSymbol firRegularClassSymbol3;
            FirRegularClassSymbol it = firRegularClassSymbol3 = firRegularClassSymbol2;
            boolean bl = false;
            firRegularClassSymbol = !FirVisibilityCheckerKt.isClassLikeVisible(FirVisibilityCheckerKt.getVisibilityChecker(context.getSession()), it, context.getSession(), firFile, context.getContainingDeclarations()) ? firRegularClassSymbol3 : null;
        } else {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }
}

