/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.jacoco.ant.AntResourcesLocator;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.ZipMultiReportOutput;
import org.jacoco.report.check.IViolationsOutput;
import org.jacoco.report.check.Limit;
import org.jacoco.report.check.Rule;
import org.jacoco.report.check.RulesChecker;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportTask
extends Task {
    private final Union executiondataElement = new Union();
    private SessionInfoStore sessionInfoStore;
    private ExecutionDataStore executionDataStore;
    private final GroupElement structure = new GroupElement();
    private final List<FormatterElement> formatters = new ArrayList<FormatterElement>();

    public Union createExecutiondata() {
        return this.executiondataElement;
    }

    public GroupElement createStructure() {
        return this.structure;
    }

    public HTMLFormatterElement createHtml() {
        HTMLFormatterElement element = new HTMLFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public CSVFormatterElement createCsv() {
        CSVFormatterElement element = new CSVFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public CheckFormatterElement createCheck() {
        CheckFormatterElement element = new CheckFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public XMLFormatterElement createXml() {
        XMLFormatterElement element = new XMLFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public void execute() throws BuildException {
        this.loadExecutionData();
        try {
            IReportVisitor visitor = this.createVisitor();
            visitor.visitInfo(this.sessionInfoStore.getInfos(), this.executionDataStore.getContents());
            this.createReport(visitor, this.structure);
            visitor.visitEnd();
            for (FormatterElement f : this.formatters) {
                f.finish();
            }
        }
        catch (IOException e) {
            throw new BuildException("Error while creating report", (Throwable)e, this.getLocation());
        }
    }

    private void loadExecutionData() {
        ExecFileLoader loader = new ExecFileLoader();
        for (Resource resource : this.executiondataElement) {
            this.log(String.format("Loading execution data file %s", resource));
            InputStream in = null;
            try {
                in = resource.getInputStream();
                loader.load(in);
            }
            catch (IOException e) {
                throw new BuildException(String.format("Unable to read execution data file %s", resource), (Throwable)e, this.getLocation());
            }
            finally {
                FileUtils.close((InputStream)in);
            }
        }
        this.sessionInfoStore = loader.getSessionInfoStore();
        this.executionDataStore = loader.getExecutionDataStore();
    }

    private IReportVisitor createVisitor() throws IOException {
        ArrayList<IReportVisitor> visitors = new ArrayList<IReportVisitor>();
        for (FormatterElement f : this.formatters) {
            visitors.add(f.createVisitor());
        }
        return new MultiReportVisitor((List<IReportVisitor>)visitors);
    }

    private void createReport(IReportGroupVisitor visitor, GroupElement group) throws IOException {
        if (group.name == null) {
            throw new BuildException("Group name must be supplied", this.getLocation());
        }
        if (group.children.isEmpty()) {
            IBundleCoverage bundle = this.createBundle(group);
            SourceFilesElement sourcefiles = group.sourcefiles;
            AntResourcesLocator locator = new AntResourcesLocator(sourcefiles.encoding, sourcefiles.tabWidth);
            locator.addAll(sourcefiles.iterator());
            if (!locator.isEmpty()) {
                this.checkForMissingDebugInformation(bundle);
            }
            visitor.visitBundle(bundle, locator);
        } else {
            IReportGroupVisitor groupVisitor = visitor.visitGroup(group.name);
            for (GroupElement child : group.children) {
                this.createReport(groupVisitor, child);
            }
        }
    }

    private IBundleCoverage createBundle(GroupElement group) throws IOException {
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.executionDataStore, builder);
        for (Resource resource : group.classfiles) {
            if (resource.isDirectory() && resource instanceof FileResource) {
                analyzer.analyzeAll(((FileResource)resource).getFile());
                continue;
            }
            InputStream in = resource.getInputStream();
            analyzer.analyzeAll(in, resource.getName());
            in.close();
        }
        IBundleCoverage bundle = builder.getBundle(group.name);
        this.logBundleInfo(bundle, builder.getNoMatchClasses());
        return bundle;
    }

    private void logBundleInfo(IBundleCoverage bundle, Collection<IClassCoverage> nomatch) {
        this.log(String.format("Writing bundle '%s' with %s classes", bundle.getName(), bundle.getClassCounter().getTotalCount()));
        if (!nomatch.isEmpty()) {
            this.log(String.format("Classes in bundle '%s' do not match with execution data. For report generation the same class files must be used as at runtime.", bundle.getName()), 1);
            for (IClassCoverage c : nomatch) {
                this.log(String.format("Execution data for class %s does not match.", c.getName()), 1);
            }
        }
    }

    private void checkForMissingDebugInformation(ICoverageNode node) {
        if (node.containsCode() && node.getLineCounter().getTotalCount() == 0) {
            this.log(String.format("To enable source code annotation class files for bundle '%s' have to be compiled with debug information.", node.getName()), 1);
        }
    }

    static Locale parseLocale(String locale) {
        StringTokenizer st = new StringTokenizer(locale, "_");
        String language = st.hasMoreTokens() ? st.nextToken() : "";
        String country = st.hasMoreTokens() ? st.nextToken() : "";
        String variant = st.hasMoreTokens() ? st.nextToken() : "";
        return new Locale(language, country, variant);
    }

    public class CheckFormatterElement
    extends FormatterElement
    implements IViolationsOutput {
        private final List<Rule> rules;
        private boolean violations;
        private boolean failOnViolation;
        private String violationsPropery;

        public CheckFormatterElement() {
            this.rules = new ArrayList<Rule>();
            this.violations = false;
            this.failOnViolation = true;
            this.violationsPropery = null;
        }

        public Rule createRule() {
            Rule rule = new Rule();
            this.rules.add(rule);
            return rule;
        }

        public void setFailOnViolation(boolean flag) {
            this.failOnViolation = flag;
        }

        public void setViolationsProperty(String property) {
            this.violationsPropery = property;
        }

        public IReportVisitor createVisitor() throws IOException {
            RulesChecker formatter = new RulesChecker();
            formatter.setRules(this.rules);
            return formatter.createVisitor(this);
        }

        public void onViolation(ICoverageNode node, Rule rule, Limit limit, String message) {
            ReportTask.this.log(message, 0);
            this.violations = true;
            if (this.violationsPropery != null) {
                String old = ReportTask.this.getProject().getProperty(this.violationsPropery);
                String value = old == null ? message : String.format("%s\n%s", old, message);
                ReportTask.this.getProject().setProperty(this.violationsPropery, value);
            }
        }

        void finish() {
            if (this.violations && this.failOnViolation) {
                throw new BuildException("Coverage check failed due to violated rules.", ReportTask.this.getLocation());
            }
        }
    }

    public class XMLFormatterElement
    extends FormatterElement {
        private File destfile;
        private String encoding;

        public XMLFormatterElement() {
            this.encoding = "UTF-8";
        }

        public void setDestfile(File destfile) {
            this.destfile = destfile;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public IReportVisitor createVisitor() throws IOException {
            if (this.destfile == null) {
                throw new BuildException("Destination file must be supplied for xml report", ReportTask.this.getLocation());
            }
            XMLFormatter formatter = new XMLFormatter();
            formatter.setOutputEncoding(this.encoding);
            return formatter.createVisitor(new FileOutputStream(this.destfile));
        }
    }

    public class CSVFormatterElement
    extends FormatterElement {
        private File destfile;
        private String encoding;

        public CSVFormatterElement() {
            this.encoding = "UTF-8";
        }

        public void setDestfile(File destfile) {
            this.destfile = destfile;
        }

        public IReportVisitor createVisitor() throws IOException {
            if (this.destfile == null) {
                throw new BuildException("Destination file must be supplied for csv report", ReportTask.this.getLocation());
            }
            CSVFormatter formatter = new CSVFormatter();
            formatter.setOutputEncoding(this.encoding);
            return formatter.createVisitor(new FileOutputStream(this.destfile));
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }
    }

    public class HTMLFormatterElement
    extends FormatterElement {
        private File destdir;
        private File destfile;
        private String footer;
        private String encoding;
        private Locale locale;

        public HTMLFormatterElement() {
            this.footer = "";
            this.encoding = "UTF-8";
            this.locale = Locale.getDefault();
        }

        public void setDestdir(File destdir) {
            this.destdir = destdir;
        }

        public void setDestfile(File destfile) {
            this.destfile = destfile;
        }

        public void setFooter(String text) {
            this.footer = text;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setLocale(String locale) {
            this.locale = ReportTask.parseLocale(locale);
        }

        public IReportVisitor createVisitor() throws IOException {
            IMultiReportOutput output;
            if (this.destfile != null) {
                if (this.destdir != null) {
                    throw new BuildException("Either destination directory or file must be supplied, not both", ReportTask.this.getLocation());
                }
                FileOutputStream stream = new FileOutputStream(this.destfile);
                output = new ZipMultiReportOutput(stream);
            } else {
                if (this.destdir == null) {
                    throw new BuildException("Destination directory or file must be supplied for html report", ReportTask.this.getLocation());
                }
                output = new FileMultiReportOutput(this.destdir);
            }
            HTMLFormatter formatter = new HTMLFormatter();
            formatter.setFooterText(this.footer);
            formatter.setOutputEncoding(this.encoding);
            formatter.setLocale(this.locale);
            return formatter.createVisitor(output);
        }
    }

    private static abstract class FormatterElement {
        private FormatterElement() {
        }

        abstract IReportVisitor createVisitor() throws IOException;

        void finish() {
        }
    }

    public static class GroupElement {
        private final List<GroupElement> children = new ArrayList<GroupElement>();
        private final Union classfiles = new Union();
        private final SourceFilesElement sourcefiles = new SourceFilesElement();
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public GroupElement createGroup() {
            GroupElement group = new GroupElement();
            this.children.add(group);
            return group;
        }

        public Union createClassfiles() {
            return this.classfiles;
        }

        public SourceFilesElement createSourcefiles() {
            return this.sourcefiles;
        }
    }

    public static class SourceFilesElement
    extends Union {
        String encoding = null;
        int tabWidth = 4;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setTabwidth(int tabWidth) {
            if (tabWidth <= 0) {
                throw new BuildException("Tab width must be greater than 0");
            }
            this.tabWidth = tabWidth;
        }
    }
}

