/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.InjectionAssertionData;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a-\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003\u00a2\u0006\u0002\u0010\n\u001a/\u0010\u000b\u001a\u00020\u0005*\u00020\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003\u00a2\u0006\u0002\u0010\u000f\u001a.\u0010\u000b\u001a\u00020\u0005\"\u0006\b\u0000\u0010\u0010\u0018\u0001*\u00020\u00062\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003H\u0086\b\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"injectionForHost", "Lcom/intellij/testFramework/fixtures/InjectionAssertionData;", "text", "", "assertInjectedLanguage", "", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "langId", "fragmentTexts", "", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;Ljava/lang/String;[Ljava/lang/String;)V", "assertInjectedReference", "referenceClass", "Ljava/lang/Class;", "referenceTexts", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;Ljava/lang/Class;[Ljava/lang/String;)V", "T", "(Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;[Ljava/lang/String;)V", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nInjectionTestFixture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InjectionTestFixture.kt\ncom/intellij/testFramework/fixtures/InjectionTestFixtureKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class InjectionTestFixtureKt {
    @NotNull
    public static final InjectionAssertionData injectionForHost(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new InjectionAssertionData(text, null, 2, null);
    }

    public static final void assertInjectedLanguage(@NotNull CodeInsightTestFixture $this$assertInjectedLanguage, @Nullable String langId, String ... fragmentTexts) {
        Intrinsics.checkNotNullParameter((Object)$this$assertInjectedLanguage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fragmentTexts, (String)"fragmentTexts");
        ActionsKt.runReadAction(() -> InjectionTestFixtureKt.assertInjectedLanguage$lambda$0($this$assertInjectedLanguage, fragmentTexts, langId));
    }

    public static final void assertInjectedReference(@NotNull CodeInsightTestFixture $this$assertInjectedReference, @NotNull Class<?> referenceClass, String ... referenceTexts) {
        Intrinsics.checkNotNullParameter((Object)$this$assertInjectedReference, (String)"<this>");
        Intrinsics.checkNotNullParameter(referenceClass, (String)"referenceClass");
        Intrinsics.checkNotNullParameter((Object)referenceTexts, (String)"referenceTexts");
        ActionsKt.runReadAction(() -> InjectionTestFixtureKt.assertInjectedReference$lambda$2($this$assertInjectedReference, referenceTexts, referenceClass));
    }

    public static final /* synthetic */ <T> void assertInjectedReference(CodeInsightTestFixture $this$assertInjectedReference, String ... fragmentTexts) {
        Intrinsics.checkNotNullParameter((Object)$this$assertInjectedReference, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fragmentTexts, (String)"fragmentTexts");
        boolean $i$f$assertInjectedReference = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        InjectionTestFixtureKt.assertInjectedReference($this$assertInjectedReference, Object.class, Arrays.copyOf(fragmentTexts, fragmentTexts.length));
    }

    private static final Unit assertInjectedLanguage$lambda$0(CodeInsightTestFixture $this_assertInjectedLanguage, String[] $fragmentTexts, String $langId) {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)$this_assertInjectedLanguage.getProject());
        Document document = $this_assertInjectedLanguage.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        for (String text : $fragmentTexts) {
            String string = doc.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            int index = StringsKt.indexOf$default((CharSequence)string, (String)text, (int)0, (boolean)false, (int)6, null);
            if (index < 0) {
                Assert.fail((String)("No such text in document: " + text));
            }
            int pos = index + text.length() / 2;
            PsiElement injectedElement = injectedLanguageManager.findInjectedElementAt($this_assertInjectedLanguage.getFile(), pos);
            if ($langId != null) {
                Assert.assertNotNull((String)("There should be injected element at " + pos + " with text '" + text + "'"), (Object)injectedElement);
                PsiElement psiElement = injectedElement;
                Intrinsics.checkNotNull((Object)psiElement);
                Assert.assertEquals((String)"Injected Language don't match", (Object)$langId, (Object)psiElement.getLanguage().getID());
                continue;
            }
            Assert.assertNull((String)("There should be no injected element at " + pos + " with text '" + text + "'"), (Object)injectedElement);
        }
        return Unit.INSTANCE;
    }

    private static final Unit assertInjectedReference$lambda$2(CodeInsightTestFixture $this_assertInjectedReference, String[] $referenceTexts, Class $referenceClass) {
        FileViewProvider fileViewProvider = $this_assertInjectedReference.getFile().getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        FileViewProvider provider = fileViewProvider;
        String string = $this_assertInjectedReference.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String documentText = string;
        for (String refText : $referenceTexts) {
            PsiReference psiReference;
            block3: {
                PsiReference[] references;
                int pos = StringsKt.indexOf$default((CharSequence)documentText, (String)refText, (int)0, (boolean)false, (int)6, null) + refText.length() / 2;
                PsiElement element = provider.findElementAt(pos);
                Assert.assertNotNull((String)("There should be element at " + pos), (Object)element);
                Object object = element instanceof PsiLanguageInjectionHost ? (PsiLanguageInjectionHost)element : null;
                if (object == null) {
                    PsiElement psiElement = element;
                    Intrinsics.checkNotNull((Object)psiElement);
                    PsiElement psiElement2 = psiElement.getParent();
                    object = psiElement2 instanceof PsiLanguageInjectionHost ? (PsiLanguageInjectionHost)psiElement2 : null;
                }
                PsiLanguageInjectionHost host = object;
                Assert.assertNotNull((String)("There should be injection host at " + pos), (Object)host);
                PsiLanguageInjectionHost psiLanguageInjectionHost = host;
                Intrinsics.checkNotNull((Object)psiLanguageInjectionHost);
                Intrinsics.checkNotNullExpressionValue((Object)psiLanguageInjectionHost.getReferences(), (String)"getReferences(...)");
                Assert.assertTrue((String)"There should be references in element", (!(references.length == 0) ? 1 : 0) != 0);
                PsiReference[] psiReferenceArray = references;
                int n = psiReferenceArray.length;
                for (int j = 0; j < n; ++j) {
                    PsiReference psiReference2;
                    PsiReference it = psiReference2 = psiReferenceArray[j];
                    boolean bl = false;
                    if (!$referenceClass.isInstance(it)) continue;
                    psiReference = psiReference2;
                    break block3;
                }
                psiReference = null;
            }
            PsiReference reference = psiReference;
            Assert.assertNotNull((String)("There should be reference of type " + $referenceClass + " in element"), reference);
        }
        return Unit.INSTANCE;
    }
}

