/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EmptyIcon;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ImportFromSourcesTestCase
extends HeavyPlatformTestCase {
    private ProjectFromSourcesBuilderImpl myBuilder;
    private File myRootDir;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.myBuilder = new ProjectFromSourcesBuilderImpl(new WizardContext(null, this.getTestRootDisposable()), ModulesProvider.EMPTY_MODULES_PROVIDER);
    }

    @Override
    protected void tearDown() throws Exception {
        this.myBuilder = null;
        super.tearDown();
    }

    @Override
    protected void setUpProject() {
    }

    protected Module assertOneModule(@NotNull ModuleType<?> moduleType) {
        if (moduleType == null) {
            ImportFromSourcesTestCase.$$$reportNull$$$0(0);
        }
        Module module2 = ImportFromSourcesTestCase.assertOneElement(ModuleManager.getInstance((Project)this.myProject).getModules());
        ImportFromSourcesTestCase.assertEquals(moduleType, (Object)ModuleType.get((Module)module2));
        return module2;
    }

    protected void assertOneContentRoot(@NotNull Module module2, String relativePath) {
        if (module2 == null) {
            ImportFromSourcesTestCase.$$$reportNull$$$0(1);
        }
        File expected = new File(this.myRootDir, relativePath);
        String url = ImportFromSourcesTestCase.assertOneElement(ModuleRootManager.getInstance((Module)module2).getContentRootUrls());
        File actual = new File(VfsUtilCore.urlToPath((String)url));
        ImportFromSourcesTestCase.assertEquals((String)expected.getAbsolutePath(), (String)actual.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFromSources(File dir) {
        this.myRootDir = dir;
        this.myProject = this.doCreateAndOpenProject();
        this.myBuilder.setBaseProjectPath(dir.getAbsolutePath());
        List list = RootDetectionProcessor.detectRoots((File)dir);
        MultiMap map = RootDetectionProcessor.createRootsMap((List)list);
        this.myBuilder.setupProjectStructure(map);
        for (ProjectStructureDetector detector : map.keySet()) {
            List steps = detector.createWizardSteps((ProjectFromSourcesBuilder)this.myBuilder, this.myBuilder.getProjectDescriptor(detector), EmptyIcon.ICON_16);
            try {
                for (ModuleWizardStep step : steps) {
                    if (!(step instanceof AbstractStepWithProgress)) continue;
                    ImportFromSourcesTestCase.performStep((AbstractStepWithProgress)step);
                }
            }
            finally {
                for (ModuleWizardStep step : steps) {
                    step.disposeUIResources();
                }
            }
        }
        this.myBuilder.commit(this.myProject, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
    }

    private static <Result> void performStep(AbstractStepWithProgress<Result> step) {
        step.performStep();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectWizard/ImportFromSourcesTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assertOneModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "assertOneContentRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

