/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.test;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.uast.UastVisitorAdapter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.uast.UAnchorOwner;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UVariableKt;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInspection/test/TestOnlyInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "isDirectlyTestOnly", "member", "Lorg/jetbrains/uast/UDeclaration;", "TestOnlyApiUsageVisitor", "TestOnlyApiUsageProcessor", "intellij.jvm.analysis.impl"})
@VisibleForTesting
public final class TestOnlyInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new UastVisitorAdapter((AbstractUastNonRecursiveVisitor)new TestOnlyApiUsageVisitor(new TestOnlyApiUsageProcessor(holder), holder), true);
    }

    private final boolean isDirectlyTestOnly(UDeclaration member) {
        return UVariableKt.findSourceAnnotation((UAnnotated)((UAnnotated)member), (String)"org.jetbrains.annotations.TestOnly") != null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J,\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020 2\b\u0010\u001a\u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\fH\u0002J-\u0010$\u001a\u0004\u0018\u0001H%\"\b\b\u0000\u0010%*\u00020\f*\u00020\f2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u0002H%0'H\u0002\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020 2\u0006\u0010#\u001a\u00020*H\u0002J \u0010+\u001a\u00020\n2\u0006\u0010#\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/codeInspection/test/TestOnlyInspection$TestOnlyApiUsageProcessor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageProcessor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/test/TestOnlyInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "modifierPriority", "", "", "processReference", "", "sourceNode", "Lorg/jetbrains/uast/UElement;", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "qualifier", "Lorg/jetbrains/uast/UExpression;", "processConstructorInvocation", "instantiatedClass", "Lcom/intellij/psi/PsiClass;", "constructor", "Lcom/intellij/psi/PsiMethod;", "subclassDeclaration", "Lorg/jetbrains/uast/UClass;", "validate", "place", "member", "getNextLowerAccessLevel", "getAccessModifierWithoutTesting", "anno", "Lcom/intellij/psi/PsiAnnotation;", "isAnnotatedAsTestOnly", "", "Lorg/jetbrains/uast/UDeclaration;", "isInsideTestClass", "elem", "getTopLevelParentOfType", "T", "c", "Ljava/lang/Class;", "(Lorg/jetbrains/uast/UElement;Ljava/lang/Class;)Lorg/jetbrains/uast/UElement;", "isUnderTestSources", "Lcom/intellij/psi/PsiElement;", "reportProblem", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nTestOnlyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestOnlyInspection.kt\ncom/intellij/codeInspection/test/TestOnlyInspection$TestOnlyApiUsageProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TestOnlyInspection.kt\ncom/intellij/codeInspection/test/TestOnlyInspectionKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1#2:168\n21#3,3:169\n20#3,5:172\n360#4,7:177\n360#4,7:184\n*S KotlinDebug\n*F\n+ 1 TestOnlyInspection.kt\ncom/intellij/codeInspection/test/TestOnlyInspection$TestOnlyApiUsageProcessor\n*L\n91#1:169,3\n91#1:172,5\n108#1:177,7\n112#1:184,7\n*E\n"})
    public final class TestOnlyApiUsageProcessor
    implements ApiUsageProcessor {
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final List<String> modifierPriority;

        public TestOnlyApiUsageProcessor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
            Object[] objectArray = new String[]{"public", "protected", "packageLocal", "private"};
            this.modifierPriority = CollectionsKt.listOf((Object[])objectArray);
        }

        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (target instanceof PsiMember && !(sourceNode.getUastParent() instanceof UComment)) {
                this.validate(sourceNode, target, this.holder);
            }
        }

        public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)sourceNode, (String)"sourceNode");
                Intrinsics.checkNotNullParameter((Object)instantiatedClass, (String)"instantiatedClass");
                PsiMethod psiMethod = constructor;
                if (psiMethod == null) break block0;
                PsiMethod it = psiMethod;
                boolean bl = false;
                this.validate(sourceNode, (PsiModifierListOwner)it, this.holder);
            }
        }

        private final void validate(UElement place, PsiModifierListOwner member, ProblemsHolder holder) {
            PsiElement psiElement = place.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement sourcePsi = psiElement;
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)member));
            if (uElement == null) {
                return;
            }
            UElement uMember = uElement;
            if (!(uMember instanceof UDeclaration)) {
                return;
            }
            boolean $i$f$getVisibleForTestingAnnotations = false;
            Object[] objectArray = new String[]{"com.google.common.annotations.VisibleForTesting", "com.android.annotations.VisibleForTesting", "org.jetbrains.annotations.VisibleForTesting"};
            PsiAnnotation vft = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (Collection)CollectionsKt.listOf((Object[])objectArray));
            if (vft == null && !this.isAnnotatedAsTestOnly((UDeclaration)uMember)) {
                return;
            }
            if (this.isAnnotatedAsTestOnly((UDeclaration)UastUtils.getContainingUMethod((UElement)place))) {
                return;
            }
            if (this.isAnnotatedAsTestOnly((UDeclaration)UastUtils.getContainingUVariable((UElement)place))) {
                return;
            }
            if (this.isAnnotatedAsTestOnly((UDeclaration)UastUtils.getContainingUClass((UElement)place))) {
                return;
            }
            if (this.isInsideTestClass(place)) {
                return;
            }
            if (this.isUnderTestSources(sourcePsi)) {
                return;
            }
            if (vft != null && member instanceof PsiMember) {
                String modifier = this.getAccessModifierWithoutTesting(vft);
                if (modifier == null) {
                    modifier = this.getNextLowerAccessLevel(member);
                }
                String[] stringArray = new String[]{modifier};
                LightModifierList modList = new LightModifierList(((PsiMember)member).getManager(), (Language)JavaLanguage.INSTANCE, stringArray);
                if (JavaResolveUtil.isAccessible((PsiMember)((PsiMember)member), (PsiClass)((PsiMember)member).getContainingClass(), (PsiModifierList)((PsiModifierList)modList), (PsiElement)sourcePsi, null, null)) {
                    return;
                }
            }
            this.reportProblem(sourcePsi, member, holder);
        }

        private final String getNextLowerAccessLevel(PsiModifierListOwner member) {
            int n;
            block6: {
                List<String> $this$indexOfFirst$iv = this.modifierPriority;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    String item$iv;
                    String name = item$iv = iterator.next();
                    boolean bl = false;
                    if (member.hasModifierProperty(name)) {
                        n = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int methodModifier = n;
            int minModifier = this.modifierPriority.size() - 1;
            if (member instanceof PsiMethod) {
                for (PsiMethod superMethod : ((PsiMethod)member).findSuperMethods()) {
                    int n2;
                    block7: {
                        List<String> $this$indexOfFirst$iv = this.modifierPriority;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
                        while (iterator.hasNext()) {
                            String item$iv;
                            String name = item$iv = iterator.next();
                            boolean bl = false;
                            if (superMethod.hasModifierProperty(name)) {
                                n2 = index$iv;
                                break block7;
                            }
                            ++index$iv;
                        }
                        n2 = -1;
                    }
                    int n3 = n2;
                    minModifier = Math.min(minModifier, n3);
                }
            }
            return this.modifierPriority.get(Math.min(minModifier, methodModifier + 1));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getAccessModifierWithoutTesting(PsiAnnotation anno) {
            PsiAnnotationMemberValue ref = anno.findAttributeValue("visibility");
            if (!(ref instanceof PsiReferenceExpression)) return null;
            PsiElement target = ((PsiReferenceExpression)ref).resolve();
            if (!(target instanceof PsiEnumConstant)) return null;
            String string = ((PsiEnumConstant)target).getName();
            switch (string.hashCode()) {
                case -2116912242: {
                    if (string.equals("PROTECTED")) return "protected";
                    return "packageLocal";
                }
                case 403485027: {
                    if (!string.equals("PRIVATE")) return "packageLocal";
                    return "private";
                }
            }
            return "packageLocal";
        }

        private final boolean isAnnotatedAsTestOnly(UDeclaration member) {
            return member != null && TestOnlyInspection.this.isDirectlyTestOnly(member);
        }

        private final boolean isInsideTestClass(UElement elem) {
            UClass topLevelClass = this.getTopLevelParentOfType(elem, UClass.class);
            UClass uClass = topLevelClass;
            if (uClass == null || (uClass = uClass.getJavaPsi()) == null) {
                return false;
            }
            UClass javaTopLevelClass = uClass;
            return TestFrameworks.getInstance().isTestClass((PsiClass)javaTopLevelClass);
        }

        private final <T extends UElement> T getTopLevelParentOfType(UElement $this$getTopLevelParentOfType, Class<? extends T> c) {
            UElement uElement = UastUtils.getParentOfType$default((UElement)$this$getTopLevelParentOfType, c, (boolean)false, (int)2, null);
            if (uElement == null) {
                return null;
            }
            UElement parent = uElement;
            while (true) {
                if (UastUtils.getParentOfType$default((UElement)parent, c, (boolean)false, (int)2, null) != null) continue;
                return (T)parent;
            }
        }

        private final boolean isUnderTestSources(PsiElement elem) {
            ProjectRootManager rootManger = ProjectRootManager.getInstance((Project)elem.getProject());
            VirtualFile file = elem.getContainingFile().getVirtualFile();
            return file != null && rootManger.getFileIndex().isInTestSourceContent(file);
        }

        private final void reportProblem(PsiElement elem, PsiModifierListOwner target, ProblemsHolder holder) {
            String message = JvmAnalysisBundle.message(target instanceof PsiMethod && ((PsiMethod)target).isConstructor() ? "jvm.inspections.testonly.class.reference" : (target instanceof PsiField ? "jvm.inspections.testonly.field.reference" : "jvm.inspections.testonly.method.call"), new Object[0]);
            holder.registerProblem(elem, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInspection/test/TestOnlyInspection$TestOnlyApiUsageVisitor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageUastVisitor;", "processor", "Lcom/intellij/codeInspection/test/TestOnlyInspection$TestOnlyApiUsageProcessor;", "Lcom/intellij/codeInspection/test/TestOnlyInspection;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/test/TestOnlyInspection;Lcom/intellij/codeInspection/test/TestOnlyInspection$TestOnlyApiUsageProcessor;Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitClass", "", "node", "Lorg/jetbrains/uast/UClass;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "visitField", "Lorg/jetbrains/uast/UField;", "checkDoubleAnnotation", "", "elem", "Lorg/jetbrains/uast/UDeclaration;", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nTestOnlyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestOnlyInspection.kt\ncom/intellij/codeInspection/test/TestOnlyInspection$TestOnlyApiUsageVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TestOnlyInspection.kt\ncom/intellij/codeInspection/test/TestOnlyInspectionKt\n*L\n1#1,167:1\n1#2:168\n21#3,3:169\n20#3,5:172\n*S KotlinDebug\n*F\n+ 1 TestOnlyInspection.kt\ncom/intellij/codeInspection/test/TestOnlyInspection$TestOnlyApiUsageVisitor\n*L\n54#1:169,3\n54#1:172,5\n*E\n"})
    public final class TestOnlyApiUsageVisitor
    extends ApiUsageUastVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public TestOnlyApiUsageVisitor(@NotNull TestOnlyApiUsageProcessor processor, ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            super((ApiUsageProcessor)processor);
            this.holder = holder;
        }

        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitClass(node);
            this.checkDoubleAnnotation((UDeclaration)node);
            return true;
        }

        public boolean visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitMethod(node);
            this.checkDoubleAnnotation((UDeclaration)node);
            return true;
        }

        public boolean visitField(@NotNull UField node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitField(node);
            this.checkDoubleAnnotation((UDeclaration)node);
            return true;
        }

        private final void checkDoubleAnnotation(UDeclaration elem) {
            Object v0;
            LocalQuickFix[] localQuickFixArray;
            block4: {
                localQuickFixArray = (LocalQuickFix[])elem.getUAnnotations();
                for (Object t : localQuickFixArray) {
                    UAnnotation it = (UAnnotation)t;
                    boolean bl = false;
                    boolean $i$f$getVisibleForTestingAnnotations = false;
                    Object[] objectArray = new String[]{"com.google.common.annotations.VisibleForTesting", "com.android.annotations.VisibleForTesting", "org.jetbrains.annotations.VisibleForTesting"};
                    if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)it.getQualifiedName())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            UAnnotation uAnnotation = v0;
            if (uAnnotation == null) {
                return;
            }
            UAnnotation vft = uAnnotation;
            if (TestOnlyInspection.this.isDirectlyTestOnly(elem)) {
                PsiAnnotation psiAnnotation = vft.getJavaPsi();
                if (psiAnnotation == null) {
                    return;
                }
                PsiAnnotation vftJavaPsi = psiAnnotation;
                PsiElement elemJavaPsi = elem.getJavaPsi();
                UAnchorOwner uAnchorOwner = (UAnchorOwner)vft;
                String string = JvmAnalysisBundle.message("jvm.inspections.testonly.visiblefortesting", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                localQuickFixArray = new LocalQuickFix[1];
                Intrinsics.checkNotNull((Object)elemJavaPsi, (String)"null cannot be cast to non-null type com.intellij.psi.PsiModifierListOwner");
                localQuickFixArray[0] = new RemoveAnnotationQuickFix(vftJavaPsi, (PsiModifierListOwner)elemJavaPsi);
                ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UAnchorOwner)uAnchorOwner, (String)string, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
            }
        }
    }
}

