/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.indexer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.DefaultScannerListener;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenIndexId;
import org.jetbrains.idea.maven.server.AddArtifactResponse;
import org.jetbrains.idea.maven.server.IndexedMavenId;
import org.jetbrains.idea.maven.server.MavenProcessCanceledRuntimeException;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.indexer.MavenServerSideCancelledThrottler;
import org.jetbrains.idea.maven.server.indexer.TinyArtifactInfoIndexCreator;
import org.jetbrains.idea.maven.server.indexer.WagonTransferListenerAdapter;
import org.jetbrains.idea.maven.server.security.MavenToken;

public class MavenIdeaIndexerImpl
extends MavenRemoteObject
implements MavenServerIndexer {
    protected final Map<String, IndexingContext> myContexts = new HashMap<String, IndexingContext>();
    protected final Set<String> myLocks = Collections.synchronizedSet(new HashSet());
    private final Indexer myIndexer;
    private final IndexUpdater myUpdater;
    private final Scanner myScanner;
    private final PlexusContainer myContainer;
    private final ArtifactContextProducer myArtifactContextProducer;
    private final ExecutorService myRemoteExecutorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "indexing-remote"));

    public MavenIdeaIndexerImpl(PlexusContainer container) throws ComponentLookupException {
        this.myContainer = container;
        this.myIndexer = (Indexer)this.myContainer.lookup(Indexer.class);
        this.myUpdater = (IndexUpdater)this.myContainer.lookup(IndexUpdater.class);
        this.myScanner = (Scanner)this.myContainer.lookup(Scanner.class);
        this.myArtifactContextProducer = (ArtifactContextProducer)this.myContainer.lookup(ArtifactContextProducer.class);
        MavenServerUtil.registerShutdownTask(() -> this.release(MavenServerUtil.getToken()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseIndex(MavenIndexId mavenIndexId, MavenToken token) throws MavenServerIndexerException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            Map<String, IndexingContext> map = this.myContexts;
            synchronized (map) {
                IndexingContext context = this.myContexts.remove(mavenIndexId.indexId);
                if (context != null) {
                    context.close(false);
                }
            }
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    private List<IndexCreator> createIndexers() throws ComponentLookupException {
        ArrayList<IndexCreator> result = new ArrayList<IndexCreator>();
        result.add((IndexCreator)this.myContainer.lookup(IndexCreator.class, "min"));
        result.add((IndexCreator)this.myContainer.lookup(IndexCreator.class, "jarContent"));
        result.add((IndexCreator)new TinyArtifactInfoIndexCreator());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private IndexingContext getIndex(MavenIndexId mavenIndexId) throws IOException, ComponentLookupException {
        Map<String, IndexingContext> map = this.myContexts;
        // MONITORENTER : map
        IndexingContext context = this.myContexts.get(mavenIndexId.indexId);
        if (context != null) {
            IndexingContext indexingContext = context;
            // MONITOREXIT : map
            if (indexingContext != null) return indexingContext;
            MavenIdeaIndexerImpl.$$$reportNull$$$0(0);
            return indexingContext;
        }
        @NotNull String id = mavenIndexId.indexId;
        @NotNull String repositoryId = mavenIndexId.repositoryId;
        @Nullable File repository = mavenIndexId.repositoryFilePath == null ? null : new File(mavenIndexId.repositoryFilePath);
        @NotNull File indexDirectory = new File(mavenIndexId.indexDirPath);
        @Nullable String repositoryUrl = mavenIndexId.url;
        String indexUpdateUrl = null;
        boolean searchable = true;
        boolean reclaim = true;
        context = this.myIndexer.createIndexingContext(id, repositoryId, repository, indexDirectory, repositoryUrl, indexUpdateUrl, searchable, reclaim, this.createIndexers());
        this.myContexts.put(mavenIndexId.indexId, context);
        IndexingContext indexingContext = context;
        // MONITOREXIT : map
        if (indexingContext != null) return indexingContext;
        MavenIdeaIndexerImpl.$$$reportNull$$$0(1);
        return indexingContext;
    }

    public boolean indexExists(Path dir, MavenToken token) throws RemoteException {
        boolean bl;
        block8: {
            MavenServerUtil.checkToken((MavenToken)token);
            FSDirectory directory = FSDirectory.open((Path)dir);
            try {
                bl = DirectoryReader.indexExists((Directory)directory);
                if (directory == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directory != null) {
                        try {
                            directory.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ignore) {
                    return false;
                }
            }
            directory.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexCount(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        Map<String, IndexingContext> map = this.myContexts;
        synchronized (map) {
            return this.myContexts.size();
        }
    }

    public void updateIndex(MavenIndexId mavenIndexId, MavenServerProgressIndicator remoteIndicator, boolean multithreaded, MavenToken token) throws RemoteException, MavenServerIndexerException, MavenServerProcessCanceledException {
        MavenServerUtil.checkToken((MavenToken)token);
        MavenServerSideCancelledThrottler indicator = new MavenServerSideCancelledThrottler(remoteIndicator);
        this.doUpdateIndex(mavenIndexId, multithreaded, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdateIndex(MavenIndexId mavenIndexId, boolean multithreaded, MavenServerProgressIndicator indicator) throws MavenServerProcessCanceledException, MavenServerIndexerException {
        block8: {
            try {
                IndexingContext context = this.getIndex(mavenIndexId);
                boolean readyToUpdate = this.myLocks.add(mavenIndexId.indexId);
                if (!readyToUpdate) break block8;
                try {
                    File repository = context.getRepository();
                    if (repository != null) {
                        this.scanAndUpdateLocalRepositoryIndex(indicator, context, multithreaded);
                    } else {
                        this.downloadRemoteIndex(indicator, context);
                    }
                }
                finally {
                    this.myLocks.remove(mavenIndexId.indexId);
                }
            }
            catch (MavenProcessCanceledRuntimeException e) {
                throw new MavenServerProcessCanceledException();
            }
            catch (Throwable e) {
                throw new MavenServerIndexerException(this.wrapException(e));
            }
        }
    }

    protected void downloadRemoteIndex(MavenServerProgressIndicator indicator, IndexingContext context) throws Throwable {
        Future<?> future = this.myRemoteExecutorService.submit(() -> {
            try {
                Wagon httpWagon = (Wagon)this.myContainer.lookup(Wagon.class, "http");
                WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher(httpWagon, (TransferListener)new WagonTransferListenerAdapter(indicator), null, null);
                Date currentTimestamp = context.getTimestamp();
                IndexUpdateRequest request = new IndexUpdateRequest(context, (ResourceFetcher)resourceFetcher);
                indicator.setText("Updating index for " + context.getRepositoryUrl());
                IndexUpdateResult updateResult = this.myUpdater.fetchAndUpdateIndex(request);
                MavenIdeaIndexerImpl.updateIndicatorStatus(indicator, context, updateResult, currentTimestamp);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        while (!indicator.isCanceled()) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Maven indexing was terminated");
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    protected void scanAndUpdateLocalRepositoryIndex(MavenServerProgressIndicator indicator, IndexingContext context, boolean multithreaded) throws IOException {
        File repositoryDirectory = context.getRepository();
        if (repositoryDirectory == null || !repositoryDirectory.exists()) {
            throw new IOException("Repository directory " + repositoryDirectory + " does not exist");
        }
        indicator.setText("Scanning " + repositoryDirectory.getPath());
        File tmpDir = Files.createTempDirectory(context.getId() + "-tmp", new FileAttribute[0]).toFile();
        DefaultIndexingContext tmpContext = null;
        try {
            tmpContext = new DefaultIndexingContext(context.getId() + "-tmp", context.getRepositoryId(), context.getRepository(), tmpDir, context.getRepositoryUrl(), context.getIndexUpdateUrl(), context.getIndexCreators(), true);
            this.myScanner.scan(new ScanningRequest((IndexingContext)tmpContext, (ArtifactScanningListener)new DefaultScannerListener((IndexingContext)tmpContext, (IndexerEngine)this.myContainer.lookup(IndexerEngine.class), false, (ArtifactScanningListener)new MyScanningListener(indicator)), null));
            indicator.setText("Scanning for " + repositoryDirectory.getPath() + " complete, updating indices");
            tmpContext.updateTimestamp(true);
            context.replace(tmpContext.getIndexDirectory());
            indicator.setText("Indices for " + repositoryDirectory.getPath() + " updated");
        }
        catch (Exception e) {
            throw new IOException("Error scanning context " + context.getId(), e);
        }
        finally {
            if (tmpContext != null) {
                tmpContext.close(true);
            }
            FileUtils.deleteDirectory((File)tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<IndexedMavenId> processArtifacts(MavenIndexId indexId, int startFrom, MavenToken token) throws MavenServerIndexerException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            IndexingContext context;
            int CHUNK_SIZE = 2000;
            IndexingContext indexingContext = context = this.getIndex(indexId);
            synchronized (indexingContext) {
                IndexSearcher searcher = context.acquireIndexSearcher();
                IndexReader r = searcher.getIndexReader();
                int total = r.numDocs();
                ArrayList<IndexedMavenId> result = new ArrayList<IndexedMavenId>(Math.min(2000, total));
                for (int i = startFrom; i < total; ++i) {
                    String[] uInfoParts;
                    Document doc = r.document(i);
                    String uinfo = doc.get(ArtifactInfo.UINFO);
                    if (uinfo == null || (uInfoParts = uinfo.split("\\|")).length < 3) continue;
                    String groupId = uInfoParts[0];
                    String artifactId = uInfoParts[1];
                    String version = uInfoParts[2];
                    String packaging = doc.get(ArtifactInfo.PACKAGING);
                    String description = doc.get(ArtifactInfo.DESCRIPTION);
                    result.add(new IndexedMavenId(groupId, artifactId, version, packaging, description));
                    if (result.size() != 2000) continue;
                    return result;
                }
                if (result.isEmpty()) {
                    return null;
                }
                return result;
            }
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ArrayList<AddArtifactResponse> addArtifacts(@NotNull MavenIndexId indexId, @NotNull ArrayList<Path> artifactFiles, MavenToken token) throws MavenServerIndexerException {
        ArrayList<AddArtifactResponse> arrayList;
        if (indexId == null) {
            MavenIdeaIndexerImpl.$$$reportNull$$$0(2);
        }
        if (artifactFiles == null) {
            MavenIdeaIndexerImpl.$$$reportNull$$$0(3);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            IndexingContext context = this.getIndex(indexId);
            ArrayList<AddArtifactResponse> results = new ArrayList<AddArtifactResponse>();
            IndexingContext indexingContext = context;
            synchronized (indexingContext) {
                for (Path artifactFile : artifactFiles) {
                    ArtifactContext artifactContext = this.myArtifactContextProducer.getArtifactContext(context, artifactFile.toFile());
                    IndexedMavenId id = null;
                    if (artifactContext != null) {
                        this.myIndexer.addArtifactToIndex(artifactContext, context);
                        ArtifactInfo a = artifactContext.getArtifactInfo();
                        id = new IndexedMavenId(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getPackaging(), a.getDescription());
                    }
                    results.add(new AddArtifactResponse(artifactFile.toFile(), id));
                }
            }
            arrayList = results;
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
        if (arrayList == null) {
            MavenIdeaIndexerImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public HashSet<MavenArtifactInfo> search(MavenIndexId indexId, String pattern, int maxResult, MavenToken token) throws MavenServerIndexerException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            IndexingContext context = this.getIndex(indexId);
            BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
            MatchAllDocsQuery query = StringUtils.isEmpty((CharSequence)pattern) ? new MatchAllDocsQuery() : MavenIdeaIndexerImpl.getWildcardQuery(pattern);
            IndexSearcher searcher = context.acquireIndexSearcher();
            TopDocs docs = searcher.search((Query)query, maxResult);
            if (docs == null || docs.scoreDocs.length == 0) {
                return new HashSet<MavenArtifactInfo>();
            }
            HashSet<MavenArtifactInfo> result = new HashSet<MavenArtifactInfo>();
            for (int i = 0; i < docs.scoreDocs.length; ++i) {
                int docIndex = docs.scoreDocs[i].doc;
                Document doc = searcher.getIndexReader().document(docIndex);
                ArtifactInfo a = IndexUtils.constructArtifactInfo((Document)doc, (IndexingContext)context);
                if (a == null) continue;
                a.setRepository(MavenIdeaIndexerImpl.getRepositoryPathOrUrl(context));
                result.add(new MavenArtifactInfo(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getPackaging(), a.getClassifier(), a.getClassNames(), a.getRepository()));
            }
            return result;
        }
        catch (Exception e) {
            throw new MavenServerIndexerException(this.wrapException(e));
        }
    }

    public HashSet<MavenArchetype> getInternalArchetypes(MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            return this.getInternalArchetypes();
        }
        catch (ComponentLookupException e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    private HashSet<MavenArchetype> getInternalArchetypes() throws RemoteException, ComponentLookupException {
        HashSet<MavenArchetype> result = new HashSet<MavenArchetype>();
        ArchetypeManager manager = (ArchetypeManager)this.myContainer.lookup(ArchetypeManager.class);
        ArchetypeCatalog internalCatalog = manager.getInternalCatalog();
        for (Archetype archetype : internalCatalog.getArchetypes()) {
            result.add(new MavenArchetype(archetype.getGroupId(), archetype.getArtifactId(), archetype.getVersion(), archetype.getRepository(), archetype.getDescription()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            Map<String, IndexingContext> map = this.myContexts;
            synchronized (map) {
                for (IndexingContext indexingContext : this.myContexts.values()) {
                    indexingContext.close(false);
                }
                this.myContexts.clear();
            }
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    private static String getRepositoryPathOrUrl(IndexingContext index) {
        File file = index.getRepository();
        return file == null ? index.getRepositoryUrl() : file.getPath();
    }

    private static void updateIndicatorStatus(MavenServerProgressIndicator indicator, IndexingContext context, IndexUpdateResult updateResult, Date currentTimestamp) throws RemoteException {
        if (updateResult.isFullUpdate()) {
            indicator.setText("Index for " + context.getRepositoryUrl() + " updated");
        } else if (updateResult.getTimestamp() != null && currentTimestamp != null && updateResult.getTimestamp().equals(currentTimestamp)) {
            indicator.setText("Index for " + context.getRepositoryUrl() + "is up to date!");
        } else {
            indicator.setText("Index for " + context.getRepositoryUrl() + " incrementally updated");
        }
    }

    @NotNull
    private static WildcardQuery getWildcardQuery(String pattern) {
        return new WildcardQuery(new Term("c", "*/" + pattern.replaceAll("\\.", "/")));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/indexer/MavenIdeaIndexerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/indexer/MavenIdeaIndexerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyScanningListener
    implements ArtifactScanningListener {
        private final MavenServerProgressIndicator p;
        private AtomicInteger scanned = new AtomicInteger();

        MyScanningListener(MavenServerProgressIndicator indicator) {
            this.p = indicator;
        }

        public void scanningStarted(IndexingContext ctx) {
            try {
                if (this.p.isCanceled()) {
                    throw new MavenProcessCanceledRuntimeException();
                }
                this.p.setText("Maven Indexing Started");
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void scanningFinished(IndexingContext ctx, ScanningResult result) {
            try {
                if (this.p.isCanceled()) {
                    throw new MavenProcessCanceledRuntimeException();
                }
                this.p.setText("Maven Indexing Finished: " + result.getTotalFiles() + " was scanned");
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        public void artifactError(ArtifactContext ac, Exception e) {
        }

        public void artifactDiscovered(ArtifactContext ac) {
            try {
                if (this.p.isCanceled()) {
                    throw new MavenProcessCanceledRuntimeException();
                }
                if (this.scanned.incrementAndGet() % 100 == 0) {
                    this.p.setText("Scanned " + this.scanned.get() + " artifacts...");
                }
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

