/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J*\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J*\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000fJ\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J8\u0010 \u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00152\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00170\"H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/resolve/FunctionsFromAny;", "", "<init>", "()V", "EQUALS_METHOD_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getEQUALS_METHOD_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "HASH_CODE_METHOD_NAME", "getHASH_CODE_METHOD_NAME", "TO_STRING_METHOD_NAME", "getTO_STRING_METHOD_NAME", "addFunctionFromAnyIfNeeded", "", "thisDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "result", "", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "name", "fromSupertypes", "", "shouldAddEquals", "", "declaredFunctions", "shouldAddHashCode", "shouldAddToString", "createEqualsFunctionDescriptor", "classDescriptor", "createHashCodeFunctionDescriptor", "createToStringFunctionDescriptor", "doCreateFunctionFromAny", "shouldAddFunctionFromAny", "checkParameters", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend"})
@SourceDebugExtension(value={"SMAP\nFunctionsFromAny.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionsFromAny.kt\norg/jetbrains/kotlin/resolve/FunctionsFromAny\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1563#2:123\n1634#2,3:124\n2746#2,3:127\n2746#2,3:130\n*S KotlinDebug\n*F\n+ 1 FunctionsFromAny.kt\norg/jetbrains/kotlin/resolve/FunctionsFromAny\n*L\n103#1:123\n103#1:124,3\n118#1:127,3\n119#1:130,3\n*E\n"})
public final class FunctionsFromAny {
    @NotNull
    public static final FunctionsFromAny INSTANCE = new FunctionsFromAny();
    @NotNull
    private static final Name EQUALS_METHOD_NAME = OperatorNameConventions.EQUALS;
    @NotNull
    private static final Name HASH_CODE_METHOD_NAME = OperatorNameConventions.HASH_CODE;
    @NotNull
    private static final Name TO_STRING_METHOD_NAME = OperatorNameConventions.TO_STRING;

    private FunctionsFromAny() {
    }

    @NotNull
    public final Name getEQUALS_METHOD_NAME() {
        return EQUALS_METHOD_NAME;
    }

    @NotNull
    public final Name getHASH_CODE_METHOD_NAME() {
        return HASH_CODE_METHOD_NAME;
    }

    @NotNull
    public final Name getTO_STRING_METHOD_NAME() {
        return TO_STRING_METHOD_NAME;
    }

    public final void addFunctionFromAnyIfNeeded(@NotNull ClassDescriptor thisDescriptor, @NotNull Collection<SimpleFunctionDescriptor> result2, @NotNull Name name2, @NotNull Collection<? extends SimpleFunctionDescriptor> fromSupertypes) {
        Intrinsics.checkNotNullParameter(thisDescriptor, "thisDescriptor");
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(fromSupertypes, "fromSupertypes");
        if (this.shouldAddEquals(name2, result2, fromSupertypes)) {
            result2.add(this.createEqualsFunctionDescriptor(thisDescriptor));
        }
        if (this.shouldAddHashCode(name2, result2, fromSupertypes)) {
            result2.add(this.createHashCodeFunctionDescriptor(thisDescriptor));
        }
        if (this.shouldAddToString(name2, result2, fromSupertypes)) {
            result2.add(this.createToStringFunctionDescriptor(thisDescriptor));
        }
    }

    public final boolean shouldAddEquals(@NotNull Name name2, @NotNull Collection<? extends SimpleFunctionDescriptor> declaredFunctions, @NotNull Collection<? extends SimpleFunctionDescriptor> fromSupertypes) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(declaredFunctions, "declaredFunctions");
        Intrinsics.checkNotNullParameter(fromSupertypes, "fromSupertypes");
        return Intrinsics.areEqual(name2, EQUALS_METHOD_NAME) && this.shouldAddFunctionFromAny(declaredFunctions, fromSupertypes, FunctionsFromAny::shouldAddEquals$lambda$0);
    }

    public final boolean shouldAddHashCode(@NotNull Name name2, @NotNull Collection<? extends SimpleFunctionDescriptor> declaredFunctions, @NotNull Collection<? extends SimpleFunctionDescriptor> fromSupertypes) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(declaredFunctions, "declaredFunctions");
        Intrinsics.checkNotNullParameter(fromSupertypes, "fromSupertypes");
        return Intrinsics.areEqual(name2, HASH_CODE_METHOD_NAME) && this.shouldAddFunctionFromAny(declaredFunctions, fromSupertypes, FunctionsFromAny::shouldAddHashCode$lambda$1);
    }

    public final boolean shouldAddToString(@NotNull Name name2, @NotNull Collection<? extends SimpleFunctionDescriptor> declaredFunctions, @NotNull Collection<? extends SimpleFunctionDescriptor> fromSupertypes) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(declaredFunctions, "declaredFunctions");
        Intrinsics.checkNotNullParameter(fromSupertypes, "fromSupertypes");
        return Intrinsics.areEqual(name2, TO_STRING_METHOD_NAME) && this.shouldAddFunctionFromAny(declaredFunctions, fromSupertypes, FunctionsFromAny::shouldAddToString$lambda$2);
    }

    @NotNull
    public final SimpleFunctionDescriptor createEqualsFunctionDescriptor(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        return this.doCreateFunctionFromAny(classDescriptor, EQUALS_METHOD_NAME);
    }

    @NotNull
    public final SimpleFunctionDescriptor createHashCodeFunctionDescriptor(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        return this.doCreateFunctionFromAny(classDescriptor, HASH_CODE_METHOD_NAME);
    }

    @NotNull
    public final SimpleFunctionDescriptor createToStringFunctionDescriptor(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        return this.doCreateFunctionFromAny(classDescriptor, TO_STRING_METHOD_NAME);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleFunctionDescriptor doCreateFunctionFromAny(ClassDescriptor classDescriptor, Name name2) {
        Collection<ValueParameterDescriptor> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create(classDescriptor, Annotations.Companion.getEMPTY(), name2, CallableMemberDescriptor.Kind.SYNTHESIZED, classDescriptor.getSource());
        Intrinsics.checkNotNullExpressionValue(simpleFunctionDescriptorImpl, "create(...)");
        SimpleFunctionDescriptorImpl functionDescriptor = simpleFunctionDescriptorImpl;
        SimpleFunctionDescriptor functionFromAny = (SimpleFunctionDescriptor)CollectionsKt.single((Iterable)DescriptorUtilsKt.getBuiltIns(classDescriptor).getAny().getMemberScope(CollectionsKt.emptyList()).getContributedFunctions(name2, NoLookupLocation.FROM_BUILTINS));
        ReceiverParameterDescriptor receiverParameterDescriptor = classDescriptor.getThisAsReceiverParameter();
        List list = CollectionsKt.emptyList();
        List<TypeParameterDescriptor> list2 = functionFromAny.getTypeParameters();
        List<ValueParameterDescriptor> list3 = functionFromAny.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list3, "getValueParameters(...)");
        Iterable iterable = list3;
        List<TypeParameterDescriptor> list4 = list2;
        List list5 = list;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        ReceiverParameterDescriptor receiverParameterDescriptor3 = null;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl2 = functionDescriptor;
        boolean $i$f$map = false;
        void var7_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CallableDescriptor callableDescriptor = functionDescriptor;
            Name name3 = it.getName();
            Intrinsics.checkNotNullExpressionValue(name3, "getName(...)");
            collection.add(it.copy(callableDescriptor, name3, it.getIndex()));
        }
        collection = (List)destination$iv$iv;
        simpleFunctionDescriptorImpl2.initialize(receiverParameterDescriptor3, receiverParameterDescriptor2, list5, list4, (List)collection, functionFromAny.getReturnType(), Modality.OPEN, DescriptorVisibilities.PUBLIC);
        return functionDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldAddFunctionFromAny(Collection<? extends SimpleFunctionDescriptor> declaredFunctions, Collection<? extends SimpleFunctionDescriptor> fromSupertypes, Function1<? super FunctionDescriptor, Boolean> checkParameters) {
        boolean bl;
        boolean bl2;
        Iterable $this$none$iv = declaredFunctions;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $this$none$iv) {
                if (!checkParameters.invoke((FunctionDescriptor)element$iv).booleanValue()) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        $this$none$iv = fromSupertypes;
        $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv;
            boolean bl3 = false;
            if (checkParameters.invoke(it).booleanValue() && it.getModality() == Modality.FINAL) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private static final boolean shouldAddEquals$lambda$0(FunctionDescriptor function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        List<ValueParameterDescriptor> list = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        List<ValueParameterDescriptor> parameters = list;
        return parameters.size() == 1 && KotlinBuiltIns.isNullableAny(CollectionsKt.first(parameters).getType());
    }

    private static final boolean shouldAddHashCode$lambda$1(FunctionDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getValueParameters().isEmpty();
    }

    private static final boolean shouldAddToString$lambda$2(FunctionDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getValueParameters().isEmpty();
    }
}

