/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.parsers;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.LogMessageType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLoggedEventParser;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;

public abstract class MessageNotifier
implements MavenLoggedEventParser {
    @NotNull
    private final LogMessageType myType;
    @NotNull
    private final MessageEvent.Kind myKind;
    @NotNull
    private final @BuildEventsNls.Title String myGroup;
    private final Set<String> myMessages;

    protected MessageNotifier(@NotNull LogMessageType type, @NotNull MessageEvent.Kind kind, @NotNull @BuildEventsNls.Title String group) {
        if (type == null) {
            MessageNotifier.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            MessageNotifier.$$$reportNull$$$0(1);
        }
        if (group == null) {
            MessageNotifier.$$$reportNull$$$0(2);
        }
        this.myMessages = new HashSet<String>();
        this.myType = type;
        this.myKind = kind;
        this.myGroup = group;
    }

    @Override
    public boolean supportsType(@Nullable LogMessageType type) {
        return type == this.myType;
    }

    @Override
    public boolean checkLogLine(@NotNull Object parendId, @NotNull MavenParsingContext parsingContext, @NotNull MavenLogEntryReader.MavenLogEntry logLine, @NotNull MavenLogEntryReader logEntryReader, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        if (parendId == null) {
            MessageNotifier.$$$reportNull$$$0(3);
        }
        if (parsingContext == null) {
            MessageNotifier.$$$reportNull$$$0(4);
        }
        if (logLine == null) {
            MessageNotifier.$$$reportNull$$$0(5);
        }
        if (logEntryReader == null) {
            MessageNotifier.$$$reportNull$$$0(6);
        }
        if (messageConsumer == null) {
            MessageNotifier.$$$reportNull$$$0(7);
        }
        String line = logLine.getLine();
        List<MavenLogEntryReader.MavenLogEntry> toConcat = logEntryReader.readWhile(l -> l.getType() == this.myType);
        String contatenated = line + "\n" + StringUtil.join(toConcat, MavenLogEntryReader.MavenLogEntry::getLine, (String)"\n");
        String message = this.getMessage(line, toConcat);
        if (!StringUtil.isEmptyOrSpaces((String)message) && this.myMessages.add(message)) {
            messageConsumer.accept((BuildEvent)new MessageEventImpl(parendId, this.myKind, this.myGroup, message, contatenated));
            return true;
        }
        return false;
    }

    @NotNull
    @NlsSafe
    protected String getMessage(String line, List<MavenLogEntryReader.MavenLogEntry> toConcat) {
        if (toConcat == null || toConcat.isEmpty()) {
            String string = line;
            if (string == null) {
                MessageNotifier.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (!StringUtil.isEmptyOrSpaces((String)line)) {
            String string = line;
            if (string == null) {
                MessageNotifier.$$$reportNull$$$0(9);
            }
            return string;
        }
        MavenLogEntryReader.MavenLogEntry entry = (MavenLogEntryReader.MavenLogEntry)ContainerUtil.find(toConcat, e -> !StringUtil.isEmptyOrSpaces((String)e.getLine()));
        if (entry != null) {
            String string = entry.getLine();
            if (string == null) {
                MessageNotifier.$$$reportNull$$$0(10);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parendId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsingContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logLine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logEntryReader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MessageNotifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/MessageNotifier";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkLogLine";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

