/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.references.MavenPathReferenceConverter;

@Service(value={Service.Level.APP})
public final class MavenDomConvertersRegistry {
    private GenericDomValueConvertersRegistry myConvertersRegistry;
    private final Set<String> mySoftConverterTypes = Set.of(File.class.getCanonicalName());

    public static MavenDomConvertersRegistry getInstance() {
        return (MavenDomConvertersRegistry)ApplicationManager.getApplication().getService(MavenDomConvertersRegistry.class);
    }

    public MavenDomConvertersRegistry() {
        this.myConvertersRegistry = new GenericDomValueConvertersRegistry();
        this.initConverters();
    }

    private void initConverters() {
        this.myConvertersRegistry.registerDefaultConverters();
        this.myConvertersRegistry.registerConverter((Converter)new MavenPathReferenceConverter(), File.class);
    }

    public GenericDomValueConvertersRegistry getConvertersRegistry() {
        return this.myConvertersRegistry;
    }

    public boolean isSoft(@NotNull String type) {
        if (type == null) {
            MavenDomConvertersRegistry.$$$reportNull$$$0(0);
        }
        return this.mySoftConverterTypes.contains(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/maven/dom/converters/MavenDomConvertersRegistry", "isSoft"));
    }
}

