/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public final class MavenSchemaProvider
implements StandardResourceProvider {
    public static final String MAVEN_PROJECT_SCHEMA_4_0_URL = "http://maven.apache.org/xsd/maven-4.0.0.xsd";
    public static final String MAVEN_PROJECT_SCHEMA_4_1_URL = "https://maven.apache.org/xsd/maven-4.1.0.xsd";
    public static final String MAVEN_PROFILES_SCHEMA_URL = "http://maven.apache.org/xsd/profiles-1.0.0.xsd";
    public static final String MAVEN_SETTINGS_SCHEMA_URL = "http://maven.apache.org/xsd/settings-1.0.0.xsd";
    public static final String MAVEN_SETTINGS_SCHEMA_URL_1_1 = "http://maven.apache.org/xsd/settings-1.1.0.xsd";
    public static final String MAVEN_SETTINGS_SCHEMA_URL_1_2 = "http://maven.apache.org/xsd/settings-1.2.0.xsd";

    public void registerResources(ResourceRegistrar registrar) {
        String[] urls = new String[]{MAVEN_PROJECT_SCHEMA_4_0_URL, "schemas/maven-4.0.0.xsd", MAVEN_PROJECT_SCHEMA_4_1_URL, "schemas/maven-4.1.0.xsd", "http://maven.apache.org/maven-v4_0_0.xsd", "schemas/maven-4.0.0.xsd", MAVEN_PROFILES_SCHEMA_URL, "schemas/profiles-1.0.0.xsd", MAVEN_SETTINGS_SCHEMA_URL, "schemas/settings-1.0.0.xsd", MAVEN_SETTINGS_SCHEMA_URL_1_1, "schemas/settings-1.1.0.xsd", MAVEN_SETTINGS_SCHEMA_URL_1_2, "schemas/settings-1.2.0.xsd"};
        for (int i2 = 0; i2 < urls.length; i2 += 2) {
            this.addStdResource(registrar, urls[i2], urls[i2 + 1]);
        }
    }

    private void addStdResource(ResourceRegistrar registrar, String schemaUrl, String schemaPath) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        registrar.addStdResource(schemaUrl, schemaPath, classLoader);
        if (schemaUrl.startsWith("http://")) {
            registrar.addStdResource(schemaUrl.replace("http://", "https://"), schemaPath, classLoader);
        }
    }

    @NotNull
    public static VirtualFile getSchemaFile(@NotNull String url) {
        if (url == null) {
            MavenSchemaProvider.$$$reportNull$$$0(0);
        }
        String location = ((ExternalResourceManagerEx)ExternalResourceManager.getInstance()).getStdResource(url, null);
        assert (location != null) : "cannot find a standard resource for " + url;
        VirtualFile result2 = VfsUtilCore.findRelativeFile((String)location, null);
        assert (result2 != null) : "cannot find a schema file for URL: " + url + " location: " + location;
        VirtualFile virtualFile = result2;
        if (virtualFile == null) {
            MavenSchemaProvider.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/MavenSchemaProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/MavenSchemaProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFile";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

