/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.ClassAwareSuiteMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

class IdeaSuite
extends Suite {
    private final String myName;

    IdeaSuite(List<Runner> runners, String name) throws InitializationError {
        super(null, runners);
        this.myName = name;
    }

    IdeaSuite(RunnerBuilder builder, Class<?>[] classes, String name) throws InitializationError {
        super(builder, (Class[])classes);
        this.myName = name;
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((String)this.myName, (Annotation[])this.getTestClass().getAnnotations());
        try {
            Method getFilteredChildrenMethod = ParentRunner.class.getDeclaredMethod("getFilteredChildren", new Class[0]);
            getFilteredChildrenMethod.setAccessible(true);
            Collection filteredChildren = (Collection)getFilteredChildrenMethod.invoke((Object)this, new Object[0]);
            for (Object child : filteredChildren) {
                description.addChild(this.describeChild((Runner)child));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return description;
    }

    protected Description describeChild(Runner child) {
        Description superDescription = super.describeChild(child);
        if (child instanceof ClassAwareSuiteMethod) {
            Description description = Description.createSuiteDescription(((ClassAwareSuiteMethod)child).getKlass());
            ArrayList children = superDescription.getChildren();
            for (Description desc : children) {
                description.addChild(desc);
            }
            return description;
        }
        return superDescription;
    }

    protected List<Runner> getChildren() {
        ArrayList<Runner> children = new ArrayList<Runner>(super.getChildren());
        boolean containsSuiteInside = false;
        for (Runner runner : children) {
            if (!IdeaSuite.isSuite(runner)) continue;
            containsSuiteInside = true;
            break;
        }
        if (!containsSuiteInside) {
            return children;
        }
        try {
            HashSet<String> allNames = new HashSet<String>();
            for (Runner child : children) {
                allNames.add(this.describeChild(child).getDisplayName());
            }
            for (Runner child : children) {
                if (!IdeaSuite.isSuite(child)) continue;
                this.skipSuiteComponents(allNames, child);
            }
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                Runner child;
                child = (Runner)iterator.next();
                if (IdeaSuite.isSuite(child) || allNames.contains(this.describeChild(child).getDisplayName())) continue;
                iterator.remove();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return children;
    }

    private static boolean isSuite(Object child) {
        return child instanceof Suite && !(child instanceof Parameterized) || child instanceof SuiteMethod;
    }

    private void skipSuiteComponents(Set<String> allNames, Object child) {
        try {
            if (child instanceof Suite) {
                Method getChildrenMethod = Suite.class.getDeclaredMethod("getChildren", new Class[0]);
                getChildrenMethod.setAccessible(true);
                List tests = (List)getChildrenMethod.invoke(child, new Object[0]);
                for (Object test : tests) {
                    String displayName = this.describeChild((Runner)test).getDisplayName();
                    allNames.remove(displayName);
                }
            } else if (child instanceof SuiteMethod) {
                Method getChildrenMethod = JUnit38ClassRunner.class.getDeclaredMethod("getTest", new Class[0]);
                getChildrenMethod.setAccessible(true);
                Test test = (Test)getChildrenMethod.invoke(child, new Object[0]);
                if (test instanceof TestSuite) {
                    Enumeration tests = ((TestSuite)test).tests();
                    while (tests.hasMoreElements()) {
                        Test t = (Test)tests.nextElement();
                        if (!(t instanceof TestSuite)) continue;
                        String testDescription = ((TestSuite)t).getName();
                        allNames.remove(testDescription);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

