/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.BuildTargetStateManager;
import org.jetbrains.jps.incremental.storage.BuildTargetStateManagerImplKt;
import org.jetbrains.jps.incremental.storage.BuildTargetTypeState;
import org.jetbrains.jps.model.JpsModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J&\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00150\u001f0\u001e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u001c\u0010\"\u001a\u00020\u00132\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010#\u001a\u00020 H\u0016J\u001c\u0010$\u001a\u00020\u00132\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0014\u0010&\u001a\u00020\u000b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u001c\u0010'\u001a\u00020\u00132\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010(\u001a\u00020)H\u0016J\u001c\u0010*\u001a\u00020+2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010,\u001a\u00020-H\u0016J\u0014\u0010.\u001a\u00020\u00132\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0014\u0010/\u001a\u00020\u000f2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u000e\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0015J\u0006\u00102\u001a\u00020\u0015J\b\u00103\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/jps/incremental/storage/BuildTargetStateManagerImpl;", "Lorg/jetbrains/jps/incremental/storage/BuildTargetStateManager;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "model", "Lorg/jetbrains/jps/model/JpsModel;", "<init>", "(Lorg/jetbrains/jps/builders/storage/BuildDataPaths;Lorg/jetbrains/jps/model/JpsModel;)V", "maxTargetId", "Ljava/util/concurrent/atomic/AtomicInteger;", "lastSuccessfulRebuildDuration", "", "typeToState", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/jps/builders/BuildTargetType;", "Lorg/jetbrains/jps/incremental/storage/BuildTargetTypeState;", "getTargetTypesFile", "Ljava/nio/file/Path;", "save", "", "getBuildTargetId", "", "target", "Lorg/jetbrains/jps/builders/BuildTarget;", "getLastSuccessfulRebuildDuration", "setLastSuccessfulRebuildDuration", "duration", "getTargetConfiguration", "Lorg/jetbrains/jps/incremental/storage/BuildTargetConfiguration;", "getStaleTargetIds", "", "Lcom/intellij/openapi/util/Pair;", "", "type", "cleanStaleTarget", "targetId", "setAverageBuildTime", "time", "getAverageBuildTime", "storeNonExistentOutputRoots", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "isTargetDirty", "", "projectDescriptor", "Lorg/jetbrains/jps/cmdline/ProjectDescriptor;", "invalidate", "getTypeState", "markUsedId", "id", "getFreeId", "clean", "intellij.platform.jps.build"})
public final class BuildTargetStateManagerImpl
implements BuildTargetStateManager {
    @NotNull
    private final BuildDataPaths dataPaths;
    @NotNull
    private final JpsModel model;
    @NotNull
    private final AtomicInteger maxTargetId;
    private long lastSuccessfulRebuildDuration;
    @NotNull
    private final ConcurrentHashMap<BuildTargetType<?>, BuildTargetTypeState> typeToState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildTargetStateManagerImpl(@NotNull BuildDataPaths dataPaths, @NotNull JpsModel model) {
        Intrinsics.checkNotNullParameter((Object)dataPaths, (String)"dataPaths");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.dataPaths = dataPaths;
        this.model = model;
        this.maxTargetId = new AtomicInteger(0);
        this.lastSuccessfulRebuildDuration = -1L;
        this.typeToState = new ConcurrentHashMap();
        Path targetTypeListFile = this.getTargetTypesFile();
        try {
            Closeable closeable = new DataInputStream(new BufferedInputStream(Files.newInputStream(targetTypeListFile, new OpenOption[0])));
            Throwable throwable = null;
            try {
                DataInputStream input = (DataInputStream)closeable;
                boolean bl = false;
                this.maxTargetId.set(input.readInt());
                this.lastSuccessfulRebuildDuration = input.readLong();
                input = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            BuildTargetStateManagerImplKt.access$getLOG$p().debug("Cannot load " + targetTypeListFile + ":" + e.getMessage(), (Throwable)e);
            BuildTargetStateManagerImplKt.access$getLOG$p().debug("Loading all target types to calculate max target id");
            for (BuildTargetType<?> type : TargetTypeRegistry.getInstance().getTargetTypes()) {
                Intrinsics.checkNotNull(type);
                this.getTypeState(type);
            }
        }
    }

    private final Path getTargetTypesFile() {
        Path path = this.dataPaths.getTargetsDataRoot().resolve("targetTypes.dat");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        try {
            Path targetTypeListFile = this.getTargetTypesFile();
            Files.createDirectories(targetTypeListFile.getParent(), new FileAttribute[0]);
            Closeable closeable = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(targetTypeListFile, new OpenOption[0])));
            Throwable throwable = null;
            try {
                DataOutputStream output = (DataOutputStream)closeable;
                boolean bl = false;
                output.writeInt(this.maxTargetId.get());
                output.writeLong(this.lastSuccessfulRebuildDuration);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            BuildTargetStateManagerImplKt.access$getLOG$p().info("Cannot save targets info: " + e.getMessage(), (Throwable)e);
        }
        Iterator<BuildTargetTypeState> iterator = this.typeToState.values().iterator();
        while (iterator.hasNext()) {
            BuildTargetTypeState state;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            state.save();
        }
    }

    @Override
    public int getBuildTargetId(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        BuildTargetType<BuildTarget<?>> buildTargetType = target.getTargetType();
        Intrinsics.checkNotNullExpressionValue(buildTargetType, (String)"getTargetType(...)");
        return this.getTypeState(buildTargetType).getTargetId(target);
    }

    @Override
    public long getLastSuccessfulRebuildDuration() {
        return this.lastSuccessfulRebuildDuration;
    }

    @Override
    public void setLastSuccessfulRebuildDuration(long duration) {
        this.lastSuccessfulRebuildDuration = duration;
    }

    @Override
    @NotNull
    public BuildTargetConfiguration getTargetConfiguration(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        BuildTargetType<BuildTarget<?>> buildTargetType = target.getTargetType();
        Intrinsics.checkNotNullExpressionValue(buildTargetType, (String)"getTargetType(...)");
        BuildTargetConfiguration buildTargetConfiguration = this.getTypeState(buildTargetType).getConfiguration(target, this.dataPaths);
        Intrinsics.checkNotNullExpressionValue((Object)buildTargetConfiguration, (String)"getConfiguration(...)");
        return buildTargetConfiguration;
    }

    @Override
    @NotNull
    public List<Pair<String, Integer>> getStaleTargetIds(@NotNull BuildTargetType<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        List<Pair<String, Integer>> list = this.getTypeState(type).getStaleTargetIds();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStaleTargetIds(...)");
        return list;
    }

    @Override
    public void cleanStaleTarget(@NotNull BuildTargetType<?> type, @NotNull String targetId) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        this.getTypeState(type).removeStaleTarget(targetId);
    }

    @Override
    public void setAverageBuildTime(@NotNull BuildTargetType<?> type, long time) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.getTypeState(type).setAverageTargetBuildTime(time);
    }

    @Override
    public long getAverageBuildTime(@NotNull BuildTargetType<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.getTypeState(type).getAverageTargetBuildTime();
    }

    @Override
    public void storeNonExistentOutputRoots(@NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.getTargetConfiguration(target).storeNonExistentOutputRoots(context);
    }

    @Override
    public boolean isTargetDirty(@NotNull BuildTarget<?> target, @NotNull ProjectDescriptor projectDescriptor) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)projectDescriptor, (String)"projectDescriptor");
        return this.getTargetConfiguration(target).isTargetDirty(projectDescriptor);
    }

    @Override
    public void invalidate(@NotNull BuildTarget<?> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        this.getTargetConfiguration(target).invalidate();
    }

    private final BuildTargetTypeState getTypeState(BuildTargetType<?> type) {
        BuildTargetTypeState buildTargetTypeState = this.typeToState.computeIfAbsent(type, arg_0 -> BuildTargetStateManagerImpl.getTypeState$lambda$3(arg_0 -> BuildTargetStateManagerImpl.getTypeState$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)buildTargetTypeState, (String)"computeIfAbsent(...)");
        return buildTargetTypeState;
    }

    public final void markUsedId(int id) {
        int current = 0;
        int max = 0;
        while (!this.maxTargetId.compareAndSet(current = this.maxTargetId.get(), max = Math.max(id, current))) {
        }
    }

    public final int getFreeId() {
        return this.maxTargetId.incrementAndGet();
    }

    @Override
    public void clean() {
        try {
            FileUtilRt.deleteRecursively((Path)this.dataPaths.getTargetsDataRoot());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final BuildTargetTypeState getTypeState$lambda$2(BuildTargetStateManagerImpl this$0, BuildTargetType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new BuildTargetTypeState(it, this$0, this$0.dataPaths, this$0.model);
    }

    private static final BuildTargetTypeState getTypeState$lambda$3(Function1 $tmp0, Object p0) {
        return (BuildTargetTypeState)$tmp0.invoke(p0);
    }
}

