/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class CopyResourcesUtil {
    private CopyResourcesUtil() {
    }

    public static File copyClass(String targetPath, @NonNls String className, boolean deleteOnExit) throws IOException {
        String resourceName;
        InputStream stream;
        File targetDir = new File(targetPath).getAbsoluteFile();
        File file = new File(targetDir, className + ".class");
        FileUtil.createParentDirs((File)file);
        if (deleteOnExit) {
            File f = file;
            while (f != null && !FileUtil.filesEqual((File)f, (File)targetDir)) {
                f.deleteOnExit();
                f = FileUtilRt.getParentFile((File)f);
            }
        }
        if ((stream = CopyResourcesUtil.class.getResourceAsStream(resourceName = "/" + className + ".class")) == null) {
            throw new IOException("cannot load " + resourceName);
        }
        return CopyResourcesUtil.copyStreamToFile(stream, file);
    }

    private static File copyStreamToFile(InputStream stream, File file) throws IOException {
        try (InputStream inputStream = stream;
             FileOutputStream outputStream = new FileOutputStream(file);){
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        return file;
    }

    public static void copyProperties(String targetPath, String fileName) throws IOException {
        File targetDir = new File(targetPath).getAbsoluteFile();
        File file = new File(targetDir, fileName);
        FileUtil.createParentDirs((File)file);
        File f = file;
        while (f != null && !FileUtil.filesEqual((File)f, (File)targetDir)) {
            f.deleteOnExit();
            f = FileUtilRt.getParentFile((File)f);
        }
        String resourceName = "/" + fileName;
        InputStream stream = CopyResourcesUtil.class.getResourceAsStream(resourceName);
        if (stream == null) {
            return;
        }
        CopyResourcesUtil.copyStreamToFile(stream, file);
    }

    @NotNull
    public static @Unmodifiable List<File> copyFormsRuntime(String targetDir, boolean deleteOnExit) throws IOException {
        String[] runtimeClasses = new String[]{"AbstractLayout", "DimensionInfo", "GridConstraints", "GridLayoutManager", "HorizontalInfo", "LayoutState", "Spacer", "SupportCode$TextWithMnemonic", "SupportCode", "Util", "VerticalInfo"};
        ArrayList<File> copied = new ArrayList<File>();
        for (String runtimeClass : runtimeClasses) {
            copied.add(CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/" + runtimeClass, deleteOnExit));
        }
        ArrayList<File> arrayList = copied;
        if (arrayList == null) {
            CopyResourcesUtil.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/java/CopyResourcesUtil", "copyFormsRuntime"));
    }
}

