/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.artifacts.JarPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilder;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.FilterCopyHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.JarBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;

@ApiStatus.Internal
public abstract class ArtifactCompilerInstructionCreatorBase
implements ArtifactCompilerInstructionCreator {
    protected final ArtifactInstructionsBuilderImpl myInstructionsBuilder;

    public ArtifactCompilerInstructionCreatorBase(ArtifactInstructionsBuilderImpl instructionsBuilder) {
        this.myInstructionsBuilder = instructionsBuilder;
    }

    @Override
    public void addDirectoryCopyInstructions(@NotNull File directoryUrl) {
        if (directoryUrl == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(0);
        }
        this.addDirectoryCopyInstructions(directoryUrl, null);
    }

    @Override
    public void addDirectoryCopyInstructions(@NotNull File directory, @Nullable SourceFileFilter filter) {
        if (directory == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(1);
        }
        this.addDirectoryCopyInstructions(directory, filter, FilterCopyHandler.DEFAULT);
    }

    @Override
    public void addDirectoryCopyInstructions(@NotNull File directory, @Nullable SourceFileFilter filter, @NotNull FileCopyingHandler copyingHandler) {
        FileBasedArtifactRootDescriptor descriptor;
        if (directory == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(2);
        }
        if (copyingHandler == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(3);
        }
        boolean copyExcluded = this.myInstructionsBuilder.getRootsIndex().isExcluded(directory);
        SourceFileFilterImpl fileFilter = new SourceFileFilterImpl(filter, this.myInstructionsBuilder.getRootsIndex(), this.myInstructionsBuilder.getIgnoredFileIndex(), copyExcluded);
        DestinationInfo destination = this.createDirectoryDestination();
        if (destination != null && this.myInstructionsBuilder.addDestination(descriptor = this.myInstructionsBuilder.createFileBasedRoot(directory, fileFilter, destination, copyingHandler))) {
            this.onAdded(descriptor);
        }
    }

    @Override
    public void addExtractDirectoryInstruction(@NotNull File jarFile, @NotNull String pathInJar) {
        if (jarFile == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(4);
        }
        if (pathInJar == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(5);
        }
        this.addExtractDirectoryInstruction(jarFile, pathInJar, (Condition<? super String>)Conditions.alwaysTrue());
    }

    @Override
    public void addExtractDirectoryInstruction(@NotNull File jarFile, @NotNull String pathInJar, @NotNull Condition<? super String> pathInJarFilter) {
        JarBasedArtifactRootDescriptor descriptor;
        if (jarFile == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(6);
        }
        if (pathInJar == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(7);
        }
        if (pathInJarFilter == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(8);
        }
        SourceFileFilterImpl filter = new SourceFileFilterImpl(null, this.myInstructionsBuilder.getRootsIndex(), this.myInstructionsBuilder.getIgnoredFileIndex(), true);
        DestinationInfo destination = this.createDirectoryDestination();
        if (destination != null && this.myInstructionsBuilder.addDestination(descriptor = this.myInstructionsBuilder.createJarBasedRoot(jarFile, pathInJar, filter, destination, pathInJarFilter))) {
            this.onAdded(descriptor);
        }
    }

    @Override
    public abstract ArtifactCompilerInstructionCreatorBase subFolder(@NotNull String var1);

    @Override
    public ArtifactCompilerInstructionCreator subFolderByRelativePath(@NotNull String relativeDirectoryPath) {
        if (relativeDirectoryPath == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(9);
        }
        List folders = StringUtil.split((String)relativeDirectoryPath, (String)"/");
        ArtifactCompilerInstructionCreator current = this;
        for (String folder : folders) {
            current = current.subFolder(folder);
        }
        return current;
    }

    @Override
    public void addFileCopyInstruction(@NotNull File file, @NotNull String outputFileName) {
        if (file == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(10);
        }
        if (outputFileName == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(11);
        }
        this.addFileCopyInstruction(file, outputFileName, FilterCopyHandler.DEFAULT);
    }

    @Override
    public void addFileCopyInstruction(@NotNull File file, @NotNull String outputFileName, @NotNull FileCopyingHandler copyingHandler) {
        FileBasedArtifactRootDescriptor root;
        DestinationInfo destination;
        if (file == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(12);
        }
        if (outputFileName == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(13);
        }
        if (copyingHandler == null) {
            ArtifactCompilerInstructionCreatorBase.$$$reportNull$$$0(14);
        }
        if ((destination = this.createFileDestination(outputFileName)) != null && this.myInstructionsBuilder.addDestination(root = this.myInstructionsBuilder.createFileBasedRoot(file, SourceFileFilter.ALL, destination, copyingHandler))) {
            this.onAdded(root);
        }
    }

    @Override
    public ArtifactInstructionsBuilder getInstructionsBuilder() {
        return this.myInstructionsBuilder;
    }

    @Nullable
    protected abstract DestinationInfo createDirectoryDestination();

    protected abstract DestinationInfo createFileDestination(@NotNull String var1);

    protected abstract void onAdded(ArtifactRootDescriptor var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryUrl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyingHandler";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJarFilter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeDirectoryPath";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirectoryCopyInstructions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtractDirectoryInstruction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "subFolderByRelativePath";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileCopyInstruction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SourceFileFilterImpl
    extends SourceFileFilter {
        private final SourceFileFilter myBaseFilter;
        private final ModuleExcludeIndex myRootsIndex;
        private final IgnoredFileIndex myIgnoredFileIndex;
        private final boolean myIncludeExcluded;

        private SourceFileFilterImpl(@Nullable SourceFileFilter baseFilter, @NotNull ModuleExcludeIndex rootsIndex, IgnoredFileIndex patterns, boolean includeExcluded) {
            if (rootsIndex == null) {
                SourceFileFilterImpl.$$$reportNull$$$0(0);
            }
            this.myBaseFilter = baseFilter;
            this.myRootsIndex = rootsIndex;
            this.myIgnoredFileIndex = patterns;
            this.myIncludeExcluded = includeExcluded;
        }

        @Override
        public boolean accept(@NotNull String fullFilePath) {
            File file;
            if (fullFilePath == null) {
                SourceFileFilterImpl.$$$reportNull$$$0(1);
            }
            if (this.myBaseFilter != null && !this.myBaseFilter.accept(fullFilePath)) {
                return false;
            }
            if (this.myIgnoredFileIndex.isIgnored(PathUtilRt.getFileName((String)fullFilePath))) {
                return false;
            }
            return this.myIncludeExcluded || !this.myRootsIndex.isExcluded(file = JarPathUtil.getLocalFile(fullFilePath));
        }

        @Override
        public boolean shouldBeCopied(@NotNull String fullFilePath, ProjectDescriptor projectDescriptor) throws IOException {
            if (fullFilePath == null) {
                SourceFileFilterImpl.$$$reportNull$$$0(2);
            }
            return this.myBaseFilter == null || this.myBaseFilter.shouldBeCopied(fullFilePath, projectDescriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootsIndex";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullFilePath";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase$SourceFileFilterImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldBeCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

