/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.ClassFileRepr;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.DifferenceImpl;
import org.jetbrains.jps.builders.java.dependencyView.ElemType;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.util.Iterators;

@ApiStatus.Internal
public final class ClassRepr
extends ClassFileRepr {
    private final TypeRepr.ClassType mySuperClass;
    private final Set<TypeRepr.ClassType> myInterfaces;
    private final Set<ElemType> myAnnotationTargets;
    private final RetentionPolicy myRetentionPolicy;
    private final Set<FieldRepr> myFields;
    private final Set<MethodRepr> myMethods;
    private final int myOuterClassName;
    private final boolean myIsLocal;
    private final boolean myIsAnonymous;
    private final boolean myIsGenerated;
    private boolean myHasInlinedConstants;
    private static final int LOCAL_MASK = 1;
    private static final int ANONYMOUS_MASK = 2;
    private static final int HAS_INLINED_CONSTANTS_MASK = 4;
    private static final int IS_GENERATED_MASK = 8;

    public Set<MethodRepr> getMethods() {
        return this.myMethods;
    }

    public Set<FieldRepr> getFields() {
        return this.myFields;
    }

    public int getOuterClassName() {
        return this.myOuterClassName;
    }

    public boolean isLocal() {
        return this.myIsLocal;
    }

    public boolean isAnonymous() {
        return this.myIsAnonymous;
    }

    public boolean isGenerated() {
        return this.myIsGenerated;
    }

    public boolean hasInlinedConstants() {
        return this.myHasInlinedConstants;
    }

    public void setHasInlinedConstants(boolean hasConstants) {
        this.myHasInlinedConstants = hasConstants;
    }

    public TypeRepr.ClassType getSuperClass() {
        return this.mySuperClass;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this.myRetentionPolicy;
    }

    public Set<ElemType> getAnnotationTargets() {
        Set<ElemType> targets = this.myAnnotationTargets;
        return targets != null ? Collections.unmodifiableSet(targets) : Collections.emptySet();
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isEnum() {
        return (this.access & 0x4000) != 0;
    }

    @Override
    public Diff difference(final Proto past) {
        final ClassRepr pastClass = (ClassRepr)past;
        Difference diff = super.difference(past);
        int base = diff.base();
        if (!this.mySuperClass.equals(pastClass.mySuperClass)) {
            base |= 0x10;
        }
        if (!this.getUsages().equals(pastClass.getUsages())) {
            base |= 0x20;
        }
        if (this.hasInlinedConstants() != pastClass.hasInlinedConstants()) {
            base |= 0x80;
        }
        final int d = base;
        return new Diff(diff){

            @Override
            public boolean extendsAdded() {
                if ((d & 0x10) <= 0) {
                    return false;
                }
                String pastSuperName = ClassRepr.this.myContext.getValue(((ClassRepr)past).mySuperClass.className);
                return "java/lang/Object".equals(pastSuperName);
            }

            @Override
            public Difference.Specifier<TypeRepr.ClassType, Difference> interfaces() {
                return Difference.make(pastClass.myInterfaces, ClassRepr.this.myInterfaces);
            }

            @Override
            public Difference.Specifier<FieldRepr, Difference> fields() {
                return Difference.make(pastClass.myFields, ClassRepr.this.myFields);
            }

            @Override
            public Difference.Specifier<MethodRepr, MethodRepr.Diff> methods() {
                return Difference.make(pastClass.myMethods, ClassRepr.this.myMethods);
            }

            @Override
            public Difference.Specifier<ElemType, Difference> targets() {
                return Difference.make(pastClass.myAnnotationTargets, ClassRepr.this.myAnnotationTargets);
            }

            @Override
            public boolean retentionChanged() {
                return !(ClassRepr.this.myRetentionPolicy == null && pastClass.myRetentionPolicy == RetentionPolicy.CLASS || ClassRepr.this.myRetentionPolicy == RetentionPolicy.CLASS && pastClass.myRetentionPolicy == null || ClassRepr.this.myRetentionPolicy == pastClass.myRetentionPolicy);
            }

            @Override
            public boolean targetAttributeCategoryMightChange() {
                Difference.Specifier<ElemType, Difference> targetsDiff = this.targets();
                if (!targetsDiff.unchanged()) {
                    for (ElemType elemType : Set.of(ElemType.TYPE_USE, ElemType.RECORD_COMPONENT)) {
                        if (!targetsDiff.added().contains((Object)elemType) && !targetsDiff.removed().contains((Object)elemType) && !pastClass.getAnnotationTargets().contains((Object)elemType)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public int base() {
                return d;
            }

            @Override
            public boolean hadValue() {
                return false;
            }
        };
    }

    public Iterable<TypeRepr.ClassType> getSuperTypes() {
        return Iterators.flat((Iterable)Iterators.asIterable((Object)this.mySuperClass), this.myInterfaces);
    }

    @Override
    protected void updateClassUsages(DependencyContext context, Set<? super UsageRepr.Usage> s) {
        this.mySuperClass.updateClassUsages(context, this.name, s);
        for (TypeRepr.AbstractType abstractType : this.myInterfaces) {
            abstractType.updateClassUsages(context, this.name, s);
        }
        for (MethodRepr methodRepr : this.myMethods) {
            methodRepr.updateClassUsages(context, this.name, s);
        }
        for (FieldRepr fieldRepr : this.myFields) {
            fieldRepr.updateClassUsages(context, this.name, s);
        }
    }

    public ClassRepr(DependencyContext context, int access, int fileName, int name, int sig, int superClass, String[] interfaces, Set<FieldRepr> fields, Set<MethodRepr> methods, Set<TypeRepr.ClassType> annotations, Set<ElemType> annotationTargets, RetentionPolicy policy, int outerClassName, boolean localClassFlag, boolean anonymousClassFlag, Set<UsageRepr.Usage> usages, boolean isGenerated) {
        super(access, sig, name, annotations, fileName, context, usages);
        this.mySuperClass = TypeRepr.createClassType(context, superClass);
        this.myInterfaces = TypeRepr.createClassType(context, interfaces, new HashSet(1));
        this.myFields = fields;
        this.myMethods = methods;
        this.myAnnotationTargets = annotationTargets;
        this.myRetentionPolicy = policy;
        this.myOuterClassName = outerClassName;
        this.myIsLocal = localClassFlag;
        this.myIsAnonymous = anonymousClassFlag;
        this.myIsGenerated = isGenerated;
        this.updateClassUsages(context, usages);
    }

    public ClassRepr(DependencyContext context, DataInput in) {
        super(context, in);
        try {
            this.mySuperClass = (TypeRepr.ClassType)TypeRepr.externalizer(context).read(in);
            this.myInterfaces = RW.read(TypeRepr.externalizer(context), new HashSet(1), in);
            this.myFields = RW.read(FieldRepr.externalizer(context), new HashSet(), in);
            this.myMethods = RW.read(MethodRepr.externalizer(context), new HashSet(), in);
            this.myAnnotationTargets = RW.read(UsageRepr.AnnotationUsage.elementTypeExternalizer, EnumSet.noneOf(ElemType.class), in);
            String s = RW.readUTF(in);
            this.myRetentionPolicy = s.isEmpty() ? null : RetentionPolicy.valueOf(s);
            this.myOuterClassName = DataInputOutputUtil.readINT((DataInput)in);
            int flags = DataInputOutputUtil.readINT((DataInput)in);
            this.myIsLocal = (flags & 1) != 0;
            this.myIsAnonymous = (flags & 2) != 0;
            this.myHasInlinedConstants = (flags & 4) != 0;
            this.myIsGenerated = (flags & 8) != 0;
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void save(DataOutput out) {
        try {
            super.save(out);
            this.mySuperClass.save(out);
            RW.save(this.myInterfaces, out);
            RW.save(this.myFields, out);
            RW.save(this.myMethods, out);
            RW.save(this.myAnnotationTargets, UsageRepr.AnnotationUsage.elementTypeExternalizer, out);
            RW.writeUTF(out, this.myRetentionPolicy == null ? "" : this.myRetentionPolicy.toString());
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOuterClassName);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)((this.myIsLocal ? 1 : 0) | (this.myIsAnonymous ? 2 : 0) | (this.myHasInlinedConstants ? 4 : 0) | (this.myIsGenerated ? 8 : 0)));
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public UsageRepr.Usage createUsage() {
        return UsageRepr.createClassUsage(this.myContext, this.name);
    }

    public String getPackageName() {
        String strValue = this.myContext.getValue(this.name);
        return strValue != null ? ClassRepr.getPackageName(strValue) : null;
    }

    public String getShortName() {
        String strValue = this.myContext.getValue(this.name);
        return strValue != null ? ClassRepr.getShortName(strValue) : null;
    }

    @NotNull
    public static String getPackageName(@NotNull String raw) {
        int index;
        if (raw == null) {
            ClassRepr.$$$reportNull$$$0(0);
        }
        if ((index = raw.lastIndexOf(47)) == -1) {
            return "";
        }
        String string = raw.substring(0, index);
        if (string == null) {
            ClassRepr.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getShortName(@NotNull String fqName) {
        int index;
        if (fqName == null) {
            ClassRepr.$$$reportNull$$$0(2);
        }
        if ((index = fqName.lastIndexOf(47)) == -1) {
            String string = fqName;
            if (string == null) {
                ClassRepr.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = fqName.substring(index + 1);
        if (string == null) {
            ClassRepr.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public FieldRepr findField(int name) {
        for (FieldRepr f : this.myFields) {
            if (f.name != name) continue;
            return f;
        }
        return null;
    }

    @NotNull
    public Collection<MethodRepr> findMethods(Predicate<? super MethodRepr> p) {
        LinkedList<MethodRepr> result = new LinkedList<MethodRepr>();
        for (MethodRepr mm : this.myMethods) {
            if (!p.test(mm)) continue;
            result.add(mm);
        }
        LinkedList<MethodRepr> linkedList = result;
        if (linkedList == null) {
            ClassRepr.$$$reportNull$$$0(5);
        }
        return linkedList;
    }

    public static DataExternalizer<ClassRepr> externalizer(final DependencyContext context) {
        return new DataExternalizer<ClassRepr>(){

            public void save(@NotNull DataOutput out, ClassRepr value) {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                value.save(out);
            }

            public ClassRepr read(@NotNull DataInput in) {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                return new ClassRepr(context, in);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/ClassRepr$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        super.toStream(context, stream);
        stream.print("      Superclass : ");
        stream.println(this.mySuperClass.getDescr(context));
        stream.print("      Interfaces : ");
        TypeRepr.AbstractType[] is = this.myInterfaces.toArray(TypeRepr.AbstractType.EMPTY_TYPE_ARRAY);
        Arrays.sort(is, Comparator.comparing(o -> o.getDescr(context)));
        for (TypeRepr.AbstractType t : is) {
            stream.print(t.getDescr(context));
            stream.print(" ");
        }
        stream.println();
        stream.print("      Targets    : ");
        ElemType[] es = this.myAnnotationTargets.toArray(new ElemType[0]);
        Arrays.sort((Object[])es);
        for (ElemType e : es) {
            stream.print((Object)e);
            stream.print("; ");
        }
        stream.println();
        stream.print("      Policy     : ");
        stream.println((Object)this.myRetentionPolicy);
        stream.print("      Outer class: ");
        stream.println(context.getValue(this.myOuterClassName));
        stream.print("      Local class: ");
        stream.println(this.myIsLocal);
        stream.print("      Anonymous class: ");
        stream.println(this.myIsAnonymous);
        stream.print("      Has inlined constants: ");
        stream.println(this.myHasInlinedConstants);
        stream.print("      IsGenerated: ");
        stream.println(this.myIsGenerated);
        stream.println("      Fields:");
        FieldRepr[] fs = this.myFields.toArray(new FieldRepr[0]);
        Arrays.sort(fs, (o1, o2) -> {
            if (o1.name == o2.name) {
                return o1.myType.getDescr(context).compareTo(o2.myType.getDescr(context));
            }
            return Objects.requireNonNull(context.getValue(o1.name)).compareTo(Objects.requireNonNull(context.getValue(o2.name)));
        });
        for (FieldRepr f : fs) {
            f.toStream(context, stream);
        }
        stream.println("      End Of Fields");
        stream.println("      Methods:");
        MethodRepr[] ms = this.myMethods.toArray(new MethodRepr[0]);
        Arrays.sort(ms, (o1, o2) -> {
            if (o1.name == o2.name) {
                String d2;
                String d1 = o1.myType.getDescr(context);
                int c = d1.compareTo(d2 = o2.myType.getDescr(context));
                if (c == 0) {
                    int l1 = o1.myArgumentTypes.length;
                    int l2 = o2.myArgumentTypes.length;
                    if (l1 == l2) {
                        for (int i = 0; i < l1; ++i) {
                            String d22;
                            String d11 = o1.myArgumentTypes[i].getDescr(context);
                            int cc = d11.compareTo(d22 = o2.myArgumentTypes[i].getDescr(context));
                            if (cc == 0) continue;
                            return cc;
                        }
                        return 0;
                    }
                    return l1 - l2;
                }
                return c;
            }
            return Objects.requireNonNull(context.getValue(o1.name)).compareTo(Objects.requireNonNull(context.getValue(o2.name)));
        });
        for (MethodRepr m : ms) {
            m.toStream(context, stream);
        }
        stream.println("      End Of Methods");
        stream.println("      Usages:");
        LinkedList<String> usages = new LinkedList<String>();
        for (UsageRepr.Usage u : this.getUsages()) {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            u.toStream(this.myContext, new PrintStream(bas));
            try {
                bas.close();
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
            usages.add(bas.toString());
        }
        Collections.sort(usages);
        for (String s : usages) {
            stream.println(s);
        }
        stream.println("      End Of Usages");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "raw";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/java/dependencyView/ClassRepr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/ClassRepr";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Diff
    extends DifferenceImpl {
        Diff(@NotNull Difference delegate) {
            if (delegate == null) {
                Diff.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        public abstract Difference.Specifier<TypeRepr.ClassType, Difference> interfaces();

        public abstract Difference.Specifier<FieldRepr, Difference> fields();

        public abstract Difference.Specifier<MethodRepr, MethodRepr.Diff> methods();

        public abstract Difference.Specifier<ElemType, Difference> targets();

        public abstract boolean retentionChanged();

        public abstract boolean extendsAdded();

        public abstract boolean targetAttributeCategoryMightChange();

        @Override
        public boolean no() {
            return this.base() == 0 && this.interfaces().unchanged() && this.fields().unchanged() && this.methods().unchanged() && this.targets().unchanged() && !this.retentionChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr$Diff", "<init>"));
        }
    }
}

