/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import java.io.File;
import java.io.FileFilter;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class JavadocSnippetsSkipFilter
implements FileFilter {
    public static final String SNIPPETS_FOLDER = "snippet-files";
    private static final String SNIPPETS_FOLDER_PATTERN = "/snippet-files/";
    static final BiFunction<String, Integer, Integer> FIND_SNIPPETS_FOLDER_PATTERN = SystemInfoRt.isFileSystemCaseSensitive ? (s, from) -> Strings.indexOf((CharSequence)s, (CharSequence)SNIPPETS_FOLDER_PATTERN, (int)from) : (s, from) -> Strings.indexOfIgnoreCase((String)s, (String)SNIPPETS_FOLDER_PATTERN, (int)from);
    private final File myRoot;

    JavadocSnippetsSkipFilter(File root) {
        this.myRoot = root;
    }

    @Override
    public boolean accept(File file) {
        return !this.isJavadocExtSnippet(file);
    }

    private boolean isJavadocExtSnippet(File file) {
        String filePath = FileUtilRt.toSystemIndependentName((String)file.getPath());
        int patternIndex = FIND_SNIPPETS_FOLDER_PATTERN.apply(filePath, 0);
        if (patternIndex < 0) {
            return false;
        }
        String rootPath = FileUtilRt.toSystemIndependentName((String)this.myRoot.getPath());
        if (!FileUtil.startsWith((String)filePath, (String)rootPath, (boolean)SystemInfoRt.isFileSystemCaseSensitive, (boolean)true)) {
            return false;
        }
        int fromIndex = rootPath.endsWith("/") ? rootPath.length() - 1 : rootPath.length();
        return patternIndex >= fromIndex || FIND_SNIPPETS_FOLDER_PATTERN.apply(filePath, fromIndex) >= 0;
    }
}

