/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.java.workspace.entities.JavaModuleSettingsEntity;
import com.intellij.java.workspace.entities.JavaModuleSettingsKt;
import com.intellij.java.workspace.entities.JavaRootsKt;
import com.intellij.java.workspace.entities.JavaSourceRootPropertiesEntity;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.DependencyScope;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.InheritedSdkDependency;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleDependency;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SdkDependency;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.ide.legacyBridge.impl.java.JavaSourceRootTypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.config.ModulePathShortener;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J-\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0004\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/idea/eclipse/config/EmlFileSaver;", "", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "entities", "", "Ljava/lang/Class;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "pathShortener", "Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;", "moduleReplacePathMacroMap", "Lcom/intellij/openapi/components/PathMacroMap;", "projectReplacePathMacroMap", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;Ljava/util/Map;Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;Lcom/intellij/openapi/components/PathMacroMap;Lcom/intellij/openapi/components/PathMacroMap;)V", "saveEml", "Lorg/jdom/Element;", "saveModuleRelatedRoots", "", "libTag", "library", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "type", "Lcom/intellij/openapi/roots/OrderRootType;", "tagName", "", "Lorg/jetbrains/annotations/NonNls;", "generateLibName", "saveContentRoots", "root", "saveCustomJavaSettings", "intellij.eclipse"})
@SourceDebugExtension(value={"SMAP\nEmlFileSaver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmlFileSaver.kt\norg/jetbrains/idea/eclipse/config/EmlFileSaver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1208#2,2:171\n1236#2,4:173\n1869#2:177\n774#2:178\n865#2,2:179\n1869#2,2:181\n774#2:183\n865#2,2:184\n1869#2,2:186\n1870#2:188\n774#2:189\n865#2,2:190\n1869#2,2:192\n295#2,2:194\n1869#2:196\n1869#2,2:197\n1869#2,2:199\n1870#2:201\n*S KotlinDebug\n*F\n+ 1 EmlFileSaver.kt\norg/jetbrains/idea/eclipse/config/EmlFileSaver\n*L\n40#1:171,2\n40#1:173,4\n42#1:177\n65#1:178\n65#1:179,2\n67#1:181,2\n75#1:183\n75#1:184,2\n75#1:186,2\n42#1:188\n110#1:189\n110#1:190,2\n110#1:192,2\n120#1:194,2\n128#1:196\n130#1:197,2\n141#1:199,2\n128#1:201\n*E\n"})
public final class EmlFileSaver {
    @NotNull
    private final ModuleEntity module;
    @NotNull
    private final Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>> entities;
    @NotNull
    private final ModulePathShortener pathShortener;
    @NotNull
    private final PathMacroMap moduleReplacePathMacroMap;
    @NotNull
    private final PathMacroMap projectReplacePathMacroMap;

    public EmlFileSaver(@NotNull ModuleEntity module, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities, @NotNull ModulePathShortener pathShortener, @NotNull PathMacroMap moduleReplacePathMacroMap, @NotNull PathMacroMap projectReplacePathMacroMap) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)pathShortener, (String)"pathShortener");
        Intrinsics.checkNotNullParameter((Object)moduleReplacePathMacroMap, (String)"moduleReplacePathMacroMap");
        Intrinsics.checkNotNullParameter((Object)projectReplacePathMacroMap, (String)"projectReplacePathMacroMap");
        this.module = module;
        this.entities = entities;
        this.pathShortener = pathShortener;
        this.moduleReplacePathMacroMap = moduleReplacePathMacroMap;
        this.projectReplacePathMacroMap = projectReplacePathMacroMap;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Element saveEml() {
        void $this$associateByTo$iv$iv;
        Element root = new Element("component");
        this.saveCustomJavaSettings(root);
        this.saveContentRoots(root);
        List list = this.entities.get(LibraryEntity.class);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Map.Entry entry2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LibraryEntity libraryEntity = (LibraryEntity)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map moduleLibraries = destination$iv$iv;
        LinkedHashMap libLevels = new LinkedHashMap();
        Iterable $this$forEach$iv = this.module.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependencyItem dep = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            ModuleDependencyItem moduleDependencyItem = dep;
            if (moduleDependencyItem instanceof ModuleDependency) {
                if (((ModuleDependency)dep).getScope() == DependencyScope.COMPILE) continue;
                root.addContent(new Element("module").setAttribute("name", ((ModuleDependency)dep).getModule().getName()).setAttribute("scope", ((ModuleDependency)dep).getScope().name()));
                continue;
            }
            if (moduleDependencyItem instanceof InheritedSdkDependency) {
                root.setAttribute("inheritJdk", "true");
                continue;
            }
            if (moduleDependencyItem instanceof SdkDependency) {
                root.setAttribute("jdk", ((SdkDependency)dep).getSdk().getName());
                root.setAttribute("jdk_type", ((SdkDependency)dep).getSdk().getType());
                continue;
            }
            if (!(moduleDependencyItem instanceof LibraryDependency)) continue;
            Element libTag = new Element("lib");
            LibraryEntity library = (LibraryEntity)moduleLibraries.get(((LibraryDependency)dep).getLibrary().getName());
            String string = LibraryNameGenerator.INSTANCE.getLegacyLibraryName(((LibraryDependency)dep).getLibrary());
            if (string == null) {
                string = this.generateLibName(library);
            }
            String libName = string;
            libTag.setAttribute("name", libName);
            libTag.setAttribute("scope", ((LibraryDependency)dep).getScope().name());
            LibraryTableId tableId = ((LibraryDependency)dep).getLibrary().getTableId();
            if (tableId instanceof LibraryTableId.ModuleLibraryTableId) {
                if (library != null) {
                    void $this$filterTo$iv$iv;
                    void $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv = library.getRoots();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Object destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        LibraryRoot it = (LibraryRoot)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)OrderRootType.SOURCES.name())) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List srcRoots = (List)destination$iv$iv2;
                    Object object = (LibraryRoot)CollectionsKt.firstOrNull((List)srcRoots);
                    String eclipseUrl = object != null && (object = object.getUrl()) != null && (object = object.getUrl()) != null ? StringsKt.substringBefore$default((String)object, (String)"!/", null, (int)2, null) : null;
                    Iterable $this$forEach$iv2 = srcRoots;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        LibraryRoot it = (LibraryRoot)element$iv2;
                        boolean bl3 = false;
                        String url = it.getUrl().getUrl();
                        Element srcTag = new Element("srcroot").setAttribute("url", url);
                        if (!EPathUtil.areUrlsPointTheSame(url, eclipseUrl)) {
                            srcTag.setAttribute("bind", "false");
                        }
                        libTag.addContent(srcTag);
                    }
                    Iterable $this$filter$iv2 = library.getRoots();
                    boolean $i$f$filter2 = false;
                    destination$iv$iv2 = $this$filter$iv2;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        LibraryRoot it = (LibraryRoot)element$iv$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)"JAVADOC")) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    $this$forEach$iv2 = CollectionsKt.drop((Iterable)((List)destination$iv$iv3), (int)1);
                    $i$f$forEach2 = false;
                    for (Object element$iv3 : $this$forEach$iv2) {
                        LibraryRoot it = (LibraryRoot)element$iv3;
                        boolean bl5 = false;
                        libTag.addContent(new Element("javadocroot_attr").setAttribute("url", it.getUrl().getUrl()));
                    }
                    OrderRootType orderRootType = OrderRootType.SOURCES;
                    Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"SOURCES");
                    this.saveModuleRelatedRoots(libTag, library, orderRootType, "relative-module-src");
                    OrderRootType orderRootType2 = OrderRootType.CLASSES;
                    Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"CLASSES");
                    this.saveModuleRelatedRoots(libTag, library, orderRootType2, "relative-module-cls");
                    OrderRootType orderRootType3 = JavadocOrderRootType.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)orderRootType3, (String)"getInstance(...)");
                    this.saveModuleRelatedRoots(libTag, library, orderRootType3, "relative-module-javadoc");
                }
            } else if (tableId instanceof LibraryTableId.ProjectLibraryTableId) {
                ((Map)libLevels).put(((LibraryDependency)dep).getLibrary().getName(), "project");
            } else if (tableId instanceof LibraryTableId.GlobalLibraryTableId) {
                if (!Intrinsics.areEqual((Object)((LibraryTableId.GlobalLibraryTableId)tableId).getLevel(), (Object)"application")) {
                    ((Map)libLevels).put(((LibraryDependency)dep).getLibrary().getName(), ((LibraryTableId.GlobalLibraryTableId)tableId).getLevel());
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List list2 = libTag.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
            if (!(!((Collection)list2).isEmpty()) && ((LibraryDependency)dep).getScope() == DependencyScope.COMPILE) continue;
            root.addContent(libTag);
        }
        if (!((Map)libLevels).isEmpty()) {
            Element levelsTag = new Element("levels");
            for (Map.Entry entry2 : ((Map)libLevels).entrySet()) {
                String name = (String)entry2.getKey();
                String level = (String)entry2.getValue();
                levelsTag.addContent(new Element("level").setAttribute("name", name).setAttribute("value", level));
            }
            root.addContent(levelsTag);
        }
        this.moduleReplacePathMacroMap.substitute(root, SystemInfo.isFileSystemCaseSensitive);
        return JDOMUtil.isEmpty((Element)root) ? null : root;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveModuleRelatedRoots(Element libTag, LibraryEntity library, OrderRootType type, String tagName) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = library.getRoots();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LibraryRoot it = (LibraryRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)type.name())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file;
            LibraryRoot it = (LibraryRoot)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = file = VirtualFileUrls.getVirtualFile((VirtualFileUrl)it.getUrl());
            VirtualFile localFile = (virtualFile != null ? virtualFile.getFileSystem() : null) instanceof JarFileSystem ? JarFileSystem.getInstance().getVirtualFileForJar(file) : file;
            if (localFile == null || !this.pathShortener.isUnderContentRoots(localFile)) continue;
            libTag.addContent(new Element(tagName).setAttribute("project-related", this.projectReplacePathMacroMap.substitute(it.getUrl().getUrl(), SystemInfo.isFileSystemCaseSensitive)));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final String generateLibName(LibraryEntity library) {
        block5: {
            v0 /* !! */  = library;
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getRoots()) == null) ** GOTO lbl-1000
            $this$firstOrNull$iv = (Iterable)v0 /* !! */ ;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (LibraryRoot)element$iv;
                $i$a$-firstOrNull-EmlFileSaver$generateLibName$firstRoot$1 = false;
                if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)OrderRootType.CLASSES.name())) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        if ((v0 /* !! */  = (LibraryRoot)v1) != null) {
            v2 = v0 /* !! */ .getUrl();
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        v3 = firstRoot = v2;
        file = v3 != null ? VirtualFileUrls.getVirtualFile(v3) : null;
        v4 = fileForJar = JarFileSystem.getInstance().getVirtualFileForJar(file);
        if (v4 != null) {
            v5 = v4.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getName(...)");
            return v5;
        }
        v6 /* !! */  = file;
        if (v6 /* !! */  == null || (v6 /* !! */  = v6 /* !! */ .getName()) == null) {
            v6 /* !! */  = "Empty Library";
        }
        return v6 /* !! */ ;
    }

    private final void saveContentRoots(Element root) {
        Iterable $this$forEach$iv = this.module.getContentRoots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContentRootEntity contentRoot = (ContentRootEntity)element$iv;
            boolean bl = false;
            Element contentRootTag = new Element("contentEntry").setAttribute("url", contentRoot.getUrl().getUrl());
            Iterable $this$forEach$iv2 = contentRoot.getSourceRoots();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SourceRootEntity sourceRoot = (SourceRootEntity)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)sourceRoot.getRootTypeId(), (Object)JavaSourceRootTypeUtils.JAVA_TEST_ROOT_ENTITY_TYPE_ID)) {
                    contentRootTag.addContent(new Element("testFolder").setAttribute("url", sourceRoot.getUrl().getUrl()));
                }
                JavaSourceRootPropertiesEntity javaSourceRootPropertiesEntity = JavaRootsKt.asJavaSourceRoot((SourceRootEntity)sourceRoot);
                String packagePrefix = javaSourceRootPropertiesEntity != null ? javaSourceRootPropertiesEntity.getPackagePrefix() : null;
                CharSequence charSequence = packagePrefix;
                if (charSequence == null || charSequence.length() == 0) continue;
                contentRootTag.addContent(new Element("packagePrefix").setAttribute("url", sourceRoot.getUrl().getUrl()).setAttribute("value", packagePrefix));
            }
            VirtualFile rootFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)contentRoot.getUrl());
            Iterable $this$forEach$iv3 = contentRoot.getExcludedUrls();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                ExcludeUrlEntity excluded = (ExcludeUrlEntity)element$iv3;
                boolean bl3 = false;
                VirtualFile excludedFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)excluded.getUrl());
                if (rootFile != null && excludedFile != null && !VfsUtilCore.isAncestor((VirtualFile)rootFile, (VirtualFile)excludedFile, (boolean)false)) continue;
                contentRootTag.addContent(new Element("excludeFolder").setAttribute("url", excluded.getUrl().getUrl()));
            }
            if (JDOMUtil.isEmpty((Element)contentRootTag)) continue;
            root.addContent(contentRootTag);
        }
    }

    private final void saveCustomJavaSettings(Element root) {
        block4: {
            JavaModuleSettingsEntity javaModuleSettingsEntity = JavaModuleSettingsKt.getJavaSettings((ModuleEntity)this.module);
            if (javaModuleSettingsEntity == null) break block4;
            JavaModuleSettingsEntity javaSettings = javaModuleSettingsEntity;
            boolean bl = false;
            VirtualFileUrl virtualFileUrl = javaSettings.getCompilerOutputForTests();
            if (virtualFileUrl != null) {
                VirtualFileUrl testOutput = virtualFileUrl;
                boolean bl2 = false;
                root.addContent(new Element("output-test").setAttribute("url", testOutput.getUrl()));
            }
            if (javaSettings.getInheritedCompilerOutput()) {
                root.setAttribute("inherit-compiler-output", "true");
            }
            if (javaSettings.getExcludeOutput()) {
                root.addContent(new Element("exclude-output"));
            }
            String string = javaSettings.getLanguageLevelId();
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                root.setAttribute("LANGUAGE_LEVEL", it);
            }
        }
    }
}

