/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.util.SdkHomeBean;
import org.jetbrains.plugins.groovy.util.SdkHomeSettings;

public abstract class SdkHomeConfigurable
implements SearchableConfigurable {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myPathField;
    protected final Project myProject;
    @NlsSafe
    protected final String myFrameworkName;

    public SdkHomeConfigurable(Project project, @NlsSafe String frameworkName) {
        this.myProject = project;
        this.myFrameworkName = frameworkName;
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return this.myFrameworkName;
    }

    public JComponent createComponent() {
        this.myPanel = new JPanel(new BorderLayout(10, 5));
        JPanel contentPanel = new JPanel(new BorderLayout(4, 0));
        this.myPanel.add((Component)contentPanel, "North");
        contentPanel.add((Component)new JLabel(GroovyBundle.message("framework.0.home.label", this.myFrameworkName)), "West");
        this.myPathField = new TextFieldWithBrowseButton();
        contentPanel.add((Component)this.myPathField);
        this.myPathField.addBrowseFolderListener(this.myProject, new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return file != null && SdkHomeConfigurable.this.isSdkHome(file);
            }
        }.withTitle(GroovyBundle.message("select.framework.0.home.title", this.myFrameworkName)));
        return this.myPanel;
    }

    protected abstract boolean isSdkHome(VirtualFile var1);

    public boolean isModified() {
        return !this.myPathField.getText().equals(StringUtil.notNullize((String)this.getStateText()));
    }

    public void apply() throws ConfigurationException {
        SdkHomeBean state = new SdkHomeBean();
        state.setSdkHome(FileUtil.toSystemIndependentName((String)this.myPathField.getText()));
        this.getFrameworkSettings().loadState(state);
    }

    protected abstract SdkHomeSettings getFrameworkSettings();

    public void reset() {
        this.myPathField.setText(this.getStateText());
    }

    @NlsSafe
    @Nullable
    private String getStateText() {
        SdkHomeBean state = this.getFrameworkSettings().getState();
        if (state == null) {
            return null;
        }
        String sdkHome = state.getSdkHome();
        if (sdkHome == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)sdkHome);
    }

    public void disposeUIResources() {
        this.myPathField = null;
        this.myPanel = null;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            SdkHomeConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public abstract String getHelpTopic();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/util/SdkHomeConfigurable", "getId"));
    }
}

