/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations;

import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.light.AbstractLightClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0018H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0005H\u0016\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010(J\u0015\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010(J\n\u0010+\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u000eH\u0016J\b\u0010/\u001a\u00020\u001bH\u0016J\b\u00100\u001a\u00020\u0015H\u0016J\b\u00101\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0018\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/groovy/transformations/HierarchyView;", "Lcom/intellij/psi/impl/light/AbstractLightClass;", "myCodeClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "myExtendsTypes", "", "Lcom/intellij/psi/PsiClassType;", "myImplementsTypes", "manager", "Lcom/intellij/psi/PsiManager;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;[Lcom/intellij/psi/PsiClassType;[Lcom/intellij/psi/PsiClassType;Lcom/intellij/psi/PsiManager;)V", "[Lcom/intellij/psi/PsiClassType;", "isValid", "", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "isEquivalentTo", "another", "Lcom/intellij/psi/PsiElement;", "getContext", "getName", "", "getQualifiedName", "getContainingClass", "Lcom/intellij/psi/PsiClass;", "isInterface", "isEnum", "getModifierList", "Lcom/intellij/psi/PsiModifierList;", "hasModifierProperty", "name", "getTypeParameterList", "Lcom/intellij/psi/PsiTypeParameterList;", "getTypeParameters", "Lcom/intellij/psi/PsiTypeParameter;", "()[Lcom/intellij/psi/PsiTypeParameter;", "getImplementsListTypes", "()[Lcom/intellij/psi/PsiClassType;", "getExtendsListTypes", "getSuperTypes", "getSuperClass", "isInheritor", "baseClass", "checkDeep", "getDelegate", "copy", "toString", "intellij.groovy.psi"})
public final class HierarchyView
extends AbstractLightClass {
    @NotNull
    private final GrTypeDefinition myCodeClass;
    @NotNull
    private final PsiClassType[] myExtendsTypes;
    @NotNull
    private final PsiClassType[] myImplementsTypes;

    public HierarchyView(@NotNull GrTypeDefinition myCodeClass, @NotNull PsiClassType[] myExtendsTypes, @NotNull PsiClassType[] myImplementsTypes, @NotNull PsiManager manager) {
        Intrinsics.checkNotNullParameter((Object)myCodeClass, (String)"myCodeClass");
        Intrinsics.checkNotNullParameter((Object)myExtendsTypes, (String)"myExtendsTypes");
        Intrinsics.checkNotNullParameter((Object)myImplementsTypes, (String)"myImplementsTypes");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(manager, (Language)GroovyLanguage.INSTANCE);
        this.myCodeClass = myCodeClass;
        this.myExtendsTypes = myExtendsTypes;
        this.myImplementsTypes = myImplementsTypes;
    }

    public boolean isValid() {
        return this.myCodeClass.isValid();
    }

    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile = this.myCodeClass.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return psiFile;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myCodeClass.getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
        return globalSearchScope;
    }

    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return this == another;
    }

    @Nullable
    public PsiElement getContext() {
        return this.myCodeClass.getContext();
    }

    @Nullable
    public String getName() {
        return this.myCodeClass.getName();
    }

    @Nullable
    public String getQualifiedName() {
        return this.myCodeClass.getQualifiedName();
    }

    @Nullable
    public PsiClass getContainingClass() {
        return this.myCodeClass.getContainingClass();
    }

    public boolean isInterface() {
        return this.myCodeClass.isInterface();
    }

    public boolean isEnum() {
        return this.myCodeClass.isEnum();
    }

    @Nullable
    public PsiModifierList getModifierList() {
        return this.myCodeClass.getModifierList();
    }

    public boolean hasModifierProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return GrModifierListUtil.hasCodeModifierProperty((PsiModifierListOwner)this.myCodeClass, name);
    }

    @Nullable
    public PsiTypeParameterList getTypeParameterList() {
        return this.myCodeClass.getTypeParameterList();
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = this.myCodeClass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        return psiTypeParameterArray;
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        return this.myImplementsTypes;
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        return this.myExtendsTypes;
    }

    @NotNull
    public PsiClassType[] getSuperTypes() {
        Object[] objectArray = ArrayUtil.mergeArrays((Object[])this.myExtendsTypes, (Object[])this.myImplementsTypes);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"mergeArrays(...)");
        return (PsiClassType[])objectArray;
    }

    @Nullable
    public PsiClass getSuperClass() {
        return GrClassImplUtil.getSuperClass(this.myCodeClass, this.myExtendsTypes);
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        Intrinsics.checkNotNullParameter((Object)baseClass, (String)"baseClass");
        return InheritanceImplUtil.isInheritor((PsiClass)((PsiClass)this), (PsiClass)baseClass, (boolean)checkDeep);
    }

    @NotNull
    public PsiClass getDelegate() {
        throw new IllegalStateException("must not be called".toString());
    }

    @NotNull
    public PsiElement copy() {
        throw new IllegalStateException("must not be called".toString());
    }

    @NotNull
    public String toString() {
        return "[Hierarchy view] " + this.getName();
    }
}

