/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyRunnerPsiUtil;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyRunConfigurationEditor;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;
import org.jetbrains.plugins.groovy.runner.util.CommonProgramRunConfigurationParametersDelegate;

public final class GroovyScriptRunConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule, Element>
implements CommonJavaRunConfigurationParameters,
RefactoringListenerProvider {
    private String vmParams;
    private String workDir;
    private boolean isDebugEnabled;
    private boolean isAddClasspathToTheRunner;
    @Nullable
    private String scriptParams;
    @Nullable
    private String scriptPath;
    private final Map<String, String> envs = new LinkedHashMap<String, String>();
    public boolean passParentEnv = true;
    private boolean myAlternativeJrePathEnabled;
    @Nullable
    private String myAlternativeJrePath;

    public GroovyScriptRunConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, new RunConfigurationModule(project), factory);
        this.workDir = PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
    }

    @Nullable
    public Module getModule() {
        Module module = this.getConfigurationModule().getModule();
        if (module != null) {
            return module;
        }
        return this.getFirstValidModule();
    }

    @Nullable
    private Module getFirstValidModule() {
        GroovyScriptRunner scriptRunner = this.getScriptRunner();
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        if (scriptRunner == null) {
            return modules[0];
        }
        for (Module module : modules) {
            if (!scriptRunner.isValidModule(module)) continue;
            return module;
        }
        return null;
    }

    public Collection<Module> getValidModules() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        GroovyScriptRunner scriptRunner = this.getScriptRunner();
        if (scriptRunner == null) {
            return Arrays.asList(modules);
        }
        ArrayList<Module> res = new ArrayList<Module>();
        for (Module module : modules) {
            if (!scriptRunner.isValidModule(module)) continue;
            res.add(module);
        }
        return res;
    }

    @Nullable
    private GroovyScriptRunner getScriptRunner() {
        VirtualFile scriptFile = ScriptFileUtil.findScriptFileByPath((String)this.getScriptPath());
        if (scriptFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(scriptFile);
        if (!(psiFile instanceof GroovyFile)) {
            return null;
        }
        GroovyFile groovyFile = (GroovyFile)psiFile;
        if (groovyFile.isScript()) {
            return GroovyScriptUtil.getScriptType(groovyFile).getRunner();
        }
        return new DefaultGroovyScriptRunner();
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            GroovyScriptRunConfiguration.$$$reportNull$$$0(0);
        }
        super.readExternal(element);
        this.scriptPath = ExternalizablePath.localPathValue((String)JDOMExternalizer.readString((Element)element, (String)"path"));
        this.vmParams = JDOMExternalizer.readString((Element)element, (String)"vmparams");
        this.scriptParams = JDOMExternalizer.readString((Element)element, (String)"params");
        String wrk = JDOMExternalizer.readString((Element)element, (String)"workDir");
        if (!".".equals(wrk)) {
            this.workDir = ExternalizablePath.localPathValue((String)wrk);
        }
        this.isDebugEnabled = Boolean.parseBoolean(JDOMExternalizer.readString((Element)element, (String)"debug"));
        this.isAddClasspathToTheRunner = Boolean.parseBoolean(JDOMExternalizer.readString((Element)element, (String)"addClasspath"));
        this.envs.clear();
        JDOMExternalizer.readMap((Element)element, this.envs, null, (String)"env");
        this.myAlternativeJrePathEnabled = JDOMExternalizer.readBoolean((Element)element, (String)"alternativeJrePathEnabled");
        this.myAlternativeJrePath = JDOMExternalizer.readString((Element)element, (String)"alternativeJrePath");
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GroovyScriptRunConfiguration.$$$reportNull$$$0(1);
        }
        super.writeExternal(element);
        JDOMExternalizer.write((Element)element, (String)"path", (String)ExternalizablePath.urlValue((String)this.scriptPath));
        JDOMExternalizer.write((Element)element, (String)"vmparams", (String)this.vmParams);
        JDOMExternalizer.write((Element)element, (String)"params", (String)this.scriptParams);
        JDOMExternalizer.write((Element)element, (String)"workDir", (String)ExternalizablePath.urlValue((String)this.workDir));
        JdomKt.addOptionTag((Element)element, (String)"debug", (String)Boolean.toString(this.isDebugEnabled), (String)"setting");
        if (this.isAddClasspathToTheRunner) {
            JdomKt.addOptionTag((Element)element, (String)"addClasspath", (String)Boolean.toString(true), (String)"setting");
        }
        JDOMExternalizer.writeMap((Element)element, this.envs, null, (String)"env");
        if (this.myAlternativeJrePathEnabled) {
            JdomKt.addOptionTag((Element)element, (String)"alternativeJrePathEnabled", (String)Boolean.toString(true), (String)"setting");
            if (StringUtil.isNotEmpty((String)this.myAlternativeJrePath)) {
                JdomKt.addOptionTag((Element)element, (String)"alternativeJrePath", (String)this.myAlternativeJrePath, (String)"setting");
            }
        }
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        VirtualFile scriptFile;
        if (executor == null) {
            GroovyScriptRunConfiguration.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            GroovyScriptRunConfiguration.$$$reportNull$$$0(3);
        }
        if ((scriptFile = ScriptFileUtil.findScriptFileByPath((String)this.getScriptPath())) == null) {
            return null;
        }
        final GroovyScriptRunner scriptRunner = this.getScriptRunner();
        if (scriptRunner == null) {
            return null;
        }
        return new JavaCommandLineState(environment){

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler handler = super.startProcess();
                handler.setShouldDestroyProcessRecursively(true);
                if (scriptRunner.shouldRefreshAfterFinish()) {
                    handler.addProcessListener(new ProcessListener(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (!ApplicationManager.getApplication().isDisposed()) {
                                VirtualFileManager.getInstance().asyncRefresh();
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$1$1", "processTerminated"));
                        }
                    });
                }
                OSProcessHandler oSProcessHandler = handler;
                if (oSProcessHandler == null) {
                    1.$$$reportNull$$$0(0);
                }
                return oSProcessHandler;
            }

            protected JavaParameters createJavaParameters() throws ExecutionException {
                Module module = GroovyScriptRunConfiguration.this.getModule();
                boolean tests = ProjectRootManager.getInstance((Project)GroovyScriptRunConfiguration.this.getProject()).getFileIndex().isInTestSourceContent(scriptFile);
                String jrePath = GroovyScriptRunConfiguration.this.isAlternativeJrePathEnabled() ? GroovyScriptRunConfiguration.this.getAlternativeJrePath() : null;
                JavaParameters params = new JavaParameters();
                params.setUseClasspathJar(true);
                params.setDefaultCharset(GroovyScriptRunConfiguration.this.getProject());
                params.setJdk(module == null ? JavaParametersUtil.createProjectJdk((Project)GroovyScriptRunConfiguration.this.getProject(), (String)jrePath) : JavaParametersUtil.createModuleJdk((Module)module, (!tests ? 1 : 0) != 0, (String)jrePath));
                ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)params, (CommonProgramRunConfigurationParameters)new CommonProgramRunConfigurationParametersDelegate((CommonProgramRunConfigurationParameters)GroovyScriptRunConfiguration.this){

                    @Override
                    @Nullable
                    public String getProgramParameters() {
                        return null;
                    }
                });
                scriptRunner.configureCommandLine(params, module, tests, scriptFile, GroovyScriptRunConfiguration.this);
                return params;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$1", "startProcess"));
            }
        };
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.scriptPath == null || !this.scriptPath.equals(GroovyScriptRunConfiguration.getPathByElement(element))) {
            return null;
        }
        PsiClass classToRun = GroovyRunnerPsiUtil.getRunningClass(element);
        if (element instanceof GroovyFile) {
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (newElement instanceof GroovyFile) {
                        GroovyFile file = (GroovyFile)newElement;
                        GroovyScriptRunConfiguration.this.setScriptPath(ScriptFileUtil.getScriptFilePath((VirtualFile)file.getVirtualFile()));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    this.elementRenamedOrMoved(newElement);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if (element instanceof PsiClass && element.getManager().areElementsEquivalent(element, (PsiElement)classToRun)) {
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    GroovyScriptRunConfiguration.this.setName(((PsiClass)newElement).getName());
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    this.elementRenamedOrMoved(newElement);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return null;
    }

    @Nullable
    private static String getPathByElement(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            GroovyScriptRunConfiguration.$$$reportNull$$$0(4);
        }
        if ((file = element.getContainingFile()) == null) {
            return null;
        }
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null) {
            return null;
        }
        return vfile.getPath();
    }

    public static JavaParameters createJavaParametersWithSdk(@Nullable Module module) {
        Sdk sdk;
        JavaParameters params = new JavaParameters();
        params.setCharset(null);
        if (module != null && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && sdk.getSdkType() instanceof JavaSdkType) {
            params.setJdk(sdk);
        }
        if (params.getJdk() == null) {
            params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
        }
        return params;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new GroovyRunConfigurationEditor(this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String scriptPath = this.getScriptPath();
        VirtualFile script = ScriptFileUtil.findScriptFileByPath((String)scriptPath);
        if (script == null) {
            throw new RuntimeConfigurationException(GroovyBundle.message("script.runner.cant.find.script", scriptPath));
        }
        GroovyScriptRunner scriptRunner = this.getScriptRunner();
        if (scriptRunner == null) {
            throw new RuntimeConfigurationException(GroovyBundle.message("script.runner.unknown.script.type", scriptPath));
        }
        scriptRunner.ensureRunnerConfigured(this);
        PsiFile file = PsiManager.getInstance((Project)this.getProject()).findFile(script);
        PsiClass toRun = GroovyRunnerPsiUtil.getRunningClass((PsiElement)file);
        if (toRun == null) {
            throw new RuntimeConfigurationWarning(GroovyBundle.message("script.runner.class.does.not.exist", new Object[0]));
        }
        if (toRun instanceof GrTypeDefinition) {
            if (!GroovyRunnerPsiUtil.canBeRunByGroovy(toRun)) {
                throw new RuntimeConfigurationWarning(GroovyBundle.message("script.runner.class.cannot.be.executed", new Object[0]));
            }
        } else {
            throw new RuntimeConfigurationWarning(GroovyBundle.message("script.runner.file.is.not.groovy.file", new Object[0]));
        }
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this);
    }

    public void setVMParameters(@Nullable String value) {
        this.vmParams = value;
    }

    public String getVMParameters() {
        return this.vmParams;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.myAlternativeJrePathEnabled;
    }

    public void setAlternativeJrePathEnabled(boolean alternativeJrePathEnabled) {
        this.myAlternativeJrePathEnabled = alternativeJrePathEnabled;
    }

    @Nullable
    public String getAlternativeJrePath() {
        return this.myAlternativeJrePath;
    }

    public void setAlternativeJrePath(@Nullable String alternativeJrePath) {
        this.myAlternativeJrePath = alternativeJrePath;
    }

    public String getRunClass() {
        return null;
    }

    public String getPackage() {
        return null;
    }

    public void setProgramParameters(@Nullable String value) {
        this.scriptParams = value;
    }

    public String getProgramParameters() {
        return this.scriptParams;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.workDir = value;
    }

    public String getWorkingDirectory() {
        return this.workDir;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            GroovyScriptRunConfiguration.$$$reportNull$$$0(5);
        }
        this.envs.clear();
        this.envs.putAll(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.envs;
        if (map2 == null) {
            GroovyScriptRunConfiguration.$$$reportNull$$$0(6);
        }
        return map2;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.passParentEnv = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.passParentEnv;
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.isDebugEnabled = debugEnabled;
    }

    public boolean isAddClasspathToTheRunner() {
        return this.isAddClasspathToTheRunner;
    }

    public void setAddClasspathToTheRunner(boolean addClasspathToTheRunner) {
        this.isAddClasspathToTheRunner = addClasspathToTheRunner;
    }

    @Nullable
    @NlsSafe
    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(@Nullable String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope superScope = super.getSearchScope();
        String path = this.getScriptPath();
        if (path == null) {
            return superScope;
        }
        final VirtualFile scriptFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (scriptFile == null) {
            return superScope;
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((Project)this.getProject(), (VirtualFile)scriptFile);
        if (superScope == null) {
            return fileScope;
        }
        return new DelegatingGlobalSearchScope(fileScope.union((SearchScope)superScope)){

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (file1.equals(scriptFile)) {
                    return 1;
                }
                if (file2.equals(scriptFile)) {
                    return -1;
                }
                return super.compare(file1, file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file2";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$4";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathByElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

