/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.BuilderAnnotationContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.builder.strategy.DefaultBuilderStrategySupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public final class ExternalBuilderStrategySupport
extends BuilderAnnotationContributor {
    public static final String EXTERNAL_STRATEGY_NAME = "ExternalStrategy";

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        PsiAnnotation annotation;
        if (context == null) {
            ExternalBuilderStrategySupport.$$$reportNull$$$0(0);
        }
        if (!ExternalBuilderStrategySupport.isApplicable(annotation = PsiImplUtil.getAnnotation((PsiModifierListOwner)context.getCodeClass(), "groovy.transform.builder.Builder"), EXTERNAL_STRATEGY_NAME)) {
            return;
        }
        PsiClass constructedClass = GrAnnotationUtil.inferClassAttribute(annotation, "forClass");
        if (constructedClass == null || "groovy.transform.Undefined.CLASS".equals(constructedClass.getQualifiedName())) {
            return;
        }
        boolean includeSuper = ExternalBuilderStrategySupport.isIncludeSuperProperties(annotation);
        if (constructedClass instanceof GrTypeDefinition) {
            PsiField[] fields;
            for (PsiField field2 : fields = ExternalBuilderStrategySupport.getFields((GrTypeDefinition)constructedClass, includeSuper, context)) {
                context.addMethod((PsiMethod)DefaultBuilderStrategySupport.createFieldSetter(context.getCodeClass(), (PsiVariable)field2, annotation, context));
            }
        } else {
            Collection properties = PropertyUtilBase.getAllProperties((PsiClass)constructedClass, (boolean)true, (boolean)false, (boolean)includeSuper).values();
            for (PsiMethod setter : properties) {
                LightMethodBuilder builderSetter = ExternalBuilderStrategySupport.createFieldSetter(context, setter, annotation);
                if (builderSetter == null) continue;
                context.addMethod((PsiMethod)builderSetter);
            }
        }
        context.addMethod((PsiMethod)DefaultBuilderStrategySupport.createBuildMethod(annotation, (PsiType)TypesUtil.createType(constructedClass)));
    }

    @Nullable
    public static LightMethodBuilder createFieldSetter(@NotNull TransformationContext context, @NotNull PsiMethod setter, @NotNull PsiAnnotation annotation) {
        if (context == null) {
            ExternalBuilderStrategySupport.$$$reportNull$$$0(1);
        }
        if (setter == null) {
            ExternalBuilderStrategySupport.$$$reportNull$$$0(2);
        }
        if (annotation == null) {
            ExternalBuilderStrategySupport.$$$reportNull$$$0(3);
        }
        GrTypeDefinition builderClass = context.getCodeClass();
        String name = PropertyUtilBase.getPropertyNameBySetter((PsiMethod)setter);
        PsiType type = PropertyUtilBase.getPropertyType((PsiMember)setter);
        if (type == null) {
            return null;
        }
        return DefaultBuilderStrategySupport.createFieldSetter(builderClass, name, type, annotation, (PsiElement)setter, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/ast/builder/strategy/ExternalBuilderStrategySupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTransformation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createFieldSetter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

