/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentsInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ResolvedVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.DFAFlowInfo;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InitialTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeAugmenter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;

class TypeDfaInstance
implements DfaInstance<TypeDfaState> {
    private final GroovyControlFlow myFlow;
    private final DFAFlowInfo myFlowInfo;
    private final InferenceCache myCache;
    private final PsiManager myManager;
    private final InitialTypeProvider myInitialTypeProvider;

    TypeDfaInstance(@NotNull GroovyControlFlow flow, @NotNull DFAFlowInfo flowInfo, @NotNull InferenceCache cache2, @NotNull PsiManager manager, @NotNull InitialTypeProvider typeProvider) {
        if (flow == null) {
            TypeDfaInstance.$$$reportNull$$$0(0);
        }
        if (flowInfo == null) {
            TypeDfaInstance.$$$reportNull$$$0(1);
        }
        if (cache2 == null) {
            TypeDfaInstance.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            TypeDfaInstance.$$$reportNull$$$0(3);
        }
        if (typeProvider == null) {
            TypeDfaInstance.$$$reportNull$$$0(4);
        }
        this.myFlow = flow;
        this.myManager = manager;
        this.myFlowInfo = flowInfo;
        this.myCache = cache2;
        this.myInitialTypeProvider = typeProvider;
    }

    @Override
    public TypeDfaState fun(@NotNull TypeDfaState state, @NotNull Instruction instruction) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(5);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(6);
        }
        TypeDfaState newState = instruction.num() == 0 ? this.handleStartInstruction() : (instruction instanceof ReadWriteVariableInstruction ? this.handleReadWriteVariable(state, (ReadWriteVariableInstruction)instruction) : (instruction instanceof MixinTypeInstruction ? this.handleMixin(state, (MixinTypeInstruction)instruction) : (instruction instanceof ArgumentsInstruction ? this.handleArguments(state, (ArgumentsInstruction)instruction) : (instruction instanceof NegatingGotoInstruction ? TypeDfaInstance.handleNegation(state, (NegatingGotoInstruction)instruction) : state))));
        this.myCache.publishDescriptor(newState, instruction);
        return newState;
    }

    private TypeDfaState handleStartInstruction() {
        TypeDfaState state = TypeDfaState.EMPTY_STATE;
        for (int descriptor : this.myFlowInfo.getInterestingDescriptors()) {
            PsiType initialType = this.myInitialTypeProvider.initialType(descriptor);
            if (initialType == null) continue;
            state = state.withNewType(descriptor, DFAType.create(initialType));
        }
        return state;
    }

    private static boolean hasNoChanges(@NotNull TypeDfaState baseDfaState, @NotNull Int2ObjectMap<DFAType> newDfaTypes) {
        if (baseDfaState == null) {
            TypeDfaInstance.$$$reportNull$$$0(7);
        }
        if (newDfaTypes == null) {
            TypeDfaInstance.$$$reportNull$$$0(8);
        }
        Int2ObjectMap<DFAType> oldMap = baseDfaState.getRawVarTypes();
        for (Int2ObjectMap.Entry entry : newDfaTypes.int2ObjectEntrySet()) {
            if (oldMap.containsKey(entry.getIntKey()) && ((DFAType)oldMap.get(entry.getIntKey())).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private TypeDfaState handleMixin(@NotNull TypeDfaState state, @NotNull MixinTypeInstruction instruction) {
        int descriptor;
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(9);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(10);
        }
        if ((descriptor = instruction.getVariableDescriptor()) == 0) {
            return state;
        }
        return this.updateVariableType(state, instruction, descriptor, () -> {
            ReadWriteVariableInstruction originalInstr = instruction.getInstructionToMixin(this.myFlow.getFlow());
            if (originalInstr != null) assert (!originalInstr.isWrite());
            return state.getNotNullDFAType(descriptor).withNewMixin(instruction.inferMixinType(), instruction.getConditionInstruction());
        });
    }

    private TypeDfaState handleReadWriteVariable(@NotNull TypeDfaState state, @NotNull ReadWriteVariableInstruction instruction) {
        PsiElement element;
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(11);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(12);
        }
        if ((element = instruction.getElement()) == null) {
            return state;
        }
        int descriptor = instruction.getDescriptor();
        if (instruction.isWrite()) {
            return this.updateVariableType(state, instruction, descriptor, () -> {
                PsiType initializerType = TypeInferenceHelper.getInitializerType(element);
                VariableDescriptor actualDescriptor = this.myFlow.getVarIndices()[descriptor];
                if (initializerType == null && actualDescriptor instanceof ResolvedVariableDescriptor && TypeInferenceHelper.isSimpleEnoughForAugmenting(this.myFlow.getFlow())) {
                    GrVariable variable = ((ResolvedVariableDescriptor)actualDescriptor).getVariable();
                    PsiType augmentedType = TypeAugmenter.Companion.inferAugmentedType(variable);
                    return DFAType.create(augmentedType);
                }
                return DFAType.create(initializerType);
            });
        }
        return state;
    }

    private TypeDfaState handleArguments(TypeDfaState state, ArgumentsInstruction instruction) {
        TypeDfaState newState = state;
        for (Map.Entry<Integer, Collection<Argument>> entry : instruction.getArguments().entrySet()) {
            int descriptor = entry.getKey();
            Collection<Argument> arguments2 = entry.getValue();
            newState = this.handleArgument(newState, instruction, descriptor, arguments2);
        }
        return newState;
    }

    private TypeDfaState handleArgument(TypeDfaState state, ArgumentsInstruction instruction, int descriptorId, Collection<Argument> arguments2) {
        return this.updateVariableType(state, instruction, descriptorId, () -> {
            GroovyResolveResult[] results;
            DFAType result2 = state.getNotNullDFAType(descriptorId);
            for (GroovyResolveResult variant : results = instruction.getElement().multiResolveGroovy(false)) {
                ArgumentMapping<PsiCallParameter> mapping;
                GroovyMethodCandidate candidate;
                if (!(variant instanceof GroovyMethodResult) || (candidate = ((GroovyMethodResult)variant).getCandidate()) == null || (mapping = candidate.getArgumentMapping()) == null) continue;
                for (Argument argument : arguments2) {
                    PsiType parameterType = mapping.expectedType(argument);
                    if (parameterType == null) continue;
                    PsiType typeToMixin = variant.getSubstitutor().substitute(parameterType);
                    result2 = result2.withNewMixin(typeToMixin, null);
                }
            }
            return result2;
        });
    }

    private TypeDfaState updateVariableType(@NotNull TypeDfaState state, @NotNull Instruction instruction, int descriptorId, @NotNull Supplier<DFAType> computation) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(13);
        }
        if (instruction == null) {
            TypeDfaInstance.$$$reportNull$$$0(14);
        }
        if (computation == null) {
            TypeDfaInstance.$$$reportNull$$$0(15);
        }
        if (descriptorId == 0) {
            return state;
        }
        if (!this.myFlowInfo.getInterestingInstructions().contains(instruction)) {
            return state.withRemovedBinding(descriptorId);
        }
        DFAType type = this.myCache.getCachedInferredType(descriptorId, instruction);
        if (type == null) {
            type = this.myFlowInfo.getAcyclicInstructions().contains(instruction) ? computation.get() : this.runWithoutCaching(state, computation);
        }
        return state.withNewType(descriptorId, type);
    }

    private <T> T runWithoutCaching(@NotNull TypeDfaState state, Supplier<? extends T> computation) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(16);
        }
        Map<VariableDescriptor, DFAType> unwrappedVariables = this.getCurrentVariableTypes(state);
        return TypeInferenceHelper.doInference(unwrappedVariables, computation);
    }

    @NotNull
    private Map<VariableDescriptor, DFAType> getCurrentVariableTypes(@NotNull TypeDfaState state) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(17);
        }
        HashMap<VariableDescriptor, DFAType> unwrappedVariables = new HashMap<VariableDescriptor, DFAType>();
        for (Int2ObjectMap.Entry entry : state.getRawVarTypes().int2ObjectEntrySet()) {
            if (state.isProhibited(entry.getIntKey())) continue;
            unwrappedVariables.put(this.myFlow.getVarIndices()[entry.getIntKey()], (DFAType)entry.getValue());
        }
        HashMap<VariableDescriptor, DFAType> hashMap = unwrappedVariables;
        if (hashMap == null) {
            TypeDfaInstance.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    private static TypeDfaState handleNegation(@NotNull TypeDfaState state, @NotNull NegatingGotoInstruction negation) {
        if (state == null) {
            TypeDfaInstance.$$$reportNull$$$0(19);
        }
        if (negation == null) {
            TypeDfaInstance.$$$reportNull$$$0(20);
        }
        TypeDfaState newState = state;
        for (Int2ObjectMap.Entry entry : state.getRawVarTypes().int2ObjectEntrySet()) {
            DFAType after;
            DFAType before = (DFAType)entry.getValue();
            if (before == (after = before.withNegated(negation))) continue;
            newState = newState.withNewType(entry.getIntKey(), after);
        }
        return newState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProvider";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDfaState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDfaTypes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaInstance";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/types/TypeDfaInstance";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentVariableTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fun";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasNoChanges";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleMixin";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleReadWriteVariable";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateVariableType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runWithoutCaching";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentVariableTypes";
                break;
            }
            case 18: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "handleNegation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }
}

