/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

public class ConditionInstruction
extends InstructionImpl
implements Instruction {
    private final boolean myNegated;
    private final Set<ConditionInstruction> myDependent;

    public ConditionInstruction(@NotNull PsiElement element, boolean negated, @NotNull Collection<ConditionInstruction> dependent) {
        if (element == null) {
            ConditionInstruction.$$$reportNull$$$0(0);
        }
        if (dependent == null) {
            ConditionInstruction.$$$reportNull$$$0(1);
        }
        super(element);
        this.myNegated = negated;
        this.myDependent = new LinkedHashSet<ConditionInstruction>(dependent);
        this.myDependent.add(this);
    }

    public boolean isNegated() {
        return this.myNegated;
    }

    @Override
    @NonNls
    @NotNull
    protected String getElementPresentation() {
        @NonNls StringBuilder builder = new StringBuilder();
        builder.append("Condition ").append(this.getElement());
        if (this.myNegated) {
            builder.append(", negated");
        }
        if (this.myDependent.size() > 1) {
            builder.append(", dependent: ");
            builder.append(StringUtil.join((Collection)ContainerUtil.filter(this.myDependent, d -> d != this), i2 -> String.valueOf(i2.num()), (String)", "));
        }
        String string = builder.toString();
        if (string == null) {
            ConditionInstruction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Set<ConditionInstruction> getDependentConditions() {
        return this.myDependent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ConditionInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ConditionInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

