/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;

public final class GroovyConstantNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyConstantNamingConventionInspection.$$$reportNull$$$0(0);
        }
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            String string = GroovyBundle.message("inspection.message.constant.name.ref.too.short", new Object[0]);
            if (string == null) {
                GroovyConstantNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            String string = GroovyBundle.message("inspection.message.constant.name.ref.too.long", new Object[0]);
            if (string == null) {
                GroovyConstantNamingConventionInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = GroovyBundle.message("inspection.message.constant.name.ref.doesnt.match.regex", this.getRegex());
        if (string == null) {
            GroovyConstantNamingConventionInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyConstantNamingConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyConstantNamingConventionInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitField(@NotNull GrField grField) {
            if (grField == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(grField);
            if (!grField.hasModifierProperty("static") || !grField.hasModifierProperty("final")) {
                return;
            }
            String name = grField.getName();
            if (GroovyConstantNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grField, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grField", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyConstantNamingConventionInspection$NamingConventionsVisitor", "visitField"));
        }
    }
}

