/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.ReturnPointCountVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMultipleReturnPointsPerMethodInspectionBase
extends GroovyMethodMetricInspection {
    public GroovyMultipleReturnPointsPerMethodInspectionBase() {
        super(1);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer returnPointCount = (Integer)infos[0];
        String string = GroovyBundle.message("inspection.message.ref.has.0.return.points", returnPointCount);
        if (string == null) {
            GroovyMultipleReturnPointsPerMethodInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleReturnPointsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMultipleReturnPointsPerMethodInspectionBase", "buildErrorString"));
    }

    private class MultipleReturnPointsVisitor
    extends BaseInspectionVisitor {
        private MultipleReturnPointsVisitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod method) {
            if (method == null) {
                MultipleReturnPointsVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            int returnPointCount = this.calculateReturnPointCount(method);
            if (returnPointCount <= GroovyMultipleReturnPointsPerMethodInspectionBase.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, returnPointCount);
        }

        private int calculateReturnPointCount(GrMethod method) {
            ReturnPointCountVisitor visitor2 = new ReturnPointCountVisitor();
            method.accept(visitor2);
            int count = visitor2.getCount();
            if (!MultipleReturnPointsVisitor.mayFallThroughBottom(method)) {
                return count;
            }
            GrOpenBlock body = method.getBlock();
            if (body == null) {
                return count;
            }
            GrStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return count + 1;
            }
            GrStatement lastStatement = statements[statements.length - 1];
            if (ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
                return count + 1;
            }
            return count;
        }

        private static boolean mayFallThroughBottom(GrMethod method) {
            if (method.isConstructor()) {
                return true;
            }
            PsiType returnType = method.getReturnType();
            return PsiTypes.voidType().equals((Object)returnType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMultipleReturnPointsPerMethodInspectionBase$MultipleReturnPointsVisitor", "visitMethod"));
        }
    }
}

