/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrRegex;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre18;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "version", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/lang/annotation/AnnotationHolder;Ljava/lang/String;)V", "visitTypeArgumentList", "", "typeArgumentList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrTypeArgumentList;", "visitMethodCall", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "visitRegexExpression", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrRegex;", "visitLiteralExpression", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;", "highlightMultilineSlashyString", "string", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGroovyAnnotatorPre18.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyAnnotatorPre18.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotatorPre18\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class GroovyAnnotatorPre18
extends GroovyElementVisitor {
    @NotNull
    private final AnnotationHolder holder;
    @NotNull
    private final String version;

    public GroovyAnnotatorPre18(@NotNull AnnotationHolder holder, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.holder = holder;
        this.version = version;
    }

    @Override
    public void visitTypeArgumentList(@NotNull GrTypeArgumentList typeArgumentList) {
        Intrinsics.checkNotNullParameter((Object)typeArgumentList, (String)"typeArgumentList");
        if (typeArgumentList.isDiamond()) {
            Object[] objectArray = new Object[]{this.version};
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.diamonds.0", objectArray)).create();
        }
    }

    @Override
    public void visitMethodCall(@NotNull GrMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (call.isCommandExpression()) {
            Object[] objectArray = new Object[]{this.version};
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.command.syntax.0", objectArray)).create();
        }
    }

    @Override
    public void visitRegexExpression(@NotNull GrRegex expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IElementType iElementType = expression.getNode().getFirstChildNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType tokenType = iElementType;
        if (Intrinsics.areEqual((Object)tokenType, (Object)GroovyElementTypes.DOLLAR_SLASHY_BEGIN)) {
            Object[] objectArray = new Object[]{this.version};
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.dollar.slashy.string.0", objectArray)).create();
        } else if (Intrinsics.areEqual((Object)tokenType, (Object)GroovyElementTypes.SLASHY_BEGIN)) {
            this.highlightMultilineSlashyString(expression);
        }
    }

    @Override
    public void visitLiteralExpression(@NotNull GrLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        IElementType iElementType = literal.getNode().getFirstChildNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType tokenType = iElementType;
        if (Intrinsics.areEqual((Object)tokenType, (Object)((Object)GroovyElementTypes.DOLLAR_SLASHY_LITERAL))) {
            Object[] objectArray = new Object[]{this.version};
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.dollar.slashy.string.0", objectArray)).create();
        } else if (Intrinsics.areEqual((Object)tokenType, (Object)((Object)GroovyElementTypes.SLASHY_LITERAL))) {
            this.highlightMultilineSlashyString(literal);
        }
    }

    private final void highlightMultilineSlashyString(GroovyPsiElement string) {
        String it = string.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        boolean bl2 = StringsKt.contains$default((CharSequence)it, (CharSequence)"\n", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"\r", (boolean)false, (int)2, null);
        if (bl2) {
            Object[] objectArray = new Object[]{this.version};
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("unsupported.multiline.slashy.string.0", objectArray)).create();
        }
    }
}

