/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.tools;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.tools.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

final class GenerateSchemaFromInstanceDocumentDialog
extends DialogWrapper {
    private JPanel panel;
    private TextFieldWithBrowseButton generateFromUrl;
    private JLabel status;
    private JLabel statusText;
    private JLabel generateFromUrlText;
    private JLabel designTypeText;
    private JTextField detectEnumerationsLimit;
    private ComboBox detectSimpleContentTypes;
    private ComboBox designType;
    private JLabel detectEnumerationsLimitText;
    private JLabel detectSimpleContentTypesText;
    private JLabel resultSchemaFileNameText;
    private JTextField resultSchemaFileName;
    private static final List<String> designTypes = Arrays.asList(GenerateSchemaFromInstanceDocumentDialog.getLocalElementsGlobalComplexTypes(), GenerateSchemaFromInstanceDocumentDialog.getLocalElementsTypes(), GenerateSchemaFromInstanceDocumentDialog.getGlobalElementsLocalTypes());
    static final String STRING_TYPE = "string";
    static final String SMART_TYPE = "smart";
    private static final List<String> simpleContentTypes = Arrays.asList("string", "smart");
    private Runnable myOkAction;

    GenerateSchemaFromInstanceDocumentDialog(Project project, VirtualFile file) {
        super(project, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(XmlBundle.message((String)"generate.schema.from.instance.document.dialog.title", (Object[])objectArray));
        this.doInitFor(this.designTypeText, (JComponent)this.designType);
        GenerateSchemaFromInstanceDocumentDialog.configureComboBox((JComboBox)this.designType, designTypes);
        this.doInitFor(this.detectSimpleContentTypesText, (JComponent)this.detectSimpleContentTypes);
        GenerateSchemaFromInstanceDocumentDialog.configureComboBox((JComboBox)this.detectSimpleContentTypes, simpleContentTypes);
        this.doInitFor(this.detectEnumerationsLimitText, this.detectEnumerationsLimit);
        this.detectEnumerationsLimit.setText("10");
        UIUtils.configureBrowseButton(project, this.generateFromUrl, "xml", XmlBundle.message((String)"select.xml.document.dialog.title", (Object[])new Object[0]), false);
        this.doInitFor(this.generateFromUrlText, this.generateFromUrl.getTextField());
        this.doInitFor(this.resultSchemaFileNameText, this.resultSchemaFileName);
        this.init();
        this.generateFromUrl.setText(file.getPresentableUrl());
        this.resultSchemaFileName.setText(file.getNameWithoutExtension() + ".xsd");
    }

    private void validateData() {
        String msg = this.doValidateWithData();
        this.setOKActionEnabled(msg == null);
        this.status.setText(msg == null ? "" : msg);
        this.status.setForeground((Color)JBColor.RED);
    }

    public static void configureComboBox(JComboBox combo, List<String> lastValues) {
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(lastValues)));
        if (combo.getItemCount() != 0) {
            combo.setSelectedIndex(0);
            combo.getEditor().selectAll();
        }
    }

    public void setFileUrl(@NlsSafe String url) {
        this.generateFromUrl.setText(url);
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.myOkAction != null) {
            this.myOkAction.run();
        }
    }

    public void setOkAction(Runnable okAction) {
        this.myOkAction = okAction;
    }

    public void doInitFor(JLabel textComponent, JComponent component) {
        textComponent.setLabelFor(component);
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                }
            });
        } else if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                }
            });
            if (jComboBox.isEditable()) {
                jComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                    }
                });
            }
        }
    }

    TextFieldWithBrowseButton getUrl() {
        return this.generateFromUrl;
    }

    private JLabel getUrlText() {
        return this.generateFromUrlText;
    }

    private JLabel getStatusTextField() {
        return this.statusText;
    }

    private JLabel getStatusField() {
        return this.status;
    }

    protected JComponent createCenterPanel() {
        return this.panel;
    }

    String getDesignType() {
        return (String)this.designType.getSelectedItem();
    }

    String getSimpleContentType() {
        return (String)this.detectSimpleContentTypes.getSelectedItem();
    }

    String getEnumerationsLimit() {
        return this.detectEnumerationsLimit.getText();
    }

    public String getTargetSchemaName() {
        return this.resultSchemaFileName.getText();
    }

    @InspectionMessage
    private String doValidateWithData() {
        if (!new File(this.generateFromUrl.getText()).exists()) {
            return XmlBundle.message((String)"instance.document.file.is.not.exist", (Object[])new Object[0]);
        }
        if (!this.generateFromUrl.getText().endsWith(".xml")) {
            return XmlBundle.message((String)"instance.document.file.should.have.xml.extension", (Object[])new Object[0]);
        }
        try {
            int i = Integer.parseInt(this.getEnumerationsLimit());
            if (i < 0) {
                return XmlBundle.message((String)"negative.number.validation.problem", (Object[])new Object[0]);
            }
        }
        catch (NumberFormatException ex) {
            return XmlBundle.message((String)"invalid.number.validation.problem", (Object[])new Object[0]);
        }
        if (this.getTargetSchemaName() == null || this.getTargetSchemaName().isEmpty()) {
            return XmlBundle.message((String)"result.schema.file.name.is.empty.validation.problem", (Object[])new Object[0]);
        }
        return null;
    }

    @NotNull
    protected String getHelpId() {
        return "webservices.GenerateSchemaFromInstanceDocument";
    }

    static String getLocalElementsGlobalComplexTypes() {
        return XmlBundle.message((String)"local.elements.global.complex.types.option.name", (Object[])new Object[0]);
    }

    static String getLocalElementsTypes() {
        return XmlBundle.message((String)"local.elements.types.option.name", (Object[])new Object[0]);
    }

    static String getGlobalElementsLocalTypes() {
        return XmlBundle.message((String)"global.elements.local.types.option.name", (Object[])new Object[0]);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        ComboBox comboBox;
        ComboBox comboBox2;
        JTextField jTextField2;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(1, 1, 1, 1), -1, -1, false, false));
        this.generateFromUrlText = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("instance2schema.dialog.instance.document.path"));
        jLabel7.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.instance2schema.url.tooltip"));
        jPanel.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.statusText = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("any.dialog.status"));
        jLabel6.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("webservice.status.tooltip"));
        jPanel.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.status = jLabel5 = new JLabel();
        ((Component)jLabel5).setForeground(new Color(-65536));
        jLabel5.setText("");
        jLabel5.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("webservice.status.tooltip"));
        jPanel.add((Component)jLabel5, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.generateFromUrl = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.instance2schema.url.tooltip"));
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.designTypeText = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("instance2schema.dialog.design.type"));
        jLabel4.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.designtype.tooltip"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.detectSimpleContentTypesText = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("instance2schema.dialog.detect.simple.content.type"));
        jLabel3.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.simplecontenttype.tooltip"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.detectEnumerationsLimitText = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("instance2schema.dialog.detect.enumerations.limit"));
        jLabel2.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.enumerations.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.detectEnumerationsLimit = jTextField2 = new JTextField();
        jTextField2.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.enumerations.tooltip"));
        jPanel.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.detectSimpleContentTypes = comboBox2 = new ComboBox();
        comboBox2.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.simplecontenttype.tooltip"));
        jPanel.add((Component)comboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.designType = comboBox = new ComboBox();
        comboBox.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.designtype.tooltip"));
        jPanel.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.resultSchemaFileNameText = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xml.generate.schema.dialog.label.result.schema.file.name"));
        jLabel.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.instance2schema.result.schema.name"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.resultSchemaFileName = jTextField = new JTextField();
        jTextField.setToolTipText(DynamicBundle.getBundle((String)"messages/XmlBundle", GenerateSchemaFromInstanceDocumentDialog.class).getString("xmlbeans.enumerations.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel2.setLabelFor(jTextField2);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

