/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadErrorReporterImplementation;
import com.intellij.coverage.CoverageLoadingListener;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.DummyCoverageLoadErrorReporter;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.coverage.SuccessCoverageLoadingResult;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageRunner {
    private static final Logger LOG = Logger.getInstance(CoverageRunner.class);
    public static final ExtensionPointName<CoverageRunner> EP_NAME = ExtensionPointName.create((String)"com.intellij.coverageRunner");

    @Deprecated
    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        if (sessionDataFile == null) {
            CoverageRunner.$$$reportNull$$$0(0);
        }
        throw new IllegalStateException("Should not be called, please override loadCoverageDataWithLogging");
    }

    @Nullable
    public final ProjectData loadCoverageDataWithReporting(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        CoverageLoadingResult result;
        if (sessionDataFile == null) {
            CoverageRunner.$$$reportNull$$$0(1);
        }
        if (baseCoverageSuite == null) {
            return this.loadCoverageData(sessionDataFile, null, new DummyCoverageLoadErrorReporter()).getProjectData();
        }
        CoverageLoadingListener listener = (CoverageLoadingListener)baseCoverageSuite.getProject().getMessageBus().syncPublisher(CoverageLoadingListener.COVERAGE_TOPIC);
        listener.coverageLoadingStarted(sessionDataFile);
        try {
            result = this.loadCoverageData(sessionDataFile, baseCoverageSuite, new CoverageLoadErrorReporterImplementation(listener, sessionDataFile));
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOG.warn((Throwable)e);
            result = new FailedCoverageLoadingResult(e, true);
        }
        listener.reportCoverageLoaded(result, sessionDataFile);
        return result.getProjectData();
    }

    @ApiStatus.OverrideOnly
    @NotNull
    protected CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        ProjectData data;
        if (sessionDataFile == null) {
            CoverageRunner.$$$reportNull$$$0(2);
        }
        if (reporter == null) {
            CoverageRunner.$$$reportNull$$$0(3);
        }
        if ((data = this.loadCoverageData(sessionDataFile, baseCoverageSuite)) == null) {
            return new FailedCoverageLoadingResult("Couldn't load coverage data");
        }
        return new SuccessCoverageLoadingResult(data);
    }

    @NotNull
    @NonNls
    public abstract String getPresentableName();

    @NotNull
    @NonNls
    public abstract String getId();

    @NotNull
    @NonNls
    public abstract String getDataFileExtension();

    public @NonNls String @NotNull [] getDataFileExtensions() {
        String[] stringArray = new String[]{this.getDataFileExtension()};
        if (stringArray == null) {
            CoverageRunner.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public boolean canBeLoaded(@NotNull File candidate) {
        if (candidate == null) {
            CoverageRunner.$$$reportNull$$$0(5);
        }
        return true;
    }

    public abstract boolean acceptsCoverageEngine(@NotNull CoverageEngine var1);

    public static <T extends CoverageRunner> T getInstance(@NotNull Class<T> coverageRunnerClass) {
        if (coverageRunnerClass == null) {
            CoverageRunner.$$$reportNull$$$0(6);
        }
        for (CoverageRunner coverageRunner : EP_NAME.getExtensionList()) {
            if (!coverageRunnerClass.isInstance(coverageRunner)) continue;
            return (T)((CoverageRunner)coverageRunnerClass.cast(coverageRunner));
        }
        assert (false);
        return null;
    }

    @ApiStatus.Internal
    public boolean isCoverageByTestApplicable() {
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    public static CoverageRunner getInstanceById(@NotNull String id) {
        if (id == null) {
            CoverageRunner.$$$reportNull$$$0(7);
        }
        for (CoverageRunner coverageRunner : EP_NAME.getExtensionList()) {
            if (!coverageRunner.getId().equals(id)) continue;
            return coverageRunner;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageRunnerClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFileExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageDataWithReporting";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBeLoaded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceById";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

