/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.metadata;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/metadata/DynamicTypeDeserializer;", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "<init>", "()V", "id", "", "create", "Lorg/jetbrains/kotlin/types/KotlinType;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "flexibleId", "lowerBound", "Lorg/jetbrains/kotlin/types/SimpleType;", "upperBound", "ir.serialization.common"})
public final class DynamicTypeDeserializer
implements FlexibleTypeDeserializer {
    @NotNull
    public static final DynamicTypeDeserializer INSTANCE = new DynamicTypeDeserializer();
    @NotNull
    public static final String id = "kotlin.DynamicType";

    private DynamicTypeDeserializer() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public KotlinType create(@NotNull ProtoBuf.Type proto, @NotNull String flexibleId, @NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)flexibleId, (String)"flexibleId");
        Intrinsics.checkNotNullParameter((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
        if (!Intrinsics.areEqual((Object)flexibleId, (Object)id)) {
            String[] stringArray = new String[]{flexibleId, lowerBound.toString(), upperBound.toString()};
            return (KotlinType)ErrorUtils.createErrorType((ErrorTypeKind)ErrorTypeKind.UNEXPECTED_FLEXIBLE_TYPE_ID, (String[])stringArray);
        }
        SimpleType simpleType = TypeUtilsKt.getBuiltIns((KotlinType)((KotlinType)lowerBound)).getNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getNothingType(...)");
        if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(lowerBound, simpleType)) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns((KotlinType)((KotlinType)upperBound)).getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getNullableAnyType(...)");
            if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(upperBound, simpleType2)) {
                kotlinType = (KotlinType)DynamicTypesKt.createDynamicType((KotlinBuiltIns)TypeUtilsKt.getBuiltIns((KotlinType)((KotlinType)lowerBound)));
                return kotlinType;
            }
        }
        String[] stringArray = new String[]{lowerBound.toString(), upperBound.toString()};
        kotlinType = (KotlinType)ErrorUtils.createErrorType((ErrorTypeKind)ErrorTypeKind.ILLEGAL_TYPE_RANGE_FOR_DYNAMIC, (String[])stringArray);
        return kotlinType;
    }
}

